<?php
/**
 * @var $this WCDRP_Template
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

global $woocommerce_loop;
$woocommerce_loop['loop'] = 0;

$options          = $this->options;
$products         = $this->products;
$this->is_slider  = ( '1' == $options['wcdrp-appearance']['block_layout'] ) ? 1 : 0;
$default_template = ( int ) $options['wcdrp-appearance']['original_template'];
$id               = "wcdrp-{$this->rule_id}";

do_action( 'wcdrp_before_display_linked_products' );

$div_classes = apply_filters( 'wc_alp_related_products_container_classes', array('products') );

if ( $products->have_posts() ) :
    ?>
<div class="<?php echo implode( ' ', $div_classes); ?>">
        <h2><?php echo $options['wcdrp-appearance']['block_title'] ?></h2>
        <ul id="<?php echo $id ?>"
            class="products <?php
            if ( $this->is_slider ): echo ' wcdrp-products-slider owl-carousel owl-theme';
            endif;
            ?>">
                <?php while ( $products->have_posts() ) : $products->the_post(); ?>
                    <?php
                    if ( $default_template == 1 ) {
                        include( WC()->plugin_path() . "/templates/content-product.php" );
                    } elseif ( $default_template == 0 ) {
                        wc_get_template_part( 'content', 'product' );
                    } else {
                        //look for template in theme
                        $template = locate_template( "linked-products.php" );
                        //look for template in plugin
                        if ( !$template ) {
                            $template = dirname( __FILE__ ) . "/linked-products.php";
                        }
                        if ( $template ) {
                            include( $template );
                        }
                    }
                    ?>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
                <?php do_action( 'after_products_while', $products, $options ); ?>
        </ul>
    </div>
    <?php
endif;
do_action( 'wcdrp_after_display_linked_products' );
wp_reset_postdata();
