<?php
/**
 * class-affiliates-admin-user-profile.php
 *
 * Copyright (c) 2010 - 2015 "kento" Karim Rahimpur www.itthinx.com
 *
 * This code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * This header and all notices must be kept intact.
 *
 * @author Karim Rahimpur
 * @package affiliates
 * @since affiliates 2.8.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Shows affiliates user meta info on user profile pages.
 */
class Affiliates_Admin_User_Profile {

	/**
	 * Adds user profile actions.
	 */
	public static function init() {
		add_action( 'show_user_profile', array( __CLASS__, 'show_user_profile' ) );
		add_action( 'edit_user_profile', array( __CLASS__, 'edit_user_profile' ) );
		add_action( 'personal_options_update', array( __CLASS__, 'personal_options_update' ) );
		add_action( 'edit_user_profile_update', array( __CLASS__, 'edit_user_profile_update' ) );
		add_action( 'profile_update', array( __CLASS__, 'profile_update' ), 10, 2 );
		//add_action( 'admin_enqueue_scripts', array( __CLASS__, 'admin_enqueue_scripts' ) );
	}

	/**
	 * Use to enqueue styles and scripts if needed on user-edit and profile screens.
	 */
	public static function admin_enqueue_scripts() {
		$screen = get_current_screen();
		if ( isset( $screen->id ) ) {
			switch( $screen->id ) {
				case 'user-edit' :
				case 'profile' :
					// ...
					break;
			}
		}
	}

	/**
	 * Own profile.
	 *
	 * @param WP_User $user
	 */
	public static function show_user_profile( $user ) {
		self::edit_user_profile( $user );
	}

	/**
	 * Editing a user profile.
	 *
	 * @param WP_User $user
	 */
	public static function edit_user_profile( $user ) {

		if ( !affiliates_user_is_affiliate( $user->ID ) ) {
			return;
		}

		$output = '';

		$output .= '<h3>';
		$output .= __( 'Affiliate Information', 'affiliates' );
		$output .= '</h3>';

		require_once AFFILIATES_CORE_LIB . '/class-affiliates-settings.php';
		require_once AFFILIATES_CORE_LIB . '/class-affiliates-settings-registration.php';
		$registration_fields = Affiliates_Settings_Registration::get_fields();

		// remove fields not stored as user meta
		foreach( Affiliates_Registration::get_skip_meta_fields() as $key ) {
			unset( $registration_fields[$key] );
		}
		unset( $registration_fields['first_name'] );
		unset( $registration_fields['last_name'] );
		$n = 0;
		if ( !empty( $registration_fields ) ) {
			$output .= '<table class="form-table">';
			$output .= '</body>';
			foreach( $registration_fields as $name => $field ) {
				if ( $field['enabled'] ) {
					$n++;
					$output .= '<tr>';
					$output .= '<th>';
					$output .= sprintf( '<label for="%s">', esc_attr( $name ) );
					$output .= esc_html( stripslashes( $field['label'] ) ); // @todo i18n
					$output .= '</label>';
					$output .= '</th>';
					$output .= '<td>';
					$type = isset( $field['type'] ) ? $field['type'] : 'text';
					$value = get_user_meta( $user->ID, $name , true );
					$output .= sprintf(
							'<input type="%s" class="%s" name="%s" value="%s" %s />',
							esc_attr( $type ),
							'regular-text ' . esc_attr( $name ) . ( $field['required'] ? ' required ' : '' ),
							esc_attr( $name ),
							esc_attr( stripslashes( $value ) ),
							$field['required'] ? ' required="required" ' : ''
					);
					$output .= '</td>';
					$output .= '</tr>';
				}
			}
			$output .= '</tbody>';
			$output .= '</table>';
		}
		if ( $n == 0 ) {
			$output .= '<p>';
			$output .= __( 'No specific affiliate information is available.', 'affiliates' );
			$output .= '</p>';
		}
		echo $output;
	}

	/**
	 * Updates user meta when a user's own profile is saved.
	 *
	 * @param int $user_id
	 */
	public static function personal_options_update( $user_id ) {
		self::edit_user_profile_update( $user_id );
	}

	/**
	 * Updates the user meta.
	 *
	 * @param int $user_id
	 */
	public static function edit_user_profile_update( $user_id ) {

		global $wpdb;

		if ( !affiliates_user_is_affiliate( $user_id ) ) {
			return;
		}

		require_once AFFILIATES_CORE_LIB . '/class-affiliates-settings.php';
		require_once AFFILIATES_CORE_LIB . '/class-affiliates-settings-registration.php';
		$registration_fields = Affiliates_Settings_Registration::get_fields();

		// remove fields not stored as user meta
		foreach( Affiliates_Registration::get_skip_meta_fields() as $key ) {
			unset( $registration_fields[$key] );
		}
		unset( $registration_fields['first_name'] );
		unset( $registration_fields['last_name'] );

		// update user meta
		if ( !empty( $registration_fields ) ) {
			foreach( $registration_fields as $name => $field ) {
				$meta_value = isset( $_POST[$name] ) ? $_POST[$name] : '';
				$meta_value = Affiliates_Utility::filter( $meta_value );
				update_user_meta( $user_id, $name, maybe_unserialize( $meta_value ) );
			}
		}

		// The affiliate entry must be updated using the profile_update action
		// as we don't have the updated user info here yet.

	}

	/**
	 * Updates the affiliate entry.
	 *
	 * @param int $user_id
	 * @param array $old_userdata
	 */
	public static function profile_update( $user_id, $old_userdata ) {

		global $wpdb;

		// update affiliate entry
		$affiliate_ids = affiliates_get_user_affiliate( $user_id );
		if ( !empty( $affiliate_ids ) ) {
			if ( $affiliate_id = array_shift( $affiliate_ids ) ) {
				if ( $user = get_userdata( $user_id ) ) {
					// @since 4.17.0 don't smash the affiliate name if the user's name data is empty
					$affiliate = affiliates_get_affiliate( $affiliate_id );
					$affiliate_name = !empty( $affiliate['name'] ) ? $affiliate['name'] : '';
					$new_affiliate_name = trim( $user->first_name . ' ' . $user->last_name );
					if ( strlen( $new_affiliate_name ) === 0 ) {
						$new_affiliate_name = $affiliate_name;
					}
					$affiliates_table = _affiliates_get_tablename( 'affiliates' );
					$query = $wpdb->prepare(
							"UPDATE $affiliates_table SET name = %s, email = %s WHERE affiliate_id = %d",
							$new_affiliate_name,
							$user->user_email,
							intval( $affiliate_id )
					);
					if ( $wpdb->query( $query ) ) {
						do_action( 'affiliates_updated_affiliate', $affiliate_id );
					}
				}
			}
		}
	}
}
Affiliates_Admin_User_Profile::init();
