<?php

class MySqlTable {
	
	var $link;
	var $db_name;
	var $verbose; //when set to 1 echo the SQL queries
	
	function __construct($options=array()) {
		$this->verbose = $options['verbose'];
		//Establish the DB Connection
		$c1 = Db_connection::getInstance();
		$db_connection = $c1->getDbConnection();
		$this->link = $db_connection['link'];
		$this->db_name = $db_connection['db_name'];
	}
	
	//Executes a custom SELECT query and returns the results in an array
	public function customQuery($query) {
		return $this->getResultsFromQuery($query);
	}
	
	//Escapes the variable to protect against SQL injections
	public function escape($value) {
		$value = mysqli_real_escape_string($this->link, $value);
		return $value;
	}
	
	//Returns the inserted id, or FALSE if it fails
	public function insert($table_name='', $data=array(), $options=array()) {
		$onDuplicateUpdate = $options['onDuplicateKeyUpdate'];
		
		if($table_name!='' && count($data)>0) {
			
			//Construct the query
			$query = "INSERT INTO " . $table_name . " (";
			$s = "";
			foreach($data as $key => $value) {
				if($value || is_numeric($value)) {
					$query.= $s.$key;
					$s = ", ";
				}
			}
			$query .= ") VALUES (";
			$s = "";
			foreach($data as $value) {
				if($value || is_numeric($value)) {
					$query.= $s."'".$this->escape($value)."'";
					$s = ", ";
				}
			}
			$query .= ")";
			
			if(is_array($onDuplicateUpdate) && count($onDuplicateUpdate)>0) {
				$i=0;
				foreach($onDuplicateUpdate as $value) {
					$onDuplicateUpdate[$i] = $value.'=VALUES('.$value.')';
					$i++;
				}
				$query .= ' ON DUPLICATE KEY UPDATE ';
				$query .= implode(', ', $onDuplicateUpdate);
			}
			
			if($this->verbose) echo $query.'<br>';
			
			//Execute the query
			$result = $this->executeQuery($query);
			if($result) $result = mysqli_insert_id($this->link);
		}
		else {
			$result = false;
		}
				
		return $result;
	}
	
	//Update rows by condition - Return values: number of affected rows or false (error)
	public function update($table_name='', $data=array(), $where=array()) {
		
		if($table_name!='' && count($data)>0 && count($where)>0) {
			
			//Construct the query
			$query = "UPDATE " . $table_name . " SET ";
			$s = "";
			foreach($data as $ind=>$value) {
				$query .= $s . $ind . " = '" . $this->escape($value) . "'";
				$s = ", ";
			}
			$tmp = '';
			$query .= ' WHERE ';
			foreach($where as $ind=>$value) {
				$query .= $tmp . $ind . '="' . $this->escape($value) . '"';
				$tmp = ' AND ';
			}
			
			if($this->verbose) echo $query.'<br>';
			
			//Execute the query
			$result = $this->executeQuery($query);
			if($result) {
				$nb_rows = mysqli_affected_rows($this->link);
				if($nb_rows>0) {
					$result = $nb_rows;
				}
				else {
					$result = 0;
				}
			}
		}
		else {
			$result = false;
		}
		
		return $result;
	}
	
	//Delete rows by conditions - Return values: number of affected rows or false (error)
	public function delete($table_name='', $where=array()) {
		
		if($table_name!='' && count($where)>0) {
			
			//Construct the query
			$query = "DELETE FROM " . $table_name . " WHERE ";
			$tmp = '';
			foreach($where as $ind=>$value) {
				$query .= $tmp.$ind.'="'.$this->escape($value).'"';
				$tmp = ' AND ';
			}
			
			if($this->verbose) echo $query.'<br>';
			
			//Execute the query
			$result = $this->executeQuery($query);
			if($result) {
				$nb_rows = mysqli_affected_rows($this->link);
				if($nb_rows>0) {
					$result = $nb_rows;
				}
				else {
					$result = 0;
				}
			}
		}
		else {
			$result = false;
		}
		
		return $result;
	}
	
	//Execute query (update, delete etc) and return the execution results
	public function executeQuery($query) {
		mysqli_select_db($this->link, $this->db_name);
		$result = mysqli_query($this->link, $query);
		if($result===false) {
			printf("Error: %s\n", mysqli_error($this->link));
			exit();
		}
		return $result;
	}
	
	//Execute the query and return the results in an array
	private function getResultsFromQuery($query) {
		$result = $this->executeQuery($query);
		$return = array();
		while ($rows = mysqli_fetch_assoc($result)) {
			$return[] = $rows;
		}
		return $return;
	}
}

?>
