<?php

function getMonthlyUsers() {
	$db = new MySqlTable();
	
	$sql = "
	CREATE TEMPORARY TABLE IF NOT EXISTS usersPerDate (
		date char(8) NOT NULL DEFAULT '',
		nicerDate char(10) NOT NULL DEFAULT '',
		facebook int(11) NOT NULL DEFAULT 0,
		PRIMARY KEY (date)
	);
	";
	$db->executeQuery($sql);
	
	$sql = "
	INSERT INTO usersPerDate (date, nicerDate, facebook)
	SELECT date_format(created, '%Y/%m') date, date_format(created, '%m/%Y'), count(1)
	FROM {$GLOBALS['db_table']['fb_users']}
	GROUP BY date;
	";
	$db->executeQuery($sql);
	
	$sql = "
	SELECT nicerDate, facebook FROM usersPerDate ORDER BY date DESC limit 6
	";
	$monthlyUsers = $db->customQuery($sql);
	
	return $monthlyUsers;
}

function get_fb_users($criteria=array()) {
	$id = $criteria['id'];
	$fb_id = $criteria['fb_id'];
	$page_number = $criteria['page_number'];
	$nb_display = $criteria['nb_display'];
	
	if($pageNumber=='') $pageNumber=1;
	if($nb_display>0) $start = $page_number*$nb_display-$nb_display;
	
	$m1 = new MySqlTable();
	$sql = "SELECT * FROM ".$GLOBALS['db_table']['fb_users']." WHERE 1 ";
	
	if($id!='') $sql .= " AND id='".$m1->escape($id)."'";
	if($fb_id!='') $sql .= " AND fb_id='".$m1->escape($fb_id)."'";
	
	$sql .= " ORDER BY last_connect DESC, id DESC";
	
	if($nb_display!='') $sql .= " LIMIT $start, $nb_display";
	
	$result = $m1->customQuery($sql);
	
	return $result;
}

function get_nb_fb_users($criteria=array()) {
	
	$m1 = new MySqlTable();
	$sql = "SELECT count(1) nb FROM ".$GLOBALS['db_table']['fb_users']." WHERE 1 ";
	$result = $m1->customQuery($sql);
	
	return $result[0]['nb'];
}

function get_settings($criteria=array()) {
	$meta_key = $criteria['meta_key'];
	
	$s1 = new MySqlTable();
	$sql = "SELECT * FROM ".$GLOBALS['db_table']['settings']." WHERE 1";
	if($meta_key!='') $sql .= " AND meta_key='".$s1->escape($meta_key)."'";
	
	$result = $s1->customQuery($sql);
	
	for($i=0; $i<count($result); $i++) {
		$settings[$result[$i]['meta_key']] = $result[$i]['meta_value'];
	}
	
	return $settings;
}

function delete_setting($key) {
	$s1 = new MySqlTable();
	$sql = "DELETE FROM ".$GLOBALS['db_table']['settings']." WHERE meta_key='".$s1->escape($key)."'";
	$s1->executeQuery($sql);
}

function add_setting($key, $value) {
	if($key!='') {
		$s1 = new MySqlTable();
		$result = get_settings(array('meta_key'=>$key));
		if(count($result)>0) {
			$sql = "UPDATE ".$GLOBALS['db_table']['settings']." SET meta_value='".$s1->escape($value)."' WHERE meta_key='".$s1->escape($key)."'";
			$s1->executeQuery($sql);
		}
		else {
			$sql = "INSERT INTO ".$GLOBALS['db_table']['settings']." (meta_key, meta_value) VALUES ('".$s1->escape($key)."', '".$s1->escape($value)."')";
			$s1->executeQuery($sql);
		}
	}
}

?>