<?php

function getPagination($criteria=array()) {
	$pageNumber = $criteria['pageNumber'];
	$nbResult = $criteria['nbResult'];
	$nb_display = $criteria['nbDisplay'];
	$nbPageMax = $criteria['nbPageMax'];
	
	$nbTotal = $nbResult;
	$start = ($pageNumber*$nb_display)-$nb_display;
	if($nb_display=='') $nb_display = 10;
	
	if(count($_GET)>0) {
		$nb = count($_GET);
		foreach($_GET as $ind=>$value) {
			if($ind!='page') {
				$getParam .= $ind.'='.$value.'&';
			}
		}
		$getParam = '?'.substr($getParam,0,-1).'';
	}
	else {
		$getParam = '?';
	}
	
	if($nbPageMax=='') $nbPageMax=7;
	
	// Pagination display
	if($nb_display!=0) $begin = $start/$nb_display;
	$debut = $begin-round($nbPageMax/2);
	$fin = $begin+round($nbPageMax/2);
	if($nb_display!=0) $nbPageResult = $nbTotal/$nb_display;
	
	if($nbTotal>0 && $nbTotal>$nb_display) {
		if($fin<$nbPageMax) $fin = $nbPageMax;
		if($debut<0)$debut = 0;
		$previous = $begin-1;
		$next = $begin+1;
		
		$display .= '<nav aria-label="Page navigation"><ul class="pagination">';
		
		if($previous>=0) {
			$tmpStart = ($previous*$nb_display);
			$display .= '<li><a href="'.$getParam.'page='.($previous+1).'" title="'.($previous+1).'"><span aria-hidden="true">&laquo;</span></a></li>'; //($previous+1)
		}
		
		for ($i=$debut; $i<($fin+1) && $i<$nbPageResult; $i++) {
			$d = $i+1;
			$start = $i*$nb_display;
			$tmpStart = $start;
			
			if ($i == $begin) {
			  	$display .= '<li class="active"><a href="javascript:">'.$d.'</a></li>';
			}
			else {
				$display .= '<li><a href="'.$getParam.'page='.($i+1).'">'.$d.'</a></li>'; //($i+1)
			}
		}
		
		if($next<$nbPageResult) {
			$tmpStart = ($next*$nb_display);
			$display .= '<li><a href="'.$getParam.'page='.($next+1).'" title="'.($next+1).'"><span aria-hidden="true">&raquo;</span></a></li>'; //($next+1)
		}
		
		$display .= '</ul></nav>';
	}
	
	return $display;
}

/*
Send Message Dialog
https://developers.facebook.com/docs/sharing/reference/send-dialog
*/
function display_send_dialog($criteria=array()) {
	$title = $criteria['title'];
	$to = $criteria['to'];
	$link = $criteria['link'];
	
	if($title=='') $title = '';
	if($to=='') $to = '';
	if($link=='') $link = '';
	
	$random = rand(9999,9999999).rand(9999,9999999).rand(9999,9999999);
	
	$js = '
	<script>
	function fb_display_send_dialog'.$random.'() {
		FB.ui({ 
			method: \'send\',
 			to: \''.$to.'\',
 			link: \''.$link.'\',
		}, function(response){} );
	}
	</script>
	';
	
	$content = '<a href="javascript:" onclick="fb_display_send_dialog'.$random.'()">'.$title.'</a>';
	
	return $content.$js;
}

/*
Status update
https://developers.facebook.com/docs/sharing/reference/feed-dialog/v2.4
*/
function display_feed_dialog($criteria=array()) {
	$title = $criteria['title'];
	$link = $criteria['link'];
	$picture = $criteria['picture'];
	$source = $criteria['source'];
	$name = $criteria['name'];
	$caption = $criteria['caption'];
	$description = $criteria['description'];
	$link_image = $criteria['link_image'];
	
	if($title=='') $title = 'Status Update';
	if($link=='') $link = '';
	if($picture=='') $picture = '';
	if($source=='') $source = '';
	if($name=='') $name = '';
	if($caption=='') $caption = '';
	if($description=='') $description = '';
	
	$random = rand(9999,9999999).rand(9999,9999999).rand(9999,9999999);
	
	/*
 			source: \''.$source.'\',
 			name: \''.$name.'\',
 			caption: \''.$caption.'\',
 			description: \''.$description.'\',	
	*/
	
	$js = '
	<script>
	function fb_display_feed_dialog'.$random.'() {
		FB.ui({ 
			method: \'share\',
 			href: \''.$link.'\',
 			picture: \''.$picture.'\',
		}, function(response){
			//console.log(response);
			if(response.error_code!=4201) { save_post_id(); }
		} );
	}
	</script>
	';
	
	if($link_image!='') $content = '<a href="javascript:" onclick="fb_display_feed_dialog'.$random.'()">'.$link_image.'</a>';
	else $content = '<a href="javascript:" onclick="fb_display_feed_dialog'.$random.'()">'.$title.'</a>';
	
	return $content.$js;
}

/*
Share Dialog
https://developers.facebook.com/docs/sharing/reference/share-dialog
*/
function display_share_dialog($criteria=array()) {
	$title = $criteria['title'];
	$link = $criteria['link'];
	
	if($title=='') $title = 'Share';
	if($link=='') $link = '';
	
	$random = rand(9999,9999999).rand(9999,9999999).rand(9999,9999999);
	
	$js = '
	<script>
	function fb_display_share_dialog'.$random.'() {
		FB.ui({ 
			method: \'share\',
 			to: \''.$to.'\',
 			href: \''.$link.'\',
		}, function(response){} );
	}
	</script>
	';
	
	$content = '<a href="javascript:" onclick="fb_display_share_dialog'.$random.'()">'.$title.'</a>';
	
	return $content.$js;
}

?>