/*
Last update: 22 Oct 17
*/

var generalFunctions = {
	
	/*
	** @param form - Ex: jQuery('#form')
	*/
	getFormInputValues: function(form) {
		
		var vals = {};
		$('input[type=text], input[type=hidden], input[type=password]', form).each(function(){
			vals[$(this).attr('id')] = $(this).val();
		});
		$('select', form).each(function(){
			vals[$(this).attr('id')] = $(this).val();
		});
		$('input[type=checkbox]', form).each(function(){
			vals[$(this).attr('id')] = $(this).is(":checked");
		});
		$('textarea', form).each(function(){
			vals[$(this).attr('id')] = $(this).val();
		});
		
		return vals;
	},
	
	//Needs the "bootstrap-notify-3.1.3"
	displayNotification: function(obj) {
		
		if(obj.type===undefined) obj.type = 'info';
		
		$.notify({
			// options
			message: obj.message 
		},{
			// settings
			type: obj.type,
			placement: {
				from: "top",
				align: "center"
			},
			delay: 1000,
			timer: 1000,
			animate: {
				enter: 'animated fadeInDown',
				exit: 'animated fadeOutUp'
			},
			//offset: 60,
		});
	},
	
	nl2br: function(str, is_xhtml) {
	    var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
	    return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1'+ breakTag +'$2');
	}
}