<?php

/*
Last update: 25 Oct 17
*/

class Bootstrap_form {
	
	public function form_open($options=array()) {
		$id = $options['id'];
		$name = $options['name'];
		
		if($name=='') $name = $id;
		
		$d = "
		<form id=\"{$id}\" name=\"{$name}\">
		";
		
		return $d;
	}
	
	public function form_close($options=array()) {
		
		$d = "
		</form>
		";
		
		return $d;
	}
	
	public function form_input($options=array()) {
		$id = $options['id'];
		$name = $options['name'];
		$label = $options['label'];
		$value = $options['value'];
		$type = $options['type'];
		$description = $options['description'];
		
		if($name=='') $name = $id;
		if($type=='') $type = 'text';
		
		if($description!='') $description = "<div style=\"margin-bottom:5px;\">{$description}</div>";
		
		$d = "
		<div id=\"{$id}_box\" style=\"margin-bottom:10px;\">
			<label>{$label}:</label>{$description}
			<input type=\"{$type}\" class=\"form-control\" id=\"{$id}\" name=\"{$name}\" value=\"{$value}\">
		</div>
		";
		
		return $d;
	}
	
	public function form_hidden($options=array()) {
		$id = $options['id'];
		$name = $options['name'];
		$label = $options['label'];
		$value = $options['value'];
		
		if($name=='') $name = $id;
		
		$d = "
		<input type=\"hidden\" id=\"{$id}\" name=\"{$name}\" value=\"{$value}\">
		";
		
		return $d;
	}
	
	public function form_textarea($options=array()) {
		$id = $options['id'];
		$name = $options['name'];
		$label = $options['label'];
		$value = $options['value'];
		$height = $options['height'];
		$description = $options['description'];
		
		if($name=='') $name = $id;
		$style='';
		if($height!='') $style = "height:{$height}px;";
		
		if($description!='') $description = "<div style=\"margin-bottom:10px;\">{$description}</div>";
		
		$d = "
		<div id=\"{$id}_box\" style=\"margin-bottom:10px;\">
			<label>{$label}:</label>
			{$description}
			<textarea class=\"form-control\" id=\"{$id}\" name=\"{$name}\" style=\"{$style}\">{$value}</textarea>
		</div>
		";
		
		return $d;
	}
	
	public function form_select($options=array()) {
		$id = $options['id'];
		$name = $options['name'];
		$label = $options['label'];
		$selected = $options['selected'];
		$values = $options['values'];
		
		if($name=='') $name = $id;
		
		if(is_array($values) && count($values)>0) {
			$d = "
			<div id=\"{$id}_box\" style=\"margin-bottom:10px;\">
				<label>{$label}:</label>
				<select class=\"form-control\" id=\"{$id}\" name=\"{$name}\">";
				foreach($values as $value=>$name) {
					if($value==$selected) $d .= "<option value=\"{$value}\" selected>{$name}</option>";
					else $d .= "<option value=\"{$value}\">{$name}</option>";
				}
				$d .= "</select>
			</div>
			";
		}
		
		return $d;
	}
	
	/*
	public function form_radio($options=array()) {
		$id = $options['id'];
		$name = $options['name'];
		$label = $options['label'];
		$selected = $options['selected'];
		$values = $options['values'];
		
		if($name=='') $name = $id;
		
		$d = "<b>{$label}:</b>";
		if(is_array($values) && count($values)>0) {
			$i=0;
			foreach($values as $ind=>$val) {
				$d .= "
				<div class=\"radio\">
					<label>
					<radio id=\"{$id}\" name=\"{$name}\">";
					$d .= "<input type=\"radio\" id=\"{$id}_{$i}\" name=\"{$name}\" value=\"{$ind}\"> {$val}";
					$d .= "</label>
				</div>
				";
				$i++;
			}
		}
		
		return $d;
	}
	*/
	
	public function form_checkbox($options=array()) {
		$id = $options['id'];
		$name = $options['name'];
		$label = $options['label'];
		$value = $options['value'];
		
		if($name=='') $name = $id;
		$checked = '';
		if($value=='on' || $value=='true') $checked = 'checked';
		
		$d = "
		<div id=\"{$id}_box\" class=\"checkbox\" style=\"margin-bottom:10px;\">
			<label>
				<input type=\"checkbox\" id=\"{$id}\" name=\"{$name}\" {$checked}> {$label}
			</label>
		</div>
		";
		
		return $d;
	}
	
	public function form_submit($options=array()) {
		$id = $options['id'];
		$value = $options['value'];
		$class = $options['class'];
		
		$d = "
		<p><input type=\"submit\" class=\"btn btn-primary {$class}\" id=\"{$id}\" value=\"{$value}\"></p>
		";
		return $d;
	}
	
}

?>