<?php

//Dependency: PHPMailer-master

class ygpSendmail_class
{
	//Default values
	var $type = 'mail'; //Possible values: mail, gmail
	var $emailFrom = '';
	var $emailFromPassword = '';
	
	public function __construct($criteria=array()) {
		if($criteria['type']!='') $this->type = $criteria['type'];
		if($criteria['emailFromPassword']!='') $this->emailFromPassword = $criteria['emailFromPassword'];
	}
	
	public function sendEmail($options=array()) {
		$type = $options['type'];
		$emailFrom = $options['emailFrom'];
		$nameFrom = $options['nameFrom'];
		$emailFromPassword = $options['emailFromPassword'];
		$emailTo = $options['emailTo'];
		$subject = $options['subject'];
		$htmlMessage = $options['htmlMessage'];
		
		if($type=='') $type = $this->type;
		
		if($type=='gmail') {
			$options['emailFromPassword'] = $this->emailFromPassword;
			return $this->sendEmailWithGmail($options);
		}
		else {
			return $this->sendEmailWithMail($options);
		}
	}
	
	private function sendEmailWithGmail($options=array()) {
		$emailFrom = $options['emailFrom'];
		$nameFrom = $options['nameFrom'];
		$emailFromPassword = $options['emailFromPassword'];
		$emailTo = $options['emailTo'];
		$subject = $options['subject'];
		$htmlMessage = $options['htmlMessage'];
		//$message = $options['message'];
		
		$return = array();
		if(!class_exists('PHPMailer')) return array('success'=>false, 'errorMessage'=>'The class "PHPMailer" is missing');
		
		$mail = new PHPMailer;
		
		//$mail->SMTPDebug = 3; // Enable verbose debug output
		
		$mail->isSMTP(); // Set mailer to use SMTP
		$mail->Host = 'smtp.gmail.com'; // Specify main and backup SMTP servers
		$mail->SMTPAuth = true; // Enable SMTP authentication
		$mail->Username = $emailFrom; // SMTP username
		$mail->Password = $emailFromPassword; // SMTP password
		$mail->SMTPSecure = 'tls'; // Enable TLS encryption, `ssl` also accepted
		$mail->Port = 587; // TCP port to connect to
		$mail->CharSet = 'utf-8';
		
		$mail->setFrom($emailFrom, $nameFrom);
		$mail->addAddress($emailTo); // Name is optional
		
		$mail->isHTML(true); // Set email format to HTML
		
		$mail->Subject = $subject;
		$mail->Body    = $htmlMessage;
		//$mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
		
		if(!$mail->send()) {
			$return['success'] = false;
			$return['errorMessage'] = 'Mailer Error: ' . $mail->ErrorInfo;
		} else {
		    $return['success'] = true;
		}
		
		return $return;
	}
	
	private function sendEmailWithMail($options=array()) {
		$emailFrom = $options['emailFrom'];
		$nameFrom = $options['nameFrom'];
		$emailTo = $options['emailTo'];
		$nameTo = $options['nameTo'];
		$subject = $options['subject'];
		$htmlMessage = $options['htmlMessage'];
		//$message = $options['message'];
		
		$return = array();
		if(!class_exists('PHPMailer')) return array('success'=>false, 'errorMessage'=>'The class "PHPMailer" is missing');
		
		//Create a new PHPMailer instance
		$mail = new PHPMailer;
		//Set who the message is to be sent from
		$mail->setFrom($emailFrom, $nameFrom);
		//Set who the message is to be sent to
		$mail->addAddress($emailTo, $nameTo);
		//Set the subject line
		$mail->Subject = $subject;
		//Read an HTML message body from an external file, convert referenced images to embedded,
		//convert HTML into a basic plain-text alternative body
		$mail->msgHTML($htmlMessage);
		$mail->CharSet = 'utf-8';
		
		if(!$mail->send()) {
			$return['success'] = false;
			$return['errorMessage'] = 'Mailer Error: ' . $mail->ErrorInfo;
		} else {
		    $return['success'] = true;
		}
		
		return $return;
	}
}

?>