<?php
/**
 * Copyright (c) 2016-present, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 */
namespace Facebook\InstantArticles\Transformer;

use Facebook\InstantArticles\Elements\InstantArticle;
use Facebook\Util\BaseHtmlTestCase;

class GlobalTransformerTest extends BaseHtmlTestCase
{
    public function testSelfTransformerContent()
    {
        date_default_timezone_set('UTC');

        $json_file = file_get_contents(__DIR__ . '/global-rules.json');

        $instant_article = InstantArticle::create();
        $transformer = new Transformer();
        $transformer->loadRules($json_file);

        $html_file = file_get_contents(__DIR__ . '/global.html');

        libxml_use_internal_errors(true);
        $document = new \DOMDocument();
        $document->loadHTML($html_file);
        libxml_use_internal_errors(false);

        $transformer->transform($instant_article, $document);
        $instant_article->addMetaProperty('op:generator:version', '1.0.0');
        $instant_article->addMetaProperty('op:generator:transformer:version', '1.0.0');
        $result = $instant_article->render('', true)."\n";
        $expected = file_get_contents(__DIR__ . '/global-ia.html');

        $this->assertEqualsHtml($expected, $result);
        $this->assertCount(0, $transformer->getWarnings());
    }

    public function testSelfTransformerContentWithTestDate()
    {
        date_default_timezone_set('UTC');

        $json_file = file_get_contents(__DIR__ . '/global-rules-with-text-date.json');

        $instant_article = InstantArticle::create();
        $transformer = new Transformer();
        $transformer->loadRules($json_file);

        $html_file = file_get_contents(__DIR__ . '/global-with-text-date.html');

        libxml_use_internal_errors(true);
        $document = new \DOMDocument();
        $document->loadHTML($html_file);
        libxml_use_internal_errors(false);

        $transformer->transform($instant_article, $document);
        $instant_article->addMetaProperty('op:generator:version', '1.0.0');
        $instant_article->addMetaProperty('op:generator:transformer:version', '1.0.0');
        $result = $instant_article->render('', true)."\n";
        $expected = file_get_contents(__DIR__ . '/global-ia-with-text-date.html');

        $this->assertEqualsHtml($expected, $result);
        $this->assertCount(0, $transformer->getWarnings());
    }
}
