<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }
/**
 * Load framework
 */
require_once ( trailingslashit( get_template_directory() ) . '/inc/init.php' );


/**
 * Setup Yellow Pencil Pro
 */
define('YP_THEME_MODE', "true");

if( is_admin() && !function_exists('jevelin_register_required_plugins') ) :
    require_once ( trailingslashit( get_template_directory() ) . '/inc/plugins/TGM-Plugin-Activation/class-tgm-plugin-activation.php' );
    function jevelin_register_required_plugins() {

        tgmpa(array(
            array(
                'name'      => esc_html__( 'Unyson', 'jevelin' ),
                'slug'      => 'unyson',
                'required'  => true,
            ),

            array(
                'name'      => esc_html__( 'WooCommerce', 'jevelin' ),
                'slug'      => 'woocommerce',
                'required'  => false,
            ),

            array(
                'name'      => esc_html__( 'Revolution slider', 'jevelin' ),
                'slug'      => 'revslider',
                'source'    => 'https://cdn.shufflehound.com/theme-plugins/slider-revolution-QB4L22.zip',
                'required'  => false,
                'version'   => '5.4.6.4',
            ),

            array(
                'name'      => esc_html__( 'Yellow Pencil Pro: Visual CSS Style Editor', 'jevelin' ),
                'slug'      => 'waspthemes-yellow-pencil',
                'source'    => 'https://cdn.shufflehound.com/theme-plugins/yellow-pencil-AX5N33.zip',
                'required'  => false,
                'version'   => '6.1.4',
            ),

            array(
                'name'      => esc_html__( 'One Click Demo Install (optional)', 'jevelin' ),
                'slug'      => 'one-click-demo-import',
                'required'  => false,
            ),

            array(
                'name'      => esc_html__( 'Envato Market Plugin', 'jevelin' ),
                'slug'      => 'envato-wordpress-toolkit',
                'source'    => trailingslashit( get_template_directory() ) . '/inc/plugins/envato-market.zip',
                'required'  => false,
                'version'   => '1.0.0-RC2',
            ),
        ), array( 'is_automatic' => true ));

    }
    add_action( 'tgmpa_register', 'jevelin_register_required_plugins' );
endif;


/**
 * Setup Yellow Pencil Pro
 */
define('YP_THEME_MODE', "true");

/**
 * Login Redirect
 */
if ((isset($_GET[�action�]) && $_GET[�action�] != �logout�) ||  (isset($_POST[�login_location�]) &&
!empty($_POST[�login_location�])) ) {
       add_filter(�login_redirect�, �my_login_redirect�, 10, 3);
       function my_login_redirect() {
                $location = $_SERVER[�HTTP_REFERER�];
                wp_safe_redirect($location);
                exit();
        }
}

function change_graphic_lib($array) {
    return array( 'WP_Image_Editor_GD', 'WP_Image_Editor_Imagick' );
}

 /**
  * Autoresponder
  */

  function autoSendy($method, $list, $email, $nom, $custom)
  {
    $curl = curl_init();
    $param =  $method . "|P|gBpu8cdAy8v|P|2|P|4|P|" . $email . "|P|" . $list;
    if ($method == "ADD") $param .= "|P|" . $nom . "|P|" . $custom . "|P|1";
    if ($method == "CHG") $param .= "|P|" . $nom;
    curl_setopt($curl, CURLOPT_URL, "https://api-web.net/Sendy/SendyMail");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, "$param");
    $result = curl_exec($curl);
    curl_close($curl);
    return $result;
  }

  function add_to_abandon()
  {
        $current_user = wp_get_current_user();
        $first_name = $current_user->user_firstname;
        $name = $current_user->user_lastname;
        $user_info = get_userdata( get_current_user_id() );
        $custom_fields = get_user_option('s2member_custom_fields', $user_info);
        $category_ids = "";
        $email = $user_info->user_email;
        $product_id = "";
        $cart = WC()->cart->get_cart();
        foreach ($cart as $product) {
          $product_id .= $product["product_id"]."-";
          $categories = $product["data"]->get_category_ids( $context = 'view' );
          foreach ($categories as $category) {
              $category_ids .= "-".$category;
            }
        }
        $custom = $first_name."%s%".$product_id."%s%".$category_ids;
        autoSendy("ADD", "abandon", $email, $name, $custom);
        return true;
  }
  add_action( 'woocommerce_before_cart_contents', 'add_to_abandon', 10, 3 );

  add_action('after_setup_theme', 'buying_action', 110);

  function after_order_complete($order_id) {
        $order = new WC_Order( $order_id );
        $user_info = get_userdata( $order->user_id );

        $current_user = wp_get_current_user();
        $first_name = $current_user->user_firstname;
        $name = $current_user->user_lastname;
        $email = $user_info->user_email;
        foreach($order->get_items() as $item) {
          $product_id .= $item['product_id']."-";
          $terms = get_the_terms( $item['product_id'], 'product_cat' );
          foreach ($terms as $term) {
              $category_ids .= "-".$term->term_id;
              break;
          }
        }
        $custom = $first_name."%s%".$product_id."%s%".$category_ids;
        autoSendy("ADD", "achat", $email, $name, $custom);
   }

  add_action('woocommerce_order_status_completed', 'after_order_complete');

 function aSendy($method, $list, $email, $nom, $custom)
  {
    $curl = curl_init();
    $param =  $method . "|P|gBpu8cdAy8v|P|2|P|4|P|" . $email . "|P|" . $list;
    if ($method == "ADD") $param .= "|P|" . $nom . "|P|" . $custom . "|P|1";
    if ($method == "CHG") $param .= "|P|" . $nom;
    curl_setopt($curl, CURLOPT_URL, "https://api-web.net/Sendy/SendyMail");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, "$param");
    $result = curl_exec($curl);
    curl_close($curl);
    return $result;
  }
  
  function getUrl()
  {
    $url  = @( $_SERVER["HTTPS"] != 'on' ) ? 'http://'.$_SERVER["SERVER_NAME"] :  'https://'.$_SERVER["SERVER_NAME"];
    $url .= ( $_SERVER["SERVER_PORT"] != 80 ) ? ":".$_SERVER["SERVER_PORT"] : "";
    $url .= $_SERVER["REQUEST_URI"];
    return $url;
  }

  function rememberPage()
  {
  	$curr_page = getUrl();
  	$last_page = $_SERVER['HTTP_REFERER'];
  	if($_SESSION["last_page"] != $curr_page ) {
  		//echo $_SESSION["last_page"]."<br /> != <br /> $last_page <br /> Working";
  		$_SESSION["pre_last_page"] = $_SESSION["last_page"];
  		$_SESSION["last_page"] = $curr_page;
  	}
  }

  function wooc_extra_register_fields() {?>
    <p class="form-row form-row-first">
      <label for="reg_billing_first_name"><?php _e( 'First name', 'woocommerce' ); ?><span class="required">*</span></label>
      <input type="text" class="input-text" name="billing_first_name" id="reg_billing_first_name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" />
    </p>
    <p class="form-row form-row-last no-ws">
      <label for="reg_billing_last_name"><?php _e( 'Last name', 'woocommerce' ); ?><span class="required">*</span></label>
      <input type="text" class="input-text" name="billing_last_name" id="reg_billing_last_name" value="<?php if ( ! empty( $_POST['billing_last_name'] ) ) esc_attr_e( $_POST['billing_last_name'] ); ?>" />
    </p>
       <?php
 }
 add_action( 'woocommerce_register_form_start', 'wooc_extra_register_fields' );

