<?php
Class federations_model extends CI_Model
{
	var $table_federation = "federation";

	function __construct(){
		parent::__construct();
	}

	public function get_columns(){
		$fields = $this->db->list_fields($this->table_federation);
		return $fields;
	}

	public function nb() {
		$count = $this->db->count_all_results($this->table_federation);
        return $count;
	}

	public function get_all(){
		$this->db->select('id, type, nom, adresse, cp, ville, tel, fax, mail, web, logo');
		$this->db->from($this->table_federation);
		$this->db->order_by('type','ASC');
		$this->db->order_by('nom','ASC');
		$datas = $this->db->get()->result();
		return $datas;
	}

	public function get_types(){
		$this->db->select('type');
		$this->db->from($this->table_federation);
		$this->db->order_by('type','ASC');
		$this->db->group_by('type'); 
		$datas = $this->db->get()->result();
		return $datas;
	}

}