<?php
include_once('./include/webzone.php');
$current_page = 'fb';

$jsOnReady = '$(\'[data-toggle="tooltip"]\').tooltip();';

include_once('./include/presentation/header.php');

$settings = get_settings();
$f1 = new Fb_ypbox(array('fb_app_id'=>$settings['fb_app_id'], 'fb_app_secret'=>$settings['fb_app_secret']));

$f1->load_js_functions();
$f1->loadJsSDK();

$pageNumber = $_GET['page'];
if($pageNumber=='') $pageNumber=1;
$nb_display = 25;

?>

<div class="modal fade" tabindex="-1" role="dialog" id="send-notification-modal">
  <div class="modal-dialog" role="document"><form>
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Send a notification</h4>
      </div>
      <div class="modal-body">
	    <p id="users"></p>
	    <input type="hidden" id="fb_ids">
        <label>Message:</label>
        <textarea id="message" class="form-control" style="width:100%; height:70px;"></textarea>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary" id="send_notification_btn">Send</button>
      </div>
    </div>
  </div></form>
</div>

<div class="modal fade" tabindex="-1" role="dialog" id="fb-shares-modal">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Shared messages</h4>
      </div>
      <div class="modal-body">
      </div>
    </div>
  </div>
</div>

<div class="modal fade" tabindex="-1" role="dialog" id="social-visits-modal">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Social visits</h4>
      </div>
      <div class="modal-body">
      </div>
    </div>
  </div>
</div>

<div class="container">	
	
	<?php
	$result = get_fb_users(array('page_number'=>$pageNumber, 'nb_display'=>$nb_display));
	$nbResult = get_nb_fb_users();
	
	$db = new MySqlTable();
	
	//Get nb shares by user
	$sql = "
	SELECT social_user_id, count(1) nb
	FROM {$GLOBALS['db_table']['social_actions']}
	WHERE social_network='Facebook' AND type='share_dialog' AND status='sent'
	GROUP BY social_user_id";
	$rs = $db->customQuery($sql);
	$nbSharesByUser = array();
	if(count($rs)>0) {
		foreach($rs as $row) {
			$nbSharesByUser[$row['social_user_id']] = $row['nb'];
		}
	}

	//Get nb social visits by user
	$sql = "
	SELECT sa.social_user_id, count(1) nb
	FROM {$GLOBALS['db_table']['social_actions']} sa, {$GLOBALS['db_table']['social_visits']} sv
	WHERE sa.id=sv.social_action_id
	AND sa.social_network='Facebook' AND sa.type='share_dialog'
	GROUP BY sa.social_user_id";
	$rs = $db->customQuery($sql);
	$nbSocialVisitsByUser = array();
	if(count($rs)>0) {
		foreach($rs as $row) {
			$nbSocialVisitsByUser[$row['social_user_id']] = $row['nb'];
		}
	}
	
	//Get Mailchimp newsletters by user
	$sql = "
	SELECT DISTINCT user_id
	FROM {$GLOBALS['db_table']['newsletters']}
	WHERE name='mailchimp'";
	$rs = $db->customQuery($sql);
	$mailchimpNewsletterByUser = array();
	if(count($rs)>0) {
		foreach($rs as $row) {
			$mailchimpNewsletterByUser[$row['user_id']] = 'Sent';
		}
	}
	
	if(count($result)>0) {
		echo '<p class="pull-right">
		<a href="export_fb_users.php" class="btn btn-default">Export users</a>&nbsp;
		<a href="#" id="display_send_email_modal" class="btn btn-primary">Send an Email</a>&nbsp;
		<a href="#" id="display_send_notification_modal" class="btn btn-primary">Send notifications</a>
		</p>';
		
		echo '<table id="users_display_box" class="table table-hover checkboxes">';
			
			echo '<thead><tr>
			<th>
				<label><input type="checkbox" id="check_all_btn" title="Check all"> All users ('.$nbResult.')</label>
			</th>
			<th>Page unlocked</th>
			<th>Shares</th>
			<th>Social visits</th>
			<th>Mailchimp</th>
			<th style="text-align:right;">Actions</th></tr></thead>';
			
			for($i=0; $i<count($result); $i++) {
				$id = $result[$i]['id'];
				$user_id = $result[$i]['user_id'];
				$fb_id = $result[$i]['fb_id'];
				$fb_name = $result[$i]['fb_name'];
				$viewedLockedPage = $result[$i]['viewedLockedPage'];
				
				if($GLOBALS['demo_mode']==1) $fb_name = 'Hidden in demo mode';
				
				if($viewedLockedPage==1) $viewedLockedPage = 'Yes';
				else $viewedLockedPage = '<span style="color:red;">No</span>';
				
				$picture = 'https://graph.facebook.com/'.$fb_id.'/picture';
				
				echo '<tr>';
					echo '<td>';
						echo '<label>';
						echo '<input type="checkbox" name="fb_accounts_selection[]" id="'.$fb_id.'"> ';
						echo '<img src="'.$picture.'" style="margin-right:5px; width:24px;">';
						echo $fb_name;
						echo '</label>';
					echo '</td>';
					
					echo "<td>{$viewedLockedPage}</td>";
					
					echo '<td><a href="#" class="fb_shares_modal" data-fb-id="'.$fb_id.'">'.$nbSharesByUser[$fb_id].'</a></td>';
					
					echo '<td><a href="#" class="social_visits_modal" data-fb-id="'.$fb_id.'">'.$nbSocialVisitsByUser[$fb_id].'</a></td>';
					
					echo '<td>'.$mailchimpNewsletterByUser[$user_id].'</td>';
					
					echo '<td style="text-align:right;">';
						echo '<a href="#" class="fb_user_details_modal" data-id="'.$id.'" data-toggle="tooltip" data-placement="top" title="View"><span class="glyphicon glyphicon-eye-open"></span></a>&nbsp;&nbsp;';
						echo '<a href="#" id="send_message_fb_dialog" data-demo-mode="'.$GLOBALS['demo_mode'].'" data-link="'.$settings['app_url'].'" data-fb-id="'.$fb_id.'" data-toggle="tooltip" data-placement="top" title="Send message"><span class="glyphicon glyphicon-send"></span></a>&nbsp;&nbsp;';
						echo '<a href="#" class="delete_fb_user_btn" id="'.$id.'" data-fb-id="'.$fb_id.'" style="color:red;" data-toggle="tooltip" data-placement="top" title="Delete"><span class="glyphicon glyphicon-remove"></span></a>';
					echo '</td>';
				echo '</tr>';
			}
			
		echo '</table>';
		
		echo getPagination(array('pageNumber'=>$pageNumber, 'nbResult'=>$nbResult, 'nbDisplay'=>$nb_display));
	}
	else {
		echo 'No users found';
	}
	
	?>
	
</div>

<?php
include_once('./include/presentation/footer.php');
?>