<?php
include_once('./include/webzone.php');

$current_page = 'settings';

include_once('./include/presentation/header.php');
?>

<script>
	$(document).ready(function() {
		
		jQuery(document).on('change', "#email_server", function(event) {
			toggleEmailFromPasswordVisibility();
		});
		
		toggleEmailFromPasswordVisibility();
		
		function toggleEmailFromPasswordVisibility() {
			var email_server = $('#email_server').val();
			if(email_server=='gmail') {
				$('#email_from_password_box').show();
			}
			else {
				$('#email_from_password_box').hide();
			}
		}
	})
</script>

<div class="container">	
	
	<?php
	$settings = get_settings();
	
	if($GLOBALS['demo_mode']==1) {
		$settings['fb_app_secret'] = 'Hidden in demo mode';
		$settings['email_from'] = 'Hidden in demo mode';
		$settings['email_from_password'] = 'Hidden in demo mode';
		$settings['mailchimp_api_key'] = 'Hidden in demo mode';
	}
	
	$form = new Bootstrap_form();
	echo $form->form_open(array('id'=>'settings'));
	?>

	<div class="panel panel-primary">
	  <div class="panel-heading">
		  <h3 class="panel-title">Facebook app settings</h3>
	  </div>
	  <div class="panel-body">
		  
	    <?php
		echo $form->form_input(array('id'=>'fb_app_id', 'label'=>'Facebook app id', 'value'=>$settings['fb_app_id']));
		echo $form->form_input(array('id'=>'fb_app_secret', 'label'=>'Facebook app secret', 'value'=>$settings['fb_app_secret']));
		?>
		
	  </div>
	</div>

	<div class="panel panel-primary">
	  <div class="panel-heading">
		  <h3 class="panel-title">General settings</h3>
	  </div>
	  <div class="panel-body">
		
	    <?php
		echo $form->form_input(array('id'=>'app_url', 'label'=>'Your app URL', 'value'=>$settings['app_url'], 'description'=>'Need to start with http:// ou https:// - The link where the app can be accessed'));
		?>
		
	  </div>
	</div>
		
	<div class="panel panel-default">
	  <div class="panel-heading">
	    <h3 class="panel-title">Sharing on Facebook</h3>
	  </div>
	  <div class="panel-body">
		
	  	<?php
		$fb_link_description = "Recommended to leave it empty, in order to automatically use your app URL, and track the referral coming after a share";
		
		echo $form->form_checkbox(array('id'=>'post_on_fb_required', 'label'=>'Require the users to share a message on Facebook to unlock the page', 'value'=>$settings['post_on_fb_required']));
		echo $form->form_input(array('id'=>'post_on_fb_link', 'label'=>'Link to share with the user\'s message', 'value'=>$settings['post_on_fb_link'], 'description'=>$fb_link_description));
		echo $form->form_input(array('id'=>'post_on_fb_picture', 'label'=>'Picture to share with the user\'s message', 'value'=>$settings['post_on_fb_picture']));
		?>
		
	  </div>
	</div>

	<div class="panel panel-default">
	  <div class="panel-heading">
	    <h3 class="panel-title">Email settings</h3>
	  </div>
	  <div class="panel-body">
		
	  	<?php
		
		$emailServers = array('mail'=>'Regular email server', 'gmail'=>'Gmail server (using your gmail account to send emails)');
		
		echo $form->form_input(array('id'=>'email_from', 'label'=>'Email from', 'value'=>$settings['email_from']));
		echo $form->form_select(array('id'=>'email_server', 'label'=>'Email server', 'values'=>$emailServers, 'selected'=>$settings['email_server']));
		echo $form->form_input(array('id'=>'email_from_password', 'type'=>'password', 'label'=>'Email password', 'value'=>$settings['email_from_password']));
		?>
		
	  </div>
	</div>
	
	<div class="panel panel-default">
	  <div class="panel-heading">
	    <h3 class="panel-title">Email autopost</h3>
	  </div>
	  <div class="panel-body">
		
	  	<?php
		
		echo $form->form_checkbox(array('id'=>'email_autopost', 'label'=>'Enable the email autopost', 'value'=>$settings['email_autopost']));
		echo $form->form_input(array('id'=>'email_autopost_subjet', 'label'=>'Email subject', 'value'=>$settings['email_autopost_subjet']));
		$description = 'You can use <font color="green">{name}</font> in the message, and it will be replaced by the user\'s name when sending the email';
		echo $form->form_textarea(array('id'=>'email_autopost_message', 'label'=>'Email message', 'value'=>$settings['email_autopost_message'], 'height'=>200, 'description'=>$description));
		?>
		
	  </div>
	</div>
	
	<div class="panel panel-default">
	  <div class="panel-heading">
		  <h3 class="panel-title">Mailchimp Newsletter</h3>
	  </div>
	  <div class="panel-body">
		  
	    <?php
		echo $form->form_checkbox(array('id'=>'mailchimp_subscription', 'label'=>'Enable the MailChimp Newsletter Subscription', 'value'=>$settings['mailchimp_subscription']));
		echo $form->form_input(array('id'=>'mailchimp_api_key', 'label'=>'Mailchimp API key', 'value'=>$settings['mailchimp_api_key']));
		echo $form->form_input(array('id'=>'mailchimp_list_id', 'label'=>'Mailchimp list id', 'value'=>$settings['mailchimp_list_id']));
		?>
		
	  </div>
	</div>
	
	<?php
	echo $form->form_submit(array('id'=>'saveSettingsBtn', 'value'=>'Save settings'));
	echo $form->form_close();
	?>
	
</div>

<?php
include_once('./include/presentation/footer.php');
?>