CREATE TABLE IF NOT EXISTS `viral_app_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime,
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `viral_app_newsletters` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` ENUM('','mailchimp') NOT NULL DEFAULT '',
  `email` char(120) DEFAULT NULL DEFAULT '',
  `created` datetime,
  PRIMARY KEY (`user_id`,`name`)
) AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `viral_app_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `meta_key` char(60) NOT NULL DEFAULT '',
  `meta_value` text NOT NULL,
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `viral_app_fb_users` (
  `id` int(11) AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `fb_id` char(30) NOT NULL DEFAULT '',
  `fb_name` char(60) DEFAULT NULL DEFAULT '',
  `fb_email` char(120) DEFAULT NULL DEFAULT '',
  `fb_token` char(255) NOT NULL DEFAULT '',
  `fb_token_expires` int(11) DEFAULT NULL DEFAULT 0,
  `viewedLockedPage` tinyint(1) NOT NULL DEFAULT 0,
  `last_connect` datetime,
  `created` datetime,
  PRIMARY KEY (`id`),
  UNIQUE KEY (`fb_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `viral_app_twt_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `twt_id` char(30) NOT NULL DEFAULT '',
  `twt_username` char(30) NOT NULL DEFAULT '',
  `twt_image` char(255) NOT NULL DEFAULT '',
  `email` char(120) NOT NULL DEFAULT '',
  `token` char(255) NOT NULL DEFAULT '',
  `token_secret` char(120) NOT NULL DEFAULT '',
  `is_token_invalid` tinyint(4) NOT NULL DEFAULT 0,
  `last_connect` datetime,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY (`twt_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `viral_app_social_actions` (
  `id` int(11) AUTO_INCREMENT,
  `social_user_id` char(30) NOT NULL DEFAULT '',
  `social_network` ENUM('','Facebook','Twitter') NOT NULL DEFAULT '',
  `type` char(20) DEFAULT NULL DEFAULT '',
  `status` ENUM('new','sent','fail','') NOT NULL DEFAULT '',
  `api_result` char(255) DEFAULT NULL DEFAULT '',
  `created` datetime,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `viral_app_social_visits` (
  `social_action_id` int(11) NOT NULL DEFAULT 0,
  `browser_unique_id` char(30) DEFAULT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT 0,
  `user_agent` char(200) NOT NULL DEFAULT '',
  `visitDate` datetime,
  PRIMARY KEY (`social_action_id`, `browser_unique_id`)
) DEFAULT CHARSET=utf8;

INSERT INTO `viral_app_settings` (`id`, `meta_key`, `meta_value`) VALUES
(13, 'locked_content', '<center>\n<h1>{picture} Welcome {name} !</h1>\n\n<p>Here is the video of the week. You can also check the <a href="./admin/">backend here</a></p><br>\n\n<iframe width="800" height="400" src="https://www.youtube.com/embed/pRpeEdMmmQ0" frameborder="0" allowfullscreen></iframe>\n<center>'),
(15, 'autopost_email', 'on'),
(16, 'autopost_email_subject', 'Thanks for using Facebook Viral App'),
(17, 'autopost_email_message', 'Hi {name}, <br><br>\n\nThanks for using our Facebook Viral and Marketing Social App. You can get this app running on your own website and can purchase it from <a href="http://codecanyon.net/item/facebook-viral-and-marketing-social-app/717030">here</a><br><br>\n\nThanks for your interest!<br>'),
(18, 'post_on_fb', ''),
(19, 'post_on_fb_link', 'http://yougapi.com/products/viral_app/'),
(21, 'post_on_fb_picture', 'http://yougapi.com/pro/viral_app/include/graph/bg2.jpg'),
(22, 'mailchimp', 'on');