<?php
include_once('include/webzone.php');

detectVisitsFromSocialNetworks();

include_once('include/presentation/header.php');
?>

<!--Remove this style to disable the background image -->
<style>
	.bg_image {
		background: url("./include/graph/bg2.jpg") no-repeat center center fixed !important;
		-webkit-background-size: cover !important;
		-moz-background-size: cover !important;
		-o-background-size: cover !important;
		background-size: cover !important;
	}
</style>

<div class="container">
	
	<?php
	
	$viewLockedContent = false;
	$viewShareDialog = false;
	
	$settings = get_settings();
	
	if($settings['post_on_fb_link']=='') $post_on_fb_link = getCurrentPageURL();
	else $post_on_fb_link = $settings['post_on_fb_link'];
	
	echo '<script>
	App = {};
	App.app_url = "'.$post_on_fb_link.'";
	App.post_on_fb_picture = "'.$settings['post_on_fb_picture'].'";
	</script>';
	
	//Check if the Facebook user is connected
	$f1 = new Fb_ypbox(array('fb_app_id'=>$settings['fb_app_id'], 'fb_app_secret'=>$settings['fb_app_secret']));
	$fb_data = $f1->getUserData();
	
	if(count($fb_data)>0) {
		$users = get_fb_users(array('fb_id'=>$fb_data['id']));
		if(count($users)>0) {
			$user_id = $users[0]['user_id'];
			$fb_id = $users[0]['fb_id'];
			
			$viewLockedContent = true;
			
			if($settings['post_on_fb_required']=='true') {
				if($user_id>0) {
					$db = new MySqlTable();
					$sql = "
					SELECT id FROM {$GLOBALS['db_table']['social_actions']}
					WHERE social_user_id='{$fb_id}' AND social_network='Facebook' AND type='share_dialog'
					AND status='sent'
					ORDER BY created LIMIT 1
					";
					$socialAction = $db->customQuery($sql);
					if(count($socialAction)==0) {
						$viewShareDialog = true;
					}
				}
			}
		}
	}
	
	if($viewLockedContent==false) {
		
		//Display connect page
		echo '<center>';
		echo '<h1 style="margin-top:50px;">'.$settings['unlock_page_text'].'</h1><br>';
		echo '<p><a href="./account/fb_connect.php?redirect_url='.getCurrentPageURL().'&subscribe='.$_GET['subscribe'].'" style="font-size:20px;">';
		echo '<img src="./include/graph/login-with-facebook.png" style="width:400px;">';
		echo '</a></p>';
		if($settings['mailchimp_subscription']=='true') {
			$subscribeChecked = 'checked';
			if($_GET['subscribe']=='false') $subscribeChecked = '';
			echo '<label><input type="checkbox" id="subscribe" data-current-url="'.getCurrentPageURL().'" '.$subscribeChecked.'> Subscribe to our Newsletter</label>';
		}
		echo '</center>';
	}
	else {
		
		//Redirection
		if($settings['locked_content_access']=='redirect' && $settings['locked_content_redirect_url']!='') {
			echo '<script>window.location = "'.$settings['locked_content_redirect_url'].'";</script>';
			exit();
		}
		
		$fb_share_btn = '<a href="#" class="fb_share_dialog" style="font-size:20px;"><img src="./include/graph/share-on-facebook.png" style="width:400px;"></a>';
		
		if($viewShareDialog) {
			echo '<center>';
			echo '<h1 style="margin-top:50px;">'.$settings['unlock_page_text'].'</h1><br>';
			echo '<p>'.$fb_share_btn.'</p>';
			echo '</center>';
		}
		else {
			//Display locked content
			echo '<div>';
				
				$settings['locked_content_page'] = nl2br(stripslashes($settings['locked_content_page']));
				if($fb_data['picture']!='') $settings['locked_content_page'] = str_replace('{picture}', '<img src="'.$fb_data['picture'].'">', $settings['locked_content_page']);
				if($fb_data['name']!='') $settings['locked_content_page'] = str_replace('{name}', $fb_data['name'], $settings['locked_content_page']);
				$settings['locked_content_page'] = str_replace('{fb_share}', $fb_share_btn, $settings['locked_content_page']);
				
				//Here comes your content that only can be seen by users who have connected
				echo '<div>'.$settings['locked_content_page'].'</div>';
				
			echo '</div>';
			
			//Update viewed page
			if($fb_data['id']>0) {
				$db = new MySqlTable();
				$sql = "
				UPDATE {$GLOBALS['db_table']['fb_users']} 
				SET viewedLockedPage=1
				WHERE fb_id='{$fb_data['id']}' AND viewedLockedPage=0";
				$db->executeQuery($sql);
			}
		}
	}
	
	if($GLOBALS['demo_mode']==1) {
		echo '<br><hr><a href="./admin/">Check the admin</a> => User: admin - Password: admin';
	}
	
	?>
	
</div>

<?php
include_once('include/presentation/footer.php');
?>