<?php
function getNameFromNumber($num) {
    $numeric = ($num - 1) % 26;
    $letter = chr(65 + $numeric);
    $num2 = intval(($num - 1) / 26);
    if ($num2 > 0) {
        return getNameFromNumber($num2) . $letter;
    } else {
        return $letter;
    }
}

function exportExcel($filename, $obj, $columns, $datas)
{
	// colonnes
	$i=1;
	foreach($columns as $col)
	{
		$var_letter = getNameFromNumber($i);

		$obj->getActiveSheet()->setCellValue($var_letter.'1', $col);
		$obj->getActiveSheet()->getStyle($var_letter.'1')->getFont()->setSize(14);
		$obj->getActiveSheet()->getStyle($var_letter.'1')->getFont()->setBold(true);

		$i++;
	}

	// lignes
	$i = 2;
	foreach($datas as $item)
	{
		$j = 1;
		foreach($item as $value)
		{
			$var_letter = getNameFromNumber($j);

			$obj->getActiveSheet()->setCellValue($var_letter.$i, $value);
			$obj->getActiveSheet()->getStyle($var_letter.$i)->getFont()->setSize(14);

			$j++;
		}
		$i++;
	}

	// autosize
	foreach(range('A',$var_letter) as $columnID)
	{
		$obj->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
	}
	 
	$filename.='.xls'; //save our workbook as this file name
	header('Content-Type: application/vnd.ms-excel'); //mime type
	header('Content-Disposition: attachment;filename="'.$filename.'"'); //tell browser what's the file name
	header('Cache-Control: max-age=0'); //no cache
	             
	//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
	//if you want to save it as .XLSX Excel 2007 format
	$objWriter = PHPExcel_IOFactory::createWriter($obj, 'Excel5');  
	//force user to download the Excel file without writing it to server's HD
	$objWriter->save('php://output');
}
?>