<h2 class="title-h2 tac"><?= $this->lang->line('becomepartner_title') ?></h2>
<span class="header-effect animated fadeInUp delay-03s"></span>
<div class="separator"></div>

<?php
if(isset($requestMsg) && $requestMsg != '') {
?>
	<div class="alert alert-danger" role="alert">
	 	<strong><?= $this->lang->line('form_warning') ?></strong>
	 	<?php if(isset($requestMsg) && $requestMsg!='') { echo $requestMsg; } ?>
	</div>
<?php
} else if(validation_errors()) {
?>
	<div class="alert alert-danger" role="alert">
	 	<strong><?= $this->lang->line('form_warning') ?></strong><br />
	 	<?php echo validation_errors(); ?>
	</div>
<?php
}
?>

<?php
$form_attr = array("id" => "form_partenaire", "name" => "form_partenaire", "class" => "");
echo form_open_multipart("", $form_attr);
?>

<div class="row">
	<div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
		<ul class="nav nav-tabs" role="tablist" id="navbar-partenaire">
			<li class="nav-item">
				<a data-etape="1" class="nav-link active" href="#etape1" data-toggle="tab" role="tab">
					<?= $this->lang->line('form_step') ?> 1
					<span class="legend-etape"><?= $this->lang->line('becomepartner_step_1') ?></span>
				</a>
			</li>
			<li class="nav-item">
				<a data-etape="2" class="nav-link" href="#etape2" data-toggle="tab" role="tab">
					<?= $this->lang->line('form_step') ?> 2
					<span class="legend-etape"><?= $this->lang->line('becomepartner_step_2') ?></span>
				</a>
			</li>
			<li class="nav-item">
				<a data-etape="3" class="nav-link" href="#etape3" data-toggle="tab" role="tab">
					<?= $this->lang->line('form_step') ?> 3
					<span class="legend-etape"><?= $this->lang->line('becomepartner_step_3') ?></span>
				</a>
			</li>
		</ul>
	</div>

	<div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
		<div class="tab-content" id="tabcontent-partenaire">

			<p>
				<?php if($partnerType == 0) { ?>
					<?= $this->lang->line('becomepartner_type_1').' :'; ?>
				<?php } else if($partnerType == 1) { ?>
					<?= $this->lang->line('becomepartner_type_2').' :'; ?>
				<?php } ?>
			</p>

			<div class="tab-pane active" id="etape1" role="tabpanel">

				<h4><?= $this->lang->line('becomepartner_step_1') ?> :</h4>

				<?php 
				$field = 'partenaire_nom';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_company') ?> *</div>
						<input required="required" type="text" maxlength="32" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
					</div>
				</div>

				<?php /*if($partnerType == 0) { ?>

					<?php 
					$field = 'partenaire_isprof';
					if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
					<div class="form-group<?php echo $class; ?>">
						<div class="input-group">
							<div class="input-group-addon">Vous êtes un professionnel de l'assurance ? *</div>
							<select required="required" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>">
								<option value=""></option>
								<?php
								if(isset($_POST[$field])) { $fieldValue = $_POST[$field]; } else { $fieldValue = ''; }
								if($fieldValue == "0") { $selected = ' selected="selected"'; } else { $selected = ''; }
								echo '<option value="0"'.$selected.'>Non</option>';
								if($fieldValue == "1") { $selected = ' selected="selected"'; } else { $selected = ''; }
								echo '<option value="1"'.$selected.'>Oui</option>';
								?>
							</select>
						</div>
					</div>

				<?php }*/ ?>

				<?php 
				$field = 'partenaire_activite';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group a">
						<div class="input-group-addon"><?= $this->lang->line('form_activity') ?> *</div>
						<select required="required" class="form-control select-selectize" id="<?php echo $field; ?>" name="<?php echo $field; ?>">
							<option value=""></option>
							<?php 
							if(isset($_POST[$field])) { $fieldValue = $_POST[$field]; } else { $fieldValue = ''; }
							foreach($activitesList as $activite)
							{
								if($fieldValue == $activite) { $selected = ' selected="selected"'; } else { $selected = ''; }
								echo '<option'.$selected.'>'.$activite.'</option>';
							}
							?>
						</select>
					</div>
				</div>

				<?php 
				$field = 'partenaire_fj';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group b">
						<div class="input-group-addon"><?= $this->lang->line('form_legalstatus') ?> *</div>
						<select class="form-control select-selectize" id="<?php echo $field; ?>" name="<?php echo $field; ?>">
							<option value=""></option>
							<?php
							if(isset($_POST[$field])) { $fieldValue = $_POST[$field]; } else { $fieldValue = ''; }
							foreach($fjList as $fj)
							{
								if($fieldValue == $fj) { $selected = ' selected="selected"'; } else { $selected = ''; }
								echo '<option'.$selected.'>'.$fj.'</option>';
							}
							?>
						</select>
					</div>
				</div>

				<?php if($partnerType == 0) { ?>

					<?php 
					$field = 'partenaire_capital';
					if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
					<div class="form-group<?php echo $class; ?>">
						<div class="input-group">
							<div class="input-group-addon"><?= $this->lang->line('form_capital') ?> *</div>
							<input required="required" type="text" maxlength="8" pattern="^[0-9]{0,8}$" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
							<div class="input-group-addon sm">€</div>
						</div>
					</div>

					<?php 
					$field = 'partenaire_villerc';
					if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
					<div class="form-group<?php echo $class; ?>">
						<div class="input-group">
							<div class="input-group-addon"><?= $this->lang->line('form_cityrc') ?> *</div>
							<input required="required" type="text" maxlength="100" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
						</div>
					</div>

					<?php 
					$field = 'partenaire_nrc';
					if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
					<div class="form-group<?php echo $class; ?>">
						<div class="input-group">
							<div class="input-group-addon"><?= $this->lang->line('form_nrc') ?> *</div>
							<input type="text" required="required" maxlength="20" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
						</div>
					</div>

				<?php
				}
				?>

				<?php 
				/*$field = 'logo'; 
				$fieldValue = ''; if(isset($_POST[$field]) && $_POST[$field] != '') { $fieldValue = $_POST[$field]; } else if(isset($partenaire_data->LOGO_PARTENAIRE)) { $fieldValue = $partenaire_data->LOGO_PARTENAIRE; }
				?>
				<?php if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?> form-group-upload">
					<?php 
					$urlLogo = "";
					if($fieldValue != '') { 
						$displayPreview = 'block';
						$urlLogo = checkAndGetLogoPartenaire($fieldValue);
						if($urlLogo == "") {
							$displayPreview = 'none';
						}
					} else { 
						$displayPreview = 'none';
					}
					?>
					<div class="input-group logo-preview" style="display: <?php echo $displayPreview; ?>">
						<div class="thumbnail">
							<div class="row">
								<div class="col-lg-6 col-md-7 col-sm-7 col-xs-12 col-thumbnail">
									<div class="logo-th-content">
										Aperçu logo :
										<img src="<?php echo $urlLogo; ?>" alt="">
										<h6><?php echo $fieldValue; ?></h6>
										<button id="remove_logo" name="remove_logo" type="button" class="btn btn-sm btn-danger">Effacer</button>
									</div>
								</div>
							</div>
							<br />
						</div>
					</div>
					<div class="input-group">
						<div class="input-group-addon">Votre logo *</div>
						<input required="required" readonly="readonly" type="hidden" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>">
						<input readonly="readonly" type="hidden" id="<?php echo $field; ?>_new" name="<?php echo $field; ?>_new" value="0">
						<input value="<?php echo set_value($field); ?>" class="btn btn-info btn-upload-photo" style="width: 100%" required="required" type="file" id="<?php echo $field; ?>_upload" name="<?php echo $field; ?>_upload" accept="image/*">
					</div>
				</div>
				<div class="alert alert-info" role="alert">
					<i class="fa fa-info-circle"></i>
					<p>Le logo sera sur fond blanc, merci de prendre ceci en compte pour un affichage optimisé.
						<br />Format accepté : JPG (1mo maximum)
						<br />Hauteur recommandé : 60px
					</p>
					<p>Lorsque votre compte sera validé, votre logo sera affiché sur votre site accessible avec un sous-domaine propre à votre enseigne. Il sera également présent sur les certificats vendus.</p>
				</div>
				*/
				?>

				<div class="form-group pull-xs-right">
					<button type="submit" href="#etape2" class="btn btn-primary btn-etape-next"><?= $this->lang->line('form_step_next') ?> <i class="fa fa-chevron-circle-right"></i></button>
				</div>

			</div>
			<div class="tab-pane" id="etape2" role="tabpanel">

				<h4><?= $this->lang->line('becomepartner_step_2') ?> :</h4>

				<?php 
				$field = 'adresse1';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_address') ?> *</div>
						<input required="required" type="text" maxlength="32" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
					</div>
				</div>

				<?php 
				$field = 'adresse2';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_address_2') ?>&nbsp;&nbsp;</div>
						<input type="text" maxlength="32" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
					</div>
				</div>

				<?php 
				$field = 'codepostal';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_zipcode') ?> *</div>
						<input required="required" type="text" maxlength="10" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
					</div>
				</div>

				<?php 
				$field = 'ville';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_city') ?> *</div>
						<input required="required" type="text" maxlength="32" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
					</div>
				</div>

				<?php 
				$field = 'pays';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } 
				if(isset($_POST[$field])) { $fieldValue = $_POST[$field]; } else { $fieldValue = ''; }
				if($fieldValue == '') { $fieldValue = $this->lang->line('form_country_default'); }
				$countryValue = $fieldValue;
				$phoneValue = getCountryPhoneIndicator($countryValue);
				?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_country') ?> *</div>
						<select class="form-control country-list" data-rel="phone_indicator" data-mobile="fax" data-phone="telephone" id="<?php echo $field; ?>" name="<?php echo $field; ?>">
							<option value=""></option>
							<?php
							$paysList = getCountryList();
							foreach($paysList as $pays)
							{
								if(strtolower($fieldValue) == mb_strtolower($pays)) { $selected = ' selected="selected"'; } else { $selected = ''; }
								echo '<option value="'.$pays.'"'.$selected.'>'.mb_strtoupper($pays).'</option>';
							}
							?>
						</select>
					</div>
				</div>

				<div class="form-group pull-xs-left">
					<a href="#etape1" class="btn btn-primary btn-etape-next"><i class="fa fa-chevron-circle-left faleft"></i> <?= $this->lang->line('form_step_prev') ?></a>
				</div>

				<div class="form-group pull-xs-right">
				<button type="submit" href="#etape3" class="btn btn-primary btn-etape-next"><?= $this->lang->line('form_step_next') ?> <i class="fa fa-chevron-circle-right"></i></button>
				</div>

			</div>
			<div class="tab-pane" id="etape3" role="tabpanel">

				<h4><?= $this->lang->line('becomepartner_st3_contact') ?> :</h4>

				<?php 
				$field = 'contact_nom';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_lastname') ?> *</div>
						<input required="required" type="text" maxlength="32" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
					</div>
				</div>

				<?php 
				$field = 'contact_prenom';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_firstname') ?> *</div>
						<input required="required" type="text" maxlength="32" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
					</div>
				</div>

				<?php 
				$field = 'contact_fonction';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon">Fonction&nbsp;&nbsp;</div>
						<select class="form-control select-selectize" id="<?php echo $field; ?>" name="<?php echo $field; ?>">
							<option value=""></option>
							<?php
							if(isset($_POST[$field])) { $fieldValue = $_POST[$field]; } else { $fieldValue = ''; }
							foreach($fonctionsList as $fonction)
							{
								if($fieldValue == $fonction) { $selected = ' selected="selected"'; } else { $selected = ''; }
								echo '<option'.$selected.'>'.$fonction.'</option>';
							}
							?>
						</select>
					</div>
				</div>

				<h4><?= $this->lang->line('becomepartner_step_3') ?> :</h4>

				<?php 
				$field = 'telephone';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; }
				$fieldValue = $phoneValue;
				if(isset($_POST[$field])) { $fieldValue = $_POST[$field]; }
				?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_phone') ?> *</div>
						<div class="input-group-addon addon-phone-country output-phone_indicator">
							<?php
							if($fieldValue != "")
							{
								echo getCountryFlag($countryValue);
							}
							?>
						</div>
						<input required="required" type="tel" pattern="^[0-9-+]{0,20}$" maxlength="20" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo $fieldValue; ?>" placeholder="">
					</div>
				</div>

				<?php 
				$field = 'fax';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } 
				$fieldValue = $phoneValue;
				if(isset($_POST[$field])) { $fieldValue = $_POST[$field]; }
				?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_mobile') ?>&nbsp;&nbsp;</div>
						<div class="input-group-addon addon-phone-country output-phone_indicator">
							<?php
							if($fieldValue != "")
							{
								echo getCountryFlag($countryValue);
							}
							?>
						</div>
						<input type="tel" pattern="^[0-9-+]{0,20}$" maxlength="20" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo $fieldValue; ?>" placeholder="">
					</div>
				</div>

				<?php 
				$field = 'email';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_mail') ?> *</div>
						<input required="required" type="email" maxlength="100" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
					</div>
				</div>

				<?php 
				$field = 'email_confirm';
				if(form_error($field)) { $class = ' has-error has-feedback'; } else { $class = ""; } ?>
				<div class="form-group<?php echo $class; ?>">
					<div class="input-group">
						<div class="input-group-addon"><?= $this->lang->line('form_mail_confrm') ?> *</div>
						<input required="required" type="email" maxlength="100" class="form-control" id="<?php echo $field; ?>" name="<?php echo $field; ?>" value="<?php echo set_value($field); ?>" placeholder="">
					</div>
				</div>

				<div class="form-group">
					<div class="checkbox">
						<label for="rgpd"><input required type="checkbox" id="rgpd" name="rgpd" value=""><?= $label_rgpd ?></label>
					</div>
				</div>

				<div class="alert alert-info" role="alert">
					<?= $this->lang->line('becomepartner_message') ?>
				</div>

				<div class="form-group pull-xs-left">
					<a href="#etape2" class="btn btn-primary btn-etape-next"><i class="fa fa-chevron-circle-left faleft"></i> <?= $this->lang->line('form_step_prev') ?></a>
				</div>

				<div class="form-group">
					<div class="g-recaptcha" data-sitekey="<?php echo $this->config->item('google_key') ?>"></div> 
				</div>

				<div class="form-group pull-xs-right">
					<input type="submit" name="submit" id="submit" class="btn btn-primary" value="<?= $this->lang->line('form_submit_partner') ?>">
				</div>

			</div>

		</div>
	</div>

</div>

<script src='https://www.google.com/recaptcha/api.js'></script>
<?php echo form_close(); ?>