jQuery.noConflict();
jQuery(document).ready(function ($) {

	// click touch
    var isIOS = ((/iphone|ipad/gi).test(navigator.appVersion));
    var myDown = isIOS ? "touchstart" : "mousedown";
    var myUp = isIOS ? "touchend" : "mouseup";
    $.event.special.myDown = {
        setup: function () {
            var isIOS = ((/iphone|ipad/gi).test(navigator.appVersion));
            var myDown = isIOS ? "touchstart" : "mousedown";
            $(this).bind(myDown + ".myDownEvent", function (event) {
                event.type = "myDown";
                ($.event.dispatch || $.event.handle).call(this, event);
            });
        },
        teardown: function () {
            $(this).unbind(".myDownEvent");
        }
    };

    function calculTotal(section) {
        var total = 0;
        $('#'+section+' .table-datatable tbody td.td_prime').each(function(){
            total += parseFloat($(this).html());
        });
        $('#'+section+'_total').html(parseFloat(total).toFixed(2));

        // N+1
        total = 0;
        $('#'+section+' .table-datatable tbody td.td_prime_n1').each(function(){
            total += parseFloat($(this).html());
        });
        $('#'+section+'_total_n1').html(parseFloat(total).toFixed(2));

        // N+2
        total = 0;
        $('#'+section+' .table-datatable tbody td.td_prime_n2').each(function(){
            total += parseFloat($(this).html());
        });
        $('#'+section+'_total_n2').html(parseFloat(total).toFixed(2));
    }

    if($('.table-datatable').size()>0){

        var datatable;
        if($('.table-datatable').size()>1) {
            var colOrder = 6;
            if($('#dossiers .table-datatable').data('view') == "2") {
                colOrder = 5;
            }
            var datatable1 = $('#dossiers .table-datatable').DataTable({
                            "bPaginate": false,
                            "order": [[ 0, "desc"],[1, "desc"],[colOrder, "desc"]],
                            "language": {
                                "url": window['base_url'] + "../assets/lang/dataTables.french.lang"
                            }
                        });
            var val = $('#filter-dossiers option:first-child').val();
            datatable1.search(val).draw();
            calculTotal('dossiers');

            var datatable2 = $('#commissions .table-datatable').DataTable({
                            "bPaginate": false,
                            "order": [[ 0, "desc"],[1, "desc"]],
                            "language": {
                                "url": window['base_url'] + "../assets/lang/dataTables.french.lang"
                            }
                        });
            datatable2.search(val).draw();
            calculTotal('commissions');

        } else {
            datatable = $('.table-datatable').DataTable({
                            "iDisplayLength": 25,
                            "order": [[ 0, "desc"],[1, "desc"]],
                            "language": {
                                "url": window['base_url'] + "../assets/lang/dataTables.french.lang"
                            }
                        });
        }

        setTimeout(function(){
            $('.container-table-content').fadeIn(500, function(){
                $('footer').fadeIn(200);
            });
        }, 1000);

        $(document).on('change', '.col-filter-partenaires input[type="radio"]', function(){
            var val = $(this).val();
            datatable.search(val).draw();
        });

        $(document).on('change', '.filter-calendar-table', function(){
            var val = $(this).val();
            if(val !== undefined && val !== '') {
                datatable1.search(val).draw();
                datatable2.search(val).draw();
            } else {
                datatable1.search('').draw();
                datatable2.search(val).draw();
            }
            calculTotal('dossiers');
            calculTotal('commissions');

            triggerPopovers();
        });

    } else {
        $('footer').fadeIn(200);
    }

    triggerPopovers();
    function triggerPopovers()
    {
        $(document).find('.link-popover').each(function(){
            var m_element = $(this);

            m_element.popover({
                html: true,
                trigger: 'manual',
                container: 'body'
            }).on("mouseenter", function () {
                var _this = this;
                $(this).popover("show");
                $(this).siblings(".popover").on("mouseleave", function () {
                    $(_this).popover('hide');
                });
            }).on("mouseleave", function () {
                var _this = this;
                setTimeout(function () {
                    if (!$(".popover:hover").length) {
                        $(_this).popover("hide");
                    }
                }, 50);
            });
        });

        $(document).find('.popover-confirm').each(function(){
            var m_element = $(this);
            
            m_element.popover({
                html: true,
                trigger: 'manual',
                container: 'body'
            }).on("focus", function () {
                var _this = this;
                $(this).popover("show");
                $(this).siblings(".popover").on("mouseleave", function () {
                    $(_this).popover('hide');
                });
            }).on("mouseleave", function () {
                var _this = this;
                setTimeout(function () {
                    if (!$(".popover:hover").length) {
                        $(_this).popover("hide");
                    }
                }, 50);
            });
        });
    }

    $(document).on(myDown, 'body', function(){
        if (!$(".popover:hover").length) {
            $(".popover").popover("hide");
        }
    });

    $(document).on(myDown, '.confirm-button-active', function(){
        var state = $(this).data('state');
        var id = $(this).data('id');
        $.ajax({
            url: base_url+'/actions/moderate-partner/',
            method: 'post',
            data: {
                state: state,
                id: id
            },
            success: function(response){
                if(response == 1){
                    var msg = 'Partenaire validé avec succès.';
                    if(state == 2){
                        msg = 'Partenaire refusé avec succès';
                    } else if(state == 3) {
                        msg = 'Partenaire désactivé avec succès';
                    }
                    alert(msg); // TODO POPUP
                    window.location.reload();
                } else {
                    alert('Une erreur innatendue est survenue. Code erreur : #BO-0001');
                }
            }
        });
    });

    $(document).on(myDown, '.btn-cancel-certificat', function(){
        var id = $(this).data('id');

        var r = confirm("Attention vous êtes sur le point d'annuler un contrat. Cette opération n'est pas réversible. Confirmez vous cette annulation ?");
        if (r == true) {
            txt = "You pressed OK!";
            $.ajax({
                url: base_url+'/actions/cancel-certificat/',
                method: 'post',
                data: {
                    id: id,
                    comment: $('#txt_cancel_'+id).val()
                },
                success: function(response){
                    if(response == 1){
                        var new_total = parseInt($('.panel-title .tag-pill').html())-1;
                        if(new_total<0) { new_total = 0; }

                        var msg = 'Certificat annulé avec succès.';
                        $('#tr_'+id).addClass('tr_cancel');
                        $('#tr_'+id+' .td_prime').html('0');
                        $('#tr_'+id+' .td_certificat').html($('#tr_'+id).data('certificat'));
                        $('#tr_comm_'+id).remove();
                        $('.panel-title .tag-pill').html(new_total);

                        calculTotal('dossiers');
                        calculTotal('commissions');

                        alert(msg); // TODO POPUP
                        //window.location.reload();
                    } else {
                        alert('Une erreur innatendue est survenue. Code erreur : #BO-0010');
                    }
                }
            });
        }
    });

    if($('#form_partenaire').size()>0){
        
        var fieldPartenaire = $('#form_partenaire #partenaire_nom');
        var fieldSousDomaine = $('#form_partenaire #sousdomaine');
        if(fieldPartenaire.size()>0 && fieldSousDomaine.size()>0 && fieldSousDomaine.val() == '' && fieldSousDomaine.attr('readonly') !== 'readonly'){
          
            var value = fieldPartenaire.val();
            fieldCompleteSousDomaine(value);
           
            function fieldCompleteSousDomaine(value){
                if(value!==undefined && value!=''){
                    value = cleanStr(value);
                    fieldSousDomaine.val(value);
                }
            }

            $(document).on('change', '#form_partenaire #partenaire_nom', function(){
                fieldCompleteSousDomaine($(this).val());
            });
        }

        var fieldContact = $('#form_partenaire #email');
        var fieldLogin = $('#form_partenaire #login');
        if(fieldContact.size()>0 && fieldLogin.attr('readonly') !== "readonly" && fieldLogin.val() == '') {
          
            var value = fieldContact.val();
            fieldCompleteLogin(value);
           
            function fieldCompleteLogin(value){
                if(value!==undefined && value!=''){
                    value = cleanStr(value);
                    fieldLogin.val(value);
                }
            }

            $(document).on('change', '#form_partenaire #contact_nom', function(){
                fieldCompleteLogin($(this).val());
            });
        }
    }

    function accentsTidy(s){
        var r=s.toLowerCase();
        
        r = r.replace(new RegExp("\\s", 'g'),"");
        r = r.replace(new RegExp("[àáâãäå]", 'g'),"a");
        r = r.replace(new RegExp("æ", 'g'),"ae");
        r = r.replace(new RegExp("ç", 'g'),"c");
        r = r.replace(new RegExp("[èéêë]", 'g'),"e");
        r = r.replace(new RegExp("[ìíîï]", 'g'),"i");
        r = r.replace(new RegExp("ñ", 'g'),"n");                            
        r = r.replace(new RegExp("[òóôõö]", 'g'),"o");
        r = r.replace(new RegExp("œ", 'g'),"oe");
        r = r.replace(new RegExp("[ùúûü]", 'g'),"u");
        r = r.replace(new RegExp("[ýÿ]", 'g'),"y");
        r = r.replace(new RegExp("\\W", 'g'),"");

        return r;
    };

    function cleanStr(str){
        str = accentsTidy(str);
        return str.toLowerCase().trim().replace(/ /g,'').replace(/[^\w\s]/gi, '');
    }

});