jQuery.noConflict();
jQuery(document).ready(function ($) {

  // click touch
  var isIOS = ((/iphone|ipad/gi).test(navigator.appVersion));
  var myDown = isIOS ? "touchstart" : "mousedown";
  var myUp = isIOS ? "touchend" : "mouseup";
  $.event.special.myDown = {
      setup: function () {
          var isIOS = ((/iphone|ipad/gi).test(navigator.appVersion));
          var myDown = isIOS ? "touchstart" : "mousedown";
          $(this).bind(myDown + ".myDownEvent", function (event) {
              event.type = "myDown";
              ($.event.dispatch || $.event.handle).call(this, event);
          });
      },
      teardown: function () {
          $(this).unbind(".myDownEvent");
      }
  };

  if($('.select-suggest').size()>0){
      $('.select-suggest').selectize({
          sortField: 'text',
          maxItems: 1,
          create: false,
          persist: true
      });
  };

  if($('.select-selectize').size()>0){
      $('.select-selectize').selectize({
          sortField: 'text',
          persist: true,
          maxItems: 1,
          create: function(input) {
             return {
                 value: input,
                 text: input
             }
          },
          render: {
            option_create: function (data, escape) {
                return '<div class="create">Ajouter <strong>' + escape(data.input) + '</strong>&hellip;</div>';
            }
          }
      });
  }

  // upload logo
  if($('#form_partenaire input[type="file"]').size()>0)
  {
      // A chaque sélection de fichier
      $('#form_partenaire').find('#logo_upload').on('change', function (e) {
          var files = $(this)[0].files;

          if (files.length > 0) 
          {              
              if($('.logo-preview').css('display') == 'none'){
                  $('.logo-preview').fadeIn(400);
              }

              // On part du principe qu'il n'y qu'un seul fichier
              // étant donné que l'on a pas renseigné l'attribut "multiple"
              var file = files[0],
                  $image_preview = $('.logo-preview');
   
              // Ici on injecte les informations recoltées sur le fichier pour l'utilisateur
              $image_preview.find('.logo-preview').removeClass('hidden');
              $image_preview.find('img').attr('src', window.URL.createObjectURL(file));
              $image_preview.find('h6').html(file.name);
              $('#logo').val(file.name);
              $('#logo_new').val('1');
              //$image_preview.find('.caption').html(file.size +' bytes');
          }
      });
   
      // Bouton "Annuler" pour vider le champ d'upload
      $('#remove_logo').on(myDown, function (e) {
          e.preventDefault();

          $('#logo_new').val('1');
          $('#logo').val('');
          $('#logo_upload').val('');
          $('.logo-preview').fadeOut(400);
      });

  }

  // handle phones and country 
  $(document).on('change', '.country-list', function(){
    var relatedToCountry = $(this).data('rel');
    var relatedToPhone = $(this).data('phone');

    // 2K19
    /*var tmp_country = $(document).find('#assure-sport-pratique-'+$(this).data('id'));
    if($(this).val() != $(this).data('france'))
    {
      tmp_country.removeClass('hidden');
      $(document).find('#assure_sport_'+$(this).data('id')).attr('required', true);
    }
    else
    {
      tmp_country.removeClass('hidden');
      $(document).find('#assure_sport_'+$(this).data('id')).attr('required', false).removeAttr('required');
      tmp_country.addClass('hidden');
    }*/

    if(relatedToCountry !== undefined && relatedToPhone !== undefined)
    {
      var country = $(this).val();
      var inputCountry = $('.output-'+relatedToCountry);
      var inputIndicator = $('#'+relatedToPhone);

      var relatedToMobile = $(this).data('mobile');
      var inputMobileIndicator = null;
      if(relatedToMobile !== undefined)
      {
        inputMobileIndicator = $('#'+relatedToMobile);
      }

      $.post(window['base_url'].replace('intranet/', '') + 'get-country-phone-infos/', {
        country: country
      }, 
        function(data) 
        {
          inputIndicator.val(data.indicator);
          inputCountry.html(data.output);
          if(inputMobileIndicator!=null)
          {
            inputMobileIndicator.val(data.indicator);
          }
        }
      );
    }

  });

  $(document).on('change', '#type_partenaire', function(){
      var blocContent = $('.display_type_partenaire');
      var type = $(this).val();

      if(type == 0)
      {
        blocContent.css('display', 'block');
        blocContent.find('input').each(function(){
          $(this).attr('required', true);
        });
      }
      else if(type == 1)
      {
        blocContent.css('display', 'none');
        blocContent.find('input').each(function(){
          $(this).attr('required', null);
        });
      }
    });

    $(handleCardSelections);
    function handleCardSelections()
    {
        $('.btn-selection-card').each(function(){
            var parentCard = $(this).parent().parent();
            var noChange = $(this).data('nochange');
            var btnSelection = $(this);

            if(noChange == "1")
            {
                //btnSelection.css('display', 'none');
            }
            else
            {
              /*if($(this).attr('id') == "cb-annulation-voyage")
              {
                if(!$(this).parent().parent().hasClass('card-selected'))
                {
                  $(document).find('#ind-annulation-voyage').find('.input-required-star').addClass('hidden');
                  $(document).find('#ind-annulation-voyage').find('.input-group input').attr('required', false).attr('disabled', true).val('');
                }
              }*/

              if(!parentCard.hasClass('card-selected'))
              {
                  btnSelection.html(window['text_select'] +' <i class="fa fa-check"></i>');
              }
              else
              {
                  btnSelection.html(window['text_unselect'] + ' <i class="fa fa-close"></i>')
              }
            }

        });
    }

    $(document).on(myDown, '.btn-selection-card', function(){
        var checkboxFieldName = $(this).data('checkbox');
        var checkboxField = $('#'+checkboxFieldName);
        var valueChecked = $(this).data('value');
        var parentCard = $(this).parent().parent();
        var parentRow = $(this).parent().parent().parent().parent();
        var scrollNext = $(this).data('scrollnext');
        var doScroll = false;
        var btnSelection = $(this);
        var noChange = $(this).data('nochange');
        var updateDuree = $(this).data('updateduree');
        var checkalloption = $(this).attr('checkalloption');
        var checkallann = $(this).data('checkallann');

        if(scrollNext !== undefined)
        {
            doScroll = true;
        }

        if(noChange == "1" && parentCard.hasClass('card-selected'))
        {
        }
        else
        {
            if(parentCard.hasClass('card-selected'))
            {
                // IS UNSELECTED
                checkboxField.val("");
                $('#'+checkboxFieldName+'-'+valueChecked).removeClass('card-selected');

                var parent = $(this).parent().parent();
                if(parent.hasClass('card-dateeffet')) 
                {
                    parentRow.find('.datepicker').removeAttr('required');
                }

                if(noChange == "1")
                {
                }
                else
                {
                    btnSelection.fadeOut(400, function(){
                        btnSelection.html(window['text_select'] +' <i class="fa fa-check"></i>').fadeIn(300);
                    });
                }

                if($(this).attr('id') == "cb-assistance-monde")
                {
                  $(handleDefaultOptionSelection);
                }

                if($(this).attr('id') == "cb-annulation-voyage")
                {
                  //$(document).find('#ind-annulation-voyage').find('.input-required-star').addClass('hidden');
                  $(document).find('#ind-annulation-voyage').find('.input-group input').attr('required', false).attr('disabled', true).val('');
                }

                if(updateDuree == "1")
                {
                    // 1 an -> 7 à 12 mois
                    $('#tarif_duree option:nth-last-child(2)').css('display', 'block');
                    $('#tarif_duree option:last-child').css('display', 'none');
                    $('#tarif_duree').val('');
                }
                
                if(checkalloption == "1") // = option 1b
                {
                    if($('#table-list-assures').size()>0)
                    {
                        $('#table-list-assures td.td_checkbox_option1b input[type="checkbox"]').each(function(){
                            $(this).prop( "checked", false );
                        });

                        // 7 à 12 mois -> 1 an
                        /*,j$('#table-list-assures .tarif_duree_list option:nth-last-child(2)').css('display', 'block');
                        $('#table-list-assures .tarif_duree_list option:last-child').css('display', 'none');
                        $('#table-list-assures .tarif_duree_list').val('');*/
                    }
                }
                else if(checkalloption == "0") // = option 1
                {
                    if($('#table-list-assures').size()>0)
                    {
                        $('#table-list-assures td.td_checkbox_option1 input[type="checkbox"]').each(function(){
                            $(this).prop( "checked", false );
                        });
                    }
                }

                if(checkallann == "1")
                {
                    if($('#table-list-assures').size()>0)
                    {
                        $('#table-list-assures td.td_checkbox_annulation_voyage input[type="checkbox"]').each(function(){
                            $(this).prop( "checked", false );
                        });
                    }
                }
            }
            else
            {
                // IS SELECTED
                checkboxField.val(valueChecked);

                // reset other checkboxes
                parentRow.find('.card-checkbox').removeClass('card-selected');
                $('#'+checkboxFieldName+'-'+valueChecked).addClass('card-selected');
                parentRow.find('.btn-selection-card').html(window['text_select'] +' <i class="fa fa-check"></i>');

                var parent = $(this).parent().parent();
                if(parent.hasClass('card-dateeffet')) 
                {
                    if(valueChecked == "1") {
                        parentRow.find('.datepicker').attr('required', 'required');
                    } else {
                        parentRow.find('.datepicker').removeAttr('required');
                    }
                }

                if(doScroll)
                {
                    scrollToButtons(scrollNext);
                }

                if(noChange == "1")
                {
                    btnSelection.fadeOut(400);
                }
                else
                {
                    btnSelection.fadeOut(400, function(){
                        btnSelection.html(window['text_unselect'] + ' <i class="fa fa-close"></i>').fadeIn(300);
                    });
                }

                if($(this).attr('id') == "cb-assistance-monde")
                {
                  $(handleDefaultOptionSelection);
                }

                if($(this).attr('id') == "cb-annulation-voyage")
                {
                  //$(document).find('#ind-annulation-voyage').find('.input-required-star').removeClass('hidden');
                  $(document).find('#ind-annulation-voyage').find('.input-group input').attr('disabled', false);
                  $(document).find('#ind-annulation-voyage').find('.input-group input').attr('required', true);
                }

                if(updateDuree == "1")
                {
                    // 1 an -> 7 à 12 mois
                    $('#tarif_duree option:nth-last-child(2)').css('display', 'none');
                    $('#tarif_duree option:last-child').css('display', 'block');
                    $('#tarif_duree').val('');
                }
                
                if(checkalloption == "1") // option 1b
                {
                    if($('#table-list-assures').size()>0)
                    {
                        $('#table-list-assures td.td_checkbox_option1b input[type="checkbox"]').each(function(){
                            $(this).prop( "checked", true );
                        });

                        /*// 1 an -> 7 à 12 mois
                        $('#table-list-assures .tarif_duree_list option:nth-last-child(2)').css('display', 'none');
                        $('#table-list-assures .tarif_duree_list option:last-child').css('display', 'block');
                        $('#table-list-assures .tarif_duree_list').val('');*/
                    }
                }
                else if(checkalloption == "0") // option 1
                {
                    if($('#table-list-assures').size()>0)
                    {
                        $('#table-list-assures td.td_checkbox_option1 input[type="checkbox"]').each(function(){
                            $(this).prop( "checked", true );
                        });
                    }
                }

                if(checkallann == "1")
                {
                    if($('#table-list-assures').size()>0)
                    {
                        $('#table-list-assures td.td_checkbox_annulation_voyage input[type="checkbox"]').each(function(){
                            $(this).prop( "checked", true );
                        });
                    }
                }
            }
        }
        

    });

    function scrollToButtons(scroll)
    {
        var scrollTo;
        if(scroll != "1")
        {
            scrollTo = $('#'+scroll);
        }
        else
        {
            scrollTo = $('#steps-buttons-section');
        }

        if(scrollTo.size()>0)
        {
            $('html, body').animate({ scrollTop: scrollTo.offset().top-120 }, 500);
        }
    }

    var m_isCollectifAndDifferent = false;
    if($(document).find('#collectif-not-same-conditions').length > 0)
    {
      m_isCollectifAndDifferent = true;
    }

    $(handleOption1CollectifDiff);
    $(document).on('change', '#table-list-assures .td_checkbox_option input, #table-list-assures .td_checkbox_option1 input, #table-list-assures .td_checkbox_option1b input', function(){
      $(handleOption1CollectifDiff);
    });

    function handleOption1CollectifDiff()
    {
      if(m_isCollectifAndDifferent)
      {
        var count_checked1 = $(document).find('#table-list-assures .td_checkbox_option1 input:checked').length;
        var count_checked1b = $(document).find('#table-list-assures .td_checkbox_option1b input:checked').length;
        var count_checked = count_checked1 + count_checked1b;
        if(count_checked == 0)
        {
          $(document).find('#assistance_monde-1').removeClass('card-selected');
          $(document).find('#assistance_monde-1').find('input').attr('required', false).removeAttr('required');
        }
        else
        {
          if(!$(document).find('#assistance_monde-1').hasClass('card-selected'))
          {
            $(document).find('#assistance_monde-1').addClass('card-selected');
            $(document).find('#assistance_monde-1').find('.btn-selection-card').html(window['text_unselect'] + ' <i class="fa fa-close"></i>');
          }
          $(document).find('#assistance_monde-1').find('input').attr('required', true);
        }
      }
    }

    $(handleOption2CollectifDiff);
    $(document).on('change', '#table-list-assures .td_checkbox_annulation_voyage input', function(){
      $(handleOption2CollectifDiff);
    });

    function handleOption2CollectifDiff()
    {
      if(m_isCollectifAndDifferent)
      {
        var count_checked = $(document).find('#table-list-assures .td_checkbox_annulation_voyage input:checked').length;
        if(count_checked == 0)
        {
          $(document).find('#annulation_voyage-1').removeClass('card-selected');
          $(document).find('#annulation_voyage-1').find('input').attr('required', false).removeAttr('required');
          $(document).find('.assure-option2-content').addClass('hidden').find('input').attr('required', false).removeAttr('required');
        }
        else
        {
          if(!$(document).find('#annulation_voyage-1').hasClass('card-selected'))
          {
            $(document).find('#annulation_voyage-1').addClass('card-selected');
            $(document).find('#annulation_voyage-1').find('.btn-selection-card').html(window['text_unselect'] + ' <i class="fa fa-close"></i>');
          }
          $(document).find('#annulation_voyage-1').find('input').attr('required', true);
          
          // enable or not option 2 dates choices if selected
          $(document).find('.assure-option2-content').addClass('hidden').find('input').attr('required', false).removeAttr('required');
          $(document).find('#table-list-assures .td_checkbox_annulation_voyage input:checked').each(function(){
            var tmp_id = $(this).attr('id').replace('annulation_voyage_', '');
            $(document).find('#assure-option2-content-'+tmp_id).removeClass('hidden').find('input').attr('required', true);
          });
        }
      }
    }

    $(handleDefaultOptionSelection);
    $(document).on('change', '#assistance_monde-1 input[name="assistance_monde_option"]', function(){
      $(handleDefaultOptionSelection);
    });

    function handleDefaultOptionSelection()
    {
      var current_option1 = $(document).find('input[name="assistance_monde_option"]:checked').val();
      if(m_isCollectifAndDifferent)
      {
        if($(document).find('#assistance_monde-1').hasClass('card-selected'))
        {
          if(current_option1 == 0)
          {
            $(document).find('#table-list-assures .td_checkbox_option1 input').prop( "checked", true );
          }
          else if(current_option1 == 1)
          {
            $(document).find('#table-list-assures .td_checkbox_option1b input').prop( "checked", true );
          }
        }
        else
        {
          $(document).find('#table-list-assures .td_checkbox_option input').prop( "checked", true );
        }
      }

      if(current_option1 == 0)
      {
        $(document).find('.option-1b-text').addClass('hidden');
      }
      else if(current_option1 == 1)
      {
        $(document).find('.option-1b-text').removeClass('hidden');
      }
    }

    $(document).find('.form-group-prise-effet input').each(function(){
      var t_id = $(this).data('id');
      checkPriseEffetDateTime(t_id);
    });

    $(document).on('change', '.form-group-prise-effet input', function(){
      var t_id = $(this).data('id');
      checkPriseEffetDateTime(t_id);
    });

    function checkPriseEffetDateTime(t_id)
    {
      var t_container = $(document).find('.form-group-prise-effet.effet-'+t_id);
      var t_errorContainer = $(document).find('.alert-error-priseeffet-'+t_id);
      var t_inputGroups = t_container.find('.input-group-sm');
      var t_date = t_container.find('.field-date').val();
      var t_time = t_container.find('.field-time').val();

      var t_datetime = t_date + ' '+t_time+':00';
      var now = moment(t_datetime, "DD/MM/YYYY HH:mm:ss").tz('Europe/Paris'); // DATE 1
      var then  = moment().tz('Europe/Paris'); // DATE 2

      var ms = now.diff(then);
      var d = moment.duration(ms);
      var s = Math.floor(d.asHours()) + moment.utc(ms).format(":mm:ss"); // DIFF

      var check_hours = parseInt(d.asHours());
      if(check_hours < 24)
      {
        // > 24h = error
        t_errorContainer.removeClass('hidden');
        t_inputGroups.addClass('has-error');
      }
      else
      {
        t_errorContainer.addClass('hidden');
        t_inputGroups.removeClass('has-error');
      }
    }

});