<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'home';
$route['404_override'] = 'error';
$route['translate_uri_dashes'] = TRUE;

//$route['fr/'] = 'home/fr';
	$route['call_autoresponse_collectif.php'] = 'home/call-autoresponse-collectif';
	$route['page.php'] = 'home/getback_from_paiement';
	$route['certificat/(:any)'] = 'home/certificat/$1';
	$route['certificat/(:any)/(:any)'] = 'home/certificat/$1/$2';
	//$route['contrat/(:any)'] = 'home/contrat/$1';
	//$route['assursport/en-savoir-plus'] = 'home/assursport/';
// ROUTES FR
	$route['en-savoir-plus'] = 'home/en-savoir-plus';
	$route['individuelle-accident'] = 'home/en-savoir-plus';
	$route['annuaire-des-federations'] = 'home/annuaire-des-federations';
	$route['assistance-annulation-bagages'] = 'home/assistance/';
	$route['obtenir-un-tarif'] = 'home/obtenir-un-tarif';
	$route['obtenir-un-tarif/(:any)'] = 'home/obtenir-un-tarif/$1';
	$route['obtenir-un-tarif/(:any)/(:any)'] = 'home/obtenir-un-tarif/$1/$2';
	$route['obtenir-un-tarif/individuel/etape4/devis'] = 'home/devis';
	$route['obtenir-un-tarif/collectif/etape4/devis'] = 'home/devis';
	$route['telecharger-contrat/(:any)'] = 'home/telecharger_contrat/$1/french';
	$route['telecharger-devis/(:any)'] = 'home/telecharger_devis/$1/french';
	$route['reprendre-souscription/(:any)'] = 'home/reprendre_souscription/$1';
	$route['assurance-emprunteur'] = 'home/assurance-emprunteur';
	$route['devenir-partenaire/(:any)'] = 'home/devenir-partenaire/$1';
	$route['devenir-partenaire-inscription-reussie'] = 'home/devenir-partenaire-inscription-reussie';
	$route['politique-de-confidentialite'] = 'home/politique-de-confidentialite';
	$route['nous-contacter'] = 'home/nous-contacter';
	$route['nous-contacter-message-envoye'] = 'home/nous-contacter-message-envoye';
	$route['sport-extreme-liste/(:any)'] = 'home/sport-extreme-liste/$1';
	$route['sport-extreme-liste'] = 'home/sport-extreme-liste';
//

// ROUTE EN
	$route['individual-accident'] = 'home/en-savoir-plus';
	$route['book-of-federations'] = 'home/annuaire-des-federations';
	$route['get-a-price-quote'] = 'home/obtenir-un-tarif';
	$route['get-a-price-quote/(:any)'] = 'home/obtenir-un-tarif/$1';
	$route['get-a-price-quote/(:any)/(:any)'] = 'home/obtenir-un-tarif/$1/$2';
	$route['get-a-price-quote/individual/step4/quotes'] = 'home/devis';
	$route['get-a-price-quote/collective/step4/quotes'] = 'home/devis';
	$route['assistance-trip-cancellation-luggage'] = 'home/assistance/';
	$route['download-contract/(:any)'] = 'home/telecharger_contrat/$1/english';
	$route['download-quote/(:any)'] = 'home/telecharger_devis/$1/english';
	$route['take-out-a-subscription/(:any)'] = 'home/reprendre_souscription/$1';
	$route['borrower-insurance'] = 'home/assurance-emprunteur';
	$route['become-a-partner/(:any)'] = 'home/devenir-partenaire/$1';
	$route['become-a-partner-registration-successful'] = 'home/devenir-partenaire-inscription-reussie';
	$route['privacy-policy'] = 'home/politique-de-confidentialite';
	$route['contact-us'] = 'home/nous-contacter';
	$route['contact-us-message-sent'] = 'home/nous-contacter-message-envoye';
	$route['list-of-extreme-sports/(:any)'] = 'home/sport-extreme-liste/$1';
	$route['list-of-extreme-sports'] = 'home/sport-extreme-liste';
//

$route['get-country-phone-infos'] = 'home/get-country-phone-infos';
$route['api/newsletter-inscription'] = 'api/newsletter_inscription';
$route['api/formulaire-tarifs/(:any)'] = 'api/form_tarifs/$1';
$route['lpf/(:any)'] = 'lpf/$1';
$route['lang/(:any)'] = 'LanguageSwitcher/switchlang/$1';
$route['ipid'] = 'home/ipid';