<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Api extends CI_Controller {

	function __construct()
	{
		parent::__construct();

		$this->_init();
	}

	private function _init()
	{
		$this->output->set_template('api');
		$this->load->model('tarifs_model');
		$this->load->model('assistancemonde_model');

		require(FCPATH . 'application/libraries/SendyPHP.php');
	}

	/*public function cookie_consent()
	{
		header("HTTP/1.1 200 OK");

		$result = new Stdclass();
		$result->status = true;
		
		$cookie = array(
                        'name'   => 'cookie_consent',
                        'value'  => 'cookie_consent',                            
                        'expire' => 3600*24*30,                                                                                   
                        'secure' => FALSE
                    );
		$this->input->set_cookie($cookie);

		echo json_encode($result);
	}*/

	public function newsletter_inscription()
	{
		$email = $this->input->post('email');
		$name = $this->input->post('name');
		$list = $this->input->post('list');

		if($email != '' && $name != '' && $list != '')
		{
			header("HTTP/1.1 200 OK");

			$result = new Stdclass();
			$result->status = false;
			$result->message = '';

			$config = array(
				'api_key' => 'tmAaPwFoZwIyS9PJv4HS', //your API key is available in Settings
				'installation_url' => 'http://affiliassur.com/',  //Your Sendy installation
				'list_id' => $list
			);
			
			$sendy = new \SendyPHP\SendyPHP($config);
			$subscribe = $sendy->subscribe(array(
				'name' => $name,
				'email' => $email
			));
			$result->status = $subscribe['status'];
			if(isset($subscribe['message']))
			{
				$message = $subscribe['message'];
				$message = mb_strtolower(strtr($message, array("." => "")));
				$result->message = strtr($message, 
										array(
											"already subscribed" => $this->lang->line('form_newsletter_already').".",
											"subscribed" => $this->lang->line('form_newsletter_success')."."
										)
									);
			}

			echo json_encode($result);
			exit();
		}
		else
		{
			//redirect(base_url());
			exit();
		}
	}

	public function form_tarifs($id = 0)
	{
		$debug = false;
		$data = [];
		$data['idList'] = $id;
		$data['class_btn'] = '';
		$data['disabled'] = '';

		$config = array(
			'api_key' => 'tmAaPwFoZwIyS9PJv4HS', //your API key is available in Settings
			'installation_url' => 'http://affiliassur.com/',  //Your Sendy installation
			'list_id' => $id
		);
		$sendy = new \SendyPHP\SendyPHP($config);

		// FAKE SUBSCRIPTION TO CHECK IF LIST EXISTS
		$test = $sendy->subscribe(array(
			'name' => 'test-check-list-signo',
			'email' => 'test@signo.fr'
		));

		if(!$test['status'])
		{
			$data['idError'] = true;
		}
		else
		{
			$data['idError'] = false;

			// UNSUBSCRIBE PREVIOUS
			$unsubscribe = $sendy->unsubscribe('test@signo.fr');

			$data['dureeList'] = array(
				1 => $this->lang->line('form_pricing_list_1'),
				2 => $this->lang->line('form_pricing_list_2'),
				3 => $this->lang->line('form_pricing_list_3'),
				4 => $this->lang->line('form_pricing_list_4'),
				5 => $this->lang->line('form_pricing_list_5'),
				6 => $this->lang->line('form_pricing_list_6'),
				7 => $this->lang->line('form_pricing_list_7'),
				8 => $this->lang->line('form_pricing_list_8'),
				9 => $this->lang->line('form_pricing_list_10'),
			);

			$data['requestSuccess'] = false;
			$data['formSubmitted'] = false;
			if($_SERVER['REQUEST_METHOD'] == 'POST')
			{
				if($this->input->post('submit'))
				{
					$data['formSubmitted'] = true;

					$this->form_validation->set_rules('nom', $this->lang->line('form_lastname'), 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
					$this->form_validation->set_rules('prenom', $this->lang->line('form_firstname'), 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
					$this->form_validation->set_rules('email', $this->lang->line('form_mail_short'), 'trim|required|valid_email|max_length[100]|xss_clean|strip_tags');
					$this->form_validation->set_rules('capital_montant', $this->lang->line('form_insured_capital'), 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[10000]|less_than_equal_to[200000]');
					$this->form_validation->set_rules('categorie_sports', $this->lang->line('form_category'), 'trim|required|min_length[1]|max_length[1]|xss_clean|strip_tags');
					$this->form_validation->set_rules('assistance_monde', $this->lang->form('form_assistance'), 'trim|min_length[1]|max_length[1]|xss_clean|strip_tags');
					$this->form_validation->set_rules('tarif_duree', $this->lang->form('form_contrat_duration'), 'trim|required|xss_clean|strip_tags');


					$calculData['nom'] = $this->input->post('nom');
					$calculData['prenom'] = $this->input->post('prenom');
					$calculData['email'] = $this->input->post('email');
					$calculData['capital_montant'] = $this->input->post('capital_montant');
					$calculData['categorie_sports'] = $this->input->post('categorie_sports');
					$calculData['assistance_monde'] = $this->input->post('assistance_monde');
					$calculData['tarif_duree'] = $this->input->post('tarif_duree');

					if(!$this->form_validation->run() == FALSE)
					{
						$data['requestMsg'] = true;
						$data['class_btn'] = ' hidden';
						$data['disabled'] = ' disabled="disabled"';

						$calculData['tauxHt'] = $this->tarifs_model->getTauxHT($calculData['categorie_sports'], $calculData['tarif_duree']);

						$assMondeTarif = 0;
						$calculData['assTtc'] = $this->assistancemonde_model->getTarifFromCatDuree($calculData['categorie_sports'], $calculData['tarif_duree']);
						$assMondeTarif = floatval($calculData['assTtc']);
						
						$prime1 = evalPrime($calculData['capital_montant'], $calculData['categorie_sports'], $calculData['tauxHt']);
						$prime2 = $prime1 + $assMondeTarif;
						
						$primeSansAssistance = number_format($prime1, 2, '.', ' ');
						$primeAvecAssistance = number_format($prime2, 2, '.', ' ');

						$calculData['tarifCalculSans'] = $primeSansAssistance;
						$calculData['tarifCalculAvec'] = $primeAvecAssistance;

						// VERS ETAPE 2
						$tarifData = [];
							$tarifData['type_tarif'] = "0";
							$tarifData['capital_montant'] = $calculData['capital_montant'];
							$tarifData['categorie_sports'] = $calculData['categorie_sports'];
							$tarifData['tmp_duree_rang'] = $calculData['tarif_duree'];
							
							$tarifData['infos_assure'] = [];
								$tarifData['infos_assure']['assure_nom_1'] = $calculData['nom'];
								$tarifData['infos_assure']['assure_prenom_1'] = $calculData['prenom'];
								$tarifData['infos_assure']['assure_email_1'] = $calculData['email'];

							$tarifData['etape_1_valid'] = true;
							$tarifData['etape_2_valid'] = true;

						$this->session->set_userdata('tarifData', $tarifData);
					}
				}
			}

			$data['calcul_data'] = $calculData;
			// re-save session to keep it
			$this->session->set_userdata('calculData', $calculData);

			// VIEW
			/*if($data['requestSuccess']) {
				//$registration = array('success' => true);
				//$this->session->set_userdata('registration', $registration);
			} else {
				$this->load->view('api/form_tarifs', $data);
			}*/
		}

		$this->load->view('api/form_tarifs', $data);
	}

}
