<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Intranet extends CI_Controller {

	function __construct()
	{
		parent::__construct();

		$this->_init();
	}

	private function _init()
	{
		$this->lang->load('information', "french");

		$this->load->helper('excel');
		$this->load->model('users_model');
		$this->load->model('partenaires_model');
		$this->load->model('encaissement_model');
		$this->load->model('souscripteurs_model');
		$this->load->model('taux_model');

		$user = $this->session->userdata('user');
		if($user) 
		{
			// re sauve la session pour la maintenir à chaque refresh plus longtemps
			$this->session->set_userdata('user', $user);
		}
	}

	public function index()
	{
		$user = $this->session->userdata('user');
		$data['is_invalid'] = false;
		$isLoggedIn = false;

		if($user)
		{
			// connecté
			$data["user"] = $user;
			$data['is_invalid'] = false;
			$isLoggedIn = true;
		}
		else
		{
			$data['is_invalid'] = false;

			$this->form_validation->set_rules('login', 'Identifiant', 'required|min_length[4]|max_length[50]|xss_clean|strip_tags');
			$this->form_validation->set_rules('password', 'Password', 'required|min_length[5]|max_length[50]|xss_clean|strip_tags');

			if($this->form_validation->run() && $_SERVER['REQUEST_METHOD'] == 'POST')
			{
				if($this->users_model->login())
				{
					$isLoggedIn = true;
					$data['is_invalid'] = false;
				}
				else
				{
					$data['invalid_message'] = "Echec lors de la connexion. Vérifier vos identifiants, ou attendez la validation de votre compte.";
					$data['is_invalid'] = true;
				}
			}
		}

		if(!$data['is_invalid'] && $isLoggedIn)
		{
			// check if first connexion
			$user_firstime = $this->session->userdata('user_firstime');
			if($user_firstime && isset($user_firstime['first']) && $user_firstime['first'] == 1)
			{
				redirect("intranet/form/mon_compte");
			} else {
				redirect("intranet/section/ventes");
			}
		}
		else
		{
			$this->load->view('default/admin/index', $data);
		}

	}

	public function section($section, $action = '')
	{
		$user = $this->session->userdata('user');
		if(!$user)
		{
			redirect('intranet/');
		}
		else
		{
			$data["user"] = $user; 
			$data['is_invalid'] = false;
			$data['isSuperAdmin'] = checkIfSuperAdmin($user);
			$data['userId'] = $user['ID_PARTENAIRE'];

			$allowed_sections = array("ventes", "taux", "partenaires");
			if(!in_array($section, $allowed_sections)){
				redirect('intranet/');
			}

			// SECTIONS ONLY FOR SUPERADMIN
			if(!$data['isSuperAdmin'] && $section == "taux")
			{
				redirect('intranet/');
			}

			$data['section_title'] = '';
			$data['list_nb'] = 0;
			$data['current_list'] = [];
			$data['current_columns'] = [];
			$data['active_menu1'] = ''; $data['active_menu2'] = ''; $data['active_menu3'] = ''; $data['active_menu4'] = '';
			$data['nbNewPartners'] = $this->partenaires_model->nbNewPartners();

			switch($section)
			{
				case "ventes":
					$data['current_list_nb'] = $this->souscripteurs_model->nb();
					$data['current_list'] = $this->souscripteurs_model->get_all();
					$data['months_list'] = $this->souscripteurs_model->get_months();
					$data['section_title'] = 'Journal des ventes';
					$data['active_menu1'] = ' active';
				break;

				case "partenaires":
					$data['active_menu2'] = ' active';
					$data['section_title'] = 'Liste des partenaires affiliés';
					$data['current_list'] = $this->partenaires_model->get_all();
					$data['current_list_nb'] = $this->partenaires_model->nb();
				break;

				case "taux":
					$data['prime_assureur_principal'] = $this->taux_model->getTaux('prime_assureur_principal');
					$data['taux1'] = $this->taux_model->getTaux('commission_parent_role_1');
					$data['taux2'] = $this->taux_model->getTaux('commission_parent_role_2');
					$data['taux3'] = $this->taux_model->getTaux('commission_parent_role_3');
					$data['section_title'] = 'Les taux';
					$data['active_menu3'] = ' active';

					if($_SERVER['REQUEST_METHOD'] == 'POST')
					{
						$this->form_validation->set_rules('prime_assureur_principal', 'Taux assureur', 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[100]');
						$this->form_validation->set_rules('commission_parent_role_1', 'Taux 1 partenaires principaux', 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[100]');
						$this->form_validation->set_rules('commission_parent_role_2', 'Taux filleuls des partenaires', 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[100]');
						$this->form_validation->set_rules('commission_parent_role_3', 'Taux 2 partenaires principaux', 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[100]');
						$this->form_validation->set_rules('update_all', 'Modifier pour tous les partenaires', 'trim|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[1]');

						if(!$this->form_validation->run() == FALSE)
						{
							// taux par défaut
							$taux['prime_assureur_principal'] = $this->input->post('prime_assureur_principal');
							$taux['commission_parent_role_1'] = $this->input->post('commission_parent_role_1');
							$taux['commission_parent_role_2'] = $this->input->post('commission_parent_role_2');
							$taux['commission_parent_role_3'] = $this->input->post('commission_parent_role_3');

							$sql = $this->taux_model->update($taux);

							$updateAll = $this->input->post('update_all');
							if($updateAll == "1")
							{
								// TODO : Update all commissions from all partenaires WITH ID_PARENT IS ROLE 1
								// AND ID PARENT IS ROLE 2
								$sql = $this->taux_model->updateTaux('prime_assureur_principal', $taux['prime_assureur_principal']);
								$sql = $this->taux_model->updateTaux('commission_parent_role_1', $taux['commission_parent_role_1']);
								$sql = $this->taux_model->updateTaux('commission_parent_role_2', $taux['commission_parent_role_2']);
								$sql = $this->taux_model->updateTaux('commission_parent_role_3', $taux['commission_parent_role_3']);
							}
						}
					}

				break;
			}
			$data['section'] = $section;

			$this->load->view('default/admin/index', $data);
		}
	}

	public function form($action = '', $id = '', $param = '') {
		$user = $this->session->userdata('user');
		if(!$user || (!checkIfSuperAdmin($user) && $action != "mon_compte"))
		{
			redirect('intranet/');
		}
		else
		{
			$data["user"] = $user; 
			$data['is_invalid'] = false;
			$isSuperAdmin = checkIfSuperAdmin($user);
			$data['isSuperAdmin'] = $isSuperAdmin;

			$data['nbNewPartners'] = $this->partenaires_model->nbNewPartners();

			$allowed_actions = array('nouveau_partenaire', 'edit_partenaire', 'check_partenaire', 'mon_compte');

			if($action != '') {

				if(!in_array($action, $allowed_actions)) {
					redirect('intranet/');
				} else {

					if($isSuperAdmin)
					{
						$data['partenairesList'] = $this->partenaires_model->getListPartenaires();
					}
					//$data['fonctionsList'] = $this->partenaires_model->getListFonctionsPartenaires();
					//$data['activitesList'] = $this->partenaires_model->getListActivitesPartenaires();

					// upload logo
					if($action != "check_partenaire")
					{
						$config = array(
							'upload_path' => FCPATH . 'uploads/',
							'allowed_types' => 'jpeg|jpg',
							'overwrite' => FALSE,
							'max_size' => '10000',
							'max_width' => '500',
							'max_height' => '100'
						);
						$this->load->library('upload', $config);
					}

					if($action == 'check_partenaire' || $action == 'nouveau_partenaire' || $action == 'edit_partenaire') {
						$data['active_menu1'] = '';
						$data['active_menu2'] = ' active';
						$data['active_menu3'] = '';
						$data['active_menu4'] = '';
					} else if($action == "mon_compte") {
						$data['active_menu1'] = '';
						$data['active_menu2'] = '';
						$data['active_menu3'] = '';
						$data['active_menu4'] = ' active';

						$user_firstime = $this->session->userdata('user_firstime');
						if($user_firstime && isset($user_firstime['first']))
						{
							if($user_firstime['first'] == 1)
							{
								$data['is_first_time'] = true;
								// reset session
								$this->session->set_userdata('user_firstime', array("first" => 0));
							}
						}
					}
						
					$data['section'] = 'partenaires_form';

					if($action == 'nouveau_partenaire') {
						$data['submit_type'] = 'add';
						$data['section_title'] = 'Nouveau partenaire';
						$data['submit_text'] = 'Créer le partenaire';
					} else if($action == 'edit_partenaire') {
						$data['submit_type'] = 'edit';
						$data['section_title'] = 'Modifier partenaire';
						$data['submit_text'] = 'Valider les modifications';
						$data['id_partenaire'] = $id;
					} else if($action == 'check_partenaire') {
						$data['submit_type'] = 'check';
						$data['section_title'] = 'Vérification partenaire';
						$data['submit_text'] = 'Valider ce partenaire';
						$data['id_partenaire'] = $id;
					} else if($action == 'mon_compte') {
						$data['submit_type'] = 'account';
						$data['section_title'] = 'Mon compte';
						$data['submit_text'] = 'Valider les modifications';
						$data['id_partenaire'] = $user['ID_PARTENAIRE'];
					}

					$partnerType = 0;
					if(isset($data['id_partenaire'])) {
						// check if partenaire id exists
						$checkIdPartenaire = $this->partenaires_model->find($data['id_partenaire']);
						if(!$checkIdPartenaire){
							redirect('intranet/section/partenaires');
						} else {
							$data['partenaire_data'] = $checkIdPartenaire;
							$partnerType = $checkIdPartenaire->TYPE_PARTENAIRE;
						}
					}
					$data['partnerType'] = $partnerType;

					switch($partnerType)
					{
						case 1:
							$data['fonctionsList'] = array("PRÉSIDENT");
							$data['activitesList'] = array("ASSOCIATION", "CLUB", "GROUPEMENT", "FÉDÉRATION");
							$data['fjList'] = array("ASSOCIATION", "GROUPEMENT");

						break;

						case 0:
							$data['fonctionsList'] = array("GÉRANT");
							$data['activitesList'] = array("AGENT D'ASSURANCES", "COURTIER D'ASSURANCES");
							$data['fjList'] = array("NOM PERSONNEL", "SARL", "SA", "SAS");
						break;
					}

					if($isSuperAdmin)
					{
						// taux par défaut
						$data['taux0'] = $this->taux_model->getTaux('prime_assureur_principal');
						$data['taux1'] = $this->taux_model->getTaux('commission_parent_role_1');
						$data['taux2'] = $this->taux_model->getTaux('commission_parent_role_2');
						$data['taux3'] = $this->taux_model->getTaux('commission_parent_role_3');
					}

					if($_SERVER['REQUEST_METHOD'] == 'POST')
					{
						$this->form_validation->set_rules('contact_nom', 'Nom du contact', 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
						$this->form_validation->set_rules('contact_prenom', 'Prénom du contact', 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
						$this->form_validation->set_rules('contact_fonction', 'Fonction du contact', 'trim|min_length[1]|max_length[32]|xss_clean|strip_tags');
						
						$this->form_validation->set_rules('adresse1', 'Adresse', 'trim|required|min_length[1]|max_length[100]|xss_clean|strip_tags');
						$this->form_validation->set_rules('adresse2', 'Adresse suite', 'trim|min_length[1]|max_length[100]|xss_clean|strip_tags');
						$this->form_validation->set_rules('codepostal', 'Code postal', 'trim|required|min_length[1]|max_length[10]|xss_clean|strip_tags');
						$this->form_validation->set_rules('ville', 'Ville', 'trim|required|min_length[1]|max_length[50]|xss_clean|strip_tags');
						$this->form_validation->set_rules('partenaire_pays', 'Pays', 'trim|min_length[1]|max_length[100]|xss_clean|strip_tags');

						$this->form_validation->set_rules('telephone', 'Téléphone', 'trim|required|min_length[1]|max_length[20]|xss_clean|strip_tags');
						$this->form_validation->set_rules('fax', 'Mobile', 'trim|min_length[1]|max_length[20]|xss_clean|strip_tags');
						$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|max_length[100]|xss_clean|strip_tags');

						if($action != "check_partenaire")
						{
							$this->form_validation->set_rules('logo', 'Logo', 'trim|min_length[1]|max_length[255]|xss_clean|strip_tags');
							$this->form_validation->set_rules('url', 'Url', 'trim|min_length[1]|max_length[255]|xss_clean|strip_tags');
						}

						if($isSuperAdmin)
						{
							$this->form_validation->set_rules('partenaire_nom', 'Nom du partenaire', 'trim|required|min_length[1]|max_length[32]|xss_clean|strip_tags');
							$this->form_validation->set_rules('partenaire_activite', 'Activité du partenaire', 'trim|min_length[1]|max_length[32]|xss_clean|strip_tags');

							$this->form_validation->set_rules('partenaire_fj', 'Forme juridique', 'trim|min_length[1]|max_length[50]|xss_clean|strip_tags');

							if($this->input->post('type_partenaire') == 0)
							{
								//$this->form_validation->set_rules('partenaire_isprof', 'Professionnel', 'trim|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[1]');
								
								$this->form_validation->set_rules('partenaire_capital', 'Capital social', 'trim|required|numeric|min_length[1]|xss_clean|strip_tags');
								$this->form_validation->set_rules('partenaire_villerc', 'Ville RC', 'trim|min_length[1]|max_length[100]|xss_clean|strip_tags');
								$this->form_validation->set_rules('partenaire_nrc', 'N° RC', 'trim|required|min_length[1]|xss_clean|strip_tags');
							}

							$this->form_validation->set_rules('commission', 'Commission', 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[100]');
							if(isset($data['id_partenaire']) && $data['id_partenaire'] == "1"){} else {
								$this->form_validation->set_rules('commission_parent', 'Commission parrain', 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[100]');
							}
							$this->form_validation->set_rules('prime', 'Prime', 'trim|required|numeric|xss_clean|strip_tags|greater_than_equal_to[0]|less_than_equal_to[100]');

							if($this->input->post('role_partenaire') == 2) {
								if($action != "check_partenaire")
								{
									$this->form_validation->set_rules('sousdomaine', 'Sous domaine', 'trim|required|min_length[1]|max_length[150]|xss_clean|strip_tags');
								}
								$this->form_validation->set_rules('parent_partenaire', 'Rattaché à', 'trim|required|numeric|min_length[1]|max_length[10]|xss_clean|strip_tags');
							}

							if($action == "nouveau_partenaire")
							{	
								$this->form_validation->set_rules('login', 'Identifiant', 'required|min_length[4]|max_length[50]|xss_clean|strip_tags');
								$this->form_validation->set_rules('motdepasse', 'Mot de passe', 'required|min_length[5]|max_length[50]|xss_clean|strip_tags');
							}
						}

						if($action == "edit_partenaire" || $action == "mon_compte") {
							$this->form_validation->set_rules('motdepasse', 'Mot de passe', 'min_length[5]|max_length[50]|xss_clean|strip_tags|matches[repeat_motdepasse]');
							$this->form_validation->set_rules('repeat_motdepasse', 'Répéter mot de passe', 'min_length[5]|max_length[50]|xss_clean|strip_tags');
						}

						if(!$this->form_validation->run() == FALSE)
						{
							// insert
								$partenaire = array(
									"CONTACT_PARTENAIRE" => mb_strtoupper($this->input->post('contact_nom')),
									"CONTACT_PRENOM_PARTENAIRE" => mb_strtoupper($this->input->post('contact_prenom')),
									"FONCTION_PARTENAIRE" => mb_strtoupper($this->input->post('contact_fonction')),
									"ADRESSE1_PARTENAIRE" => mb_strtoupper($this->input->post('adresse1')),
									"ADRESSE2_PARTENAIRE" => mb_strtoupper($this->input->post('adresse2')),
									"CP_PARTENAIRE" => $this->input->post('codepostal'),
									"VILLE_PARTENAIRE" => mb_strtoupper($this->input->post('ville')),
									"PAYS_PARTENAIRE" => $this->input->post('pays'),
									"TEL_PARTENAIRE" => $this->input->post('telephone'),
									"FAX_PARTENAIRE" => $this->input->post('fax'),
									"COURRIEL_PARTENAIRE" => mb_strtolower($this->input->post('email')),
								);

							if($isSuperAdmin) {

								$partenaire["NOM_PARTENAIRE"] = mb_strtoupper($this->input->post('partenaire_nom'));
								$partenaire["ACTIVITE_PARTENAIRE"] = mb_strtoupper($this->input->post('partenaire_activite'));
								//$partenaire["ISPROF_PARTENAIRE"] = $this->input->post('partenaire_isprof');
								$partenaire["COM_PARTENAIRE"] = $this->input->post('commission');
								$partenaire["COM_AS_PARENT_PARTENAIRE"] = $this->input->post('commission_parent');
								$partenaire["PRIME_PARTENAIRE"] = $this->input->post('prime');

								if($this->input->post('type_partenaire') == 0)
								{
									$partenaire["ISPROF_PARTENAIRE"] = 1;
									$partenaire["FJ_PARTENAIRE"] = mb_strtoupper($this->input->post('partenaire_fj'));
									$partenaire["CAPITAL_PARTENAIRE"] = $this->input->post('partenaire_capital');
									$partenaire["NRC_PARTENAIRE"] = mb_strtoupper($this->input->post('partenaire_nrc'));
									$partenaire["VILLERC_PARTENAIRE"] = mb_strtoupper($this->input->post('partenaire_villerc'));
								}
								else
								{
									$partenaire["ISPROF_PARTENAIRE"] = 0;
								}

								if($this->input->post('role_partenaire') == 2) {
									if($action != "check_partenaire")
									{
										$partenaire["SOUSDOMAINE_PARTENAIRE"] = mb_strtolower($this->input->post('sousdomaine'));
									}
									$partenaire["PARENT_PARTENAIRE"] = $this->input->post('parent_partenaire');
								}

								if($action == "nouveau_partenaire" || $action == "check_partenaire")
								{
									$partenaire["ROLE_PARTENAIRE"] = $this->input->post('role_partenaire');
									$partenaire["ETAT_PARTENAIRE"] = 1;
									$partenaire["ACTIF_PARTENAIRE"] = 1;

									if($action == "nouveau_partenaire") {
										$partenaire["DATE_INSCRIPTION_PARTENAIRE"] = date("Y-m-d");
									}

									if($action == "check_partenaire") {
										$partenaire["ID_PARTENAIRE"] = $data['id_partenaire'];
									}

									if($action == "nouveau_partenaire")
									{
										$partenaire["LOGIN_PARTENAIRE"] = $this->input->post('login');
										$partenaire["PASSWORD_PARTENAIRE"] = $this->users_model->setPassword($this->input->post('motdepasse'));
										$partenaire["PASSWORD_CLEAR_PARTENAIRE"] = $this->input->post('motdepasse');
									}
								}
							}

							if($action == "edit_partenaire" || $action == "mon_compte")
							{
								$partenaire["ID_PARTENAIRE"] = $data['id_partenaire'];

								// edit
								if($this->input->post('motdepasse') != "") {
									$partenaire["PASSWORD_PARTENAIRE"] = $this->users_model->setPassword($this->input->post('motdepasse'));
								}
							}

							if($action != "check_partenaire" && $this->input->post('logo') != "" && $this->input->post('logo_new') == "1" && !$this->upload->do_upload('logo_upload'))
							{
								$data['requestSuccess'] = false;
								$data['requestMsg'] = $this->upload->display_errors();
							}
							else
							{
								if($action != "check_partenaire")
								{
									if($this->input->post('logo') != "") {
										if($this->input->post('logo_new') == "1")
										{
											$uploadData = array('upload_data' => $this->upload->data());
											$partenaire['LOGO_PARTENAIRE'] = $uploadData['upload_data']['file_name'];
										}
										else
										{
											$partenaire['LOGO_PARTENAIRE'] = $this->input->post('logo');
										}
									}
									$partenaire['URL_PARTENAIRE'] = $this->input->post('url');
									if(mb_stripos($partenaire['URL_PARTENAIRE'], "http") === false):
										$partenaire['URL_PARTENAIRE'] = "http://".$partenaire['URL_PARTENAIRE'];
									endif;
								}
								
								if($action == "edit_partenaire" || $action == "mon_compte" || $action == "check_partenaire") {
									$sql = $this->partenaires_model->update($partenaire);
								} else if($action == "nouveau_partenaire") {
									$sql = $this->partenaires_model->insert($partenaire);
								}


								// mail du partenaire parent
								$partenaireParent_email = getMainPartenaireEmail();
								if(isset($partenaire['PARENT_PARTENAIRE']) && $partenaire['PARENT_PARTENAIRE'] != "")
								{
									$partenaireParent = $this->partenaires_model->find($partenaire['PARENT_PARTENAIRE']);
									if($partenaireParent)
									{
										if($partenaireParent->COURRIEL_PARTENAIRE != "")
										{
											$partenaireParent_email = $partenaireParent->COURRIEL_PARTENAIRE;
										}
									}
								}

								if(substr($sql, 0, 1) == 1) {
									$requestMsg = '';
									$requestSuccessRedirect = 'section/partenaires';
									switch($action){
										case "nouveau_partenaire":
											$requestMsg = "Le compte du partenaire a été crée avec succès.";

											$send_email = $this->input->post('send-email');
											if($send_email == "1")
											{
												$requestMsg .= " Ses identifiants lui ont été adressés par courriel.";

												// mail auto validation
												$email = array(
															"type" => "new_partner_validated",
															"to" => $partenaire['COURRIEL_PARTENAIRE'],
															"bcc" => $partenaireParent_email,
																'nom' => $partenaire['CONTACT_PRENOM_PARTENAIRE'].' '.$partenaire['CONTACT_PARTENAIRE'],
																'partenaire-nom' => $partenaire['NOM_PARTENAIRE'],
																'partenaire-sousdomaine' => $partenaire['SOUSDOMAINE_PARTENAIRE'],
																'partenaire-login' => $partenaire['LOGIN_PARTENAIRE'],
																'partenaire-password' => $this->input->post('motdepasse')
														);
												$mail = sendNewMail($email);
											}
										break;

										case "edit_partenaire":
											$requestMsg = "Les modifications sur ce partenaire ont bien été prises en compte.";
										break;
										
										case "mon_compte":
											$requestSuccessRedirect = 'form/mon_compte';
											$requestMsg = "Les modifications sur votre compte ont bien été prises en compte.";
										break;

										case "check_partenaire":
											$requestMsg = "Le partenaire a bien été validé.";

											$requestMsg .= " La confirmation de son compte lui a été adressée par email.";
											// mail auto validation
											$email = array(
														"type" => "new_partner_validated",
														"to" => $partenaire['COURRIEL_PARTENAIRE'],
														"bcc" => $partenaireParent_email,
															'nom' => $partenaire['CONTACT_PRENOM_PARTENAIRE'].' '.$partenaire['CONTACT_PARTENAIRE'],
															'partenaire-nom' => $partenaire['NOM_PARTENAIRE'],
													);
											$mail = sendNewMail($email);
										break;
									}
									$data['requestSuccessRedirect'] = $requestSuccessRedirect;
									$data['requestMsg'] = $requestMsg;
									$data['requestSuccess'] = true;
								} else {
									$data['requestSuccess'] = false;
									$data['requestMsg'] = substr($sql, 1);
								}
							}
						}
					}
				}
			}

			$this->load->view('default/admin/index', $data);
		}
	}

	public function actions($action = '') {
		// TODO CHECK RIGHTS
		$res = -1;
		$array_actions = array("moderate-partner", "cancel-certificat");

		if(in_array($action, $array_actions)) {

			$datas = array();
			switch($action){
				case "cancel-certificat":
					$res = 0;

					$id = $this->input->post('id');
					$comment = $this->input->post('comment');

					$datas = array(
									'ANNULATION_SOUSCRIPTEUR' => 1,
									'ANNULATION_COMMENTAIRE_SOUSCRIPTEUR' => $comment,
									'ANNULATION_DATE_SOUSCRIPTEUR' => date("Y-m-d H:i:s")
								);
					$request = $this->souscripteurs_model->update($id, $datas);
					if($request){
						$res = 1;
					}

				break;

				case "moderate-partner":
					$id = $this->input->post('id');
					$state = $this->input->post('state');

					if($state == 1 || $state == 2) {
						$datas = array('ETAT_PARTENAIRE' => $state);
					} else if($state == 3) {
						$datas = array('ACTIF_PARTENAIRE' => '0');
					}
					$datas['ID_PARTENAIRE'] = $id;

					if(count($datas)>0){
						$request = $this->partenaires_model->update($datas);
						if($request){
							$res = 1;
						}
						else{
							$res = 2;
						}
					}
				break;
			}
		}
		echo $res;
	}

	/*public function delete($table = '', $id = '', $won = '', $player_id = '')
	{
		$sql = false;

		switch($table)
		{
			case "pl":
				$sql = $this->players_model->delete($id);
				break;

			case "pa":
				$sql = $this->playaction_model->delete($id, $won, $player_id);
				break;


			case "iw":
				$sql = $this->instantwin_model->reset($id);
				break;
		}

		// détruit session joueur
		$newdata = array('player' => null, 'fbprofile' => null,'hasIW' => null);
		$this->session->unset_userdata($newdata);
		$this->input->set_cookie(array('name' => 'defaultauchan_hasiw', 'value' => 0, 'expire' => 0));

		if($sql) { echo "1"; } else { echo "0"; }
	}*/

	public function logout()
	{
		$newdata = array('user' => null);
		$this->session->unset_userdata($newdata);
		$this->session->sess_destroy();
			redirect('intranet/');
	}

	
	public function export_data($section='')
	{
		$user = $this->session->userdata('user');
		if(!$user)
		{
			redirect('intranet/');
		}
		else
		{
			$isSuperAdmin = checkIfSuperAdmin($user);

			//ini_set('memory_limit', '4096M');
			set_time_limit(0);
			//error_reporting(E_ALL);

			if($section == 'partenaires')
			{
				$filename = 'partenaires';

				$columns = array(
								"ID",
								"SOUSDOMAINE",
								"NOM",
								"CONTACT",
								"FONCTION",
								"ACTIVITE",
								"ADRESSE1",
								"ADRESSE2",
								"CP",
								"VILLE",
								"TEL",
								"FAX",
								"COURRIEL"
							);
				if($isSuperAdmin) 
				{
					$columns[] = "COM";
					$columns[] = "COM PARRAIN";
					$columns[] = "PRIME";
					$columns[] = "DERNIERE CONNEXION";
				}
				$columns[] = "INSCRIPTION";
				
				$datas = array();
				$list = $this->partenaires_model->get_all();
				foreach($list as $item)
				{
					$c=0;
					$col = [];
						$col[$c] = $item->ID_PARTENAIRE; $c++;
						$col[$c] = $item->SOUSDOMAINE_PARTENAIRE; $c++;
						$col[$c] = $item->NOM_PARTENAIRE; $c++;
						$col[$c] = $item->CONTACT_PARTENAIRE; $c++;
						$col[$c] = $item->FONCTION_PARTENAIRE; $c++;
						$col[$c] = $item->ACTIVITE_PARTENAIRE; $c++;
						$col[$c] = $item->ADRESSE1_PARTENAIRE; $c++;
						$col[$c] = $item->ADRESSE2_PARTENAIRE; $c++;
						$col[$c] = $item->CP_PARTENAIRE; $c++;
						$col[$c] = $item->VILLE_PARTENAIRE; $c++;
						$col[$c] = $item->TEL_PARTENAIRE; $c++;
						$col[$c] = $item->FAX_PARTENAIRE; $c++;
						$col[$c] = $item->COURRIEL_PARTENAIRE; $c++;
						if($isSuperAdmin) {
							$col[$c] = $item->COM_PARTENAIRE; $c++;
							$col[$c] = $item->COM_AS_PARENT_PARTENAIRE; $c++;
							$col[$c] = $item->PRIME_PARTENAIRE; $c++;
							$col[$c] = $item->LAST_CONNEXION; $c++;
						}
						$col[$c] = $item->DATE_INSCRIPTION_PARTENAIRE; $c++;

					$data = [];
					foreach($col as $dataCol) {
						$data[] = $dataCol;
					}
					$datas[] = $data;
				}
			}
			else if($section == "ventes")
			{
				$filename = 'ventes';

				$lblPrime = "PRIME PAYEE";
				if(!$isSuperAdmin) 
				{
					$lblPrime = "MONTANT PRIME";
				}

				if(!$isSuperAdmin) 
				{
					$columns = array(
								"DATE",
								"APPORTEUR",
								"AFFILIE A",
								"SOUSCRIPTEUR",
								"NAISSANCE",
								"ADRESSE1",
								"ADRESSE2",
								"CP",
								"VILLE",
								"EMAIL",
								"TELEPHONE",
								"MOBILE",
								"CERTIFICAT",
								"DATE EFFET",
								"CAPITAL",
								"CATEGORIE",
								"PERIODE",
								"BENEFICIAIRE",
								$lblPrime
							);
				}
				else
				{
					$columns = array(
								"DATE",
								"APPORTEUR",
								"COM APPORTEUR",
								"AFFILIE A",
								"COM AFFILIE",
								"SOUSCRIPTEUR",
								"NAISSANCE",
								"ADRESSE1",
								"ADRESSE2",
								"CP",
								"VILLE",
								"EMAIL",
								"TELEPHONE",
								"MOBILE",
								"CERTIFICAT",
								"DATE EFFET",
								"CAPITAL",
								"CATEGORIE",
								"PERIODE",
								"BENEFICIAIRE",
								//$lblPrime, // OLD VALUE

								"TAUX IND ACC", // =VARIABLE U2
								"PRIME NETTE IND ACC",
								"COM IND ACC",
								"FDG IND ACC",
								"HT CIE IND ACC",
								"TAXES IND ACC",
								"TTC CIE IND ACC",
								"TTC CLIENT IND ACC",
								"DU CIE IND ACC",

								"PRIME NETTE ASSIST",
								"COM ASSIST",
								"FDG ASSIST",
								"HT CIE ASSIST",
								"TAXES ASSIST",
								"TTC CIE ASSIST", // =VARIABLE AI
								"TTC CLIENT ASSIST",
								"DUE CIE ASSIST",

								"TOTALE PRIME NETTE",
								"TOTAL COM",
								"TOTAL FDG",
								"TOTAL TTC CIE",
								"TOTAL TAXES",
								"TOTAL DU CIE"
							);
				}

				
				
				$datas = array();
				$list = $this->souscripteurs_model->get_all();

				foreach($list as $item)
				{
					if($item->ANNULATION_SOUSCRIPTEUR==0):
						if($isSuperAdmin)
						{
							$var_U2 = $item->TAUXINDACC_SOUSCRIPTEUR;
							if(intval($var_U2) == 0 || $var_U2 == "")
							{
								// old system, must search taux ind acc
								$duree = getDureeDbTarif($item->PERIODE_SOUSCRIPTEUR);
								$var_U2 = $this->tarifs_model->getTauxHt($item->CATEGORIE_SOUSCRIPTEUR, $duree);
							}
							
							$var_AI = $item->TAUXASSMONDE_SOUSCRIPTEUR;
							if($var_AI == "") { $var_AI = 0; }
							
							//PRIME NETTE IND ACC
							$var_V2 = $item->CAPITAL_SOUSCRIPTEUR*$var_U2/10000;
							//COM IND ACC
							$var_W2 = $var_V2*0.25;
							//FDG IND ACC
							$var_U2b = 0; if($var_U2!=0){$var_U2b=1;}
							$var_X2 = $var_V2 * 0.25;
							if($var_X2>0) { $var_X2 += 1; }
							//HT CIE IND ACC
							$var_Y2 = $var_V2+$var_W2;
							//TAXES IND ACC
							$var_Z2 = $var_Y2*0.09;
							//TTC CIE IND ACC
							$var_AA2 = $var_Y2*1.09;
							//TTC CLIENT IND ACC
							$var_AB2 = $var_AA2 + $var_X2;
							//DU CIE IND ACC
							$var_AC2 = $var_AA2 - $var_W2;

							$var_AG2 = 0;
							$var_AE2 = 0;
							$var_AH2 = 0;
							$var_AJ2 = 0;
							$var_AK2 = 0;
							$var_AD2 = 0;
							$var_AF2 = 0;

							if($var_AI!=0)
							{
								$var_AG2 = $var_AI/1.09;
								$var_AE2 = $var_AG2*0.5;
								$var_AH2 = $var_AI-$var_AG2;
								$var_AJ2 = $var_AI;
								$var_AD2 = $var_AG2/2;
								$var_AF2 = 0;
								$var_AK2 = $var_AI-$var_AF2-$var_AE2;
							}
							//TOTALE PRIME NETTE
							$var_AL2 = $var_AD2+$var_V2;
							//TOTAL COM
							$var_AM2 = $var_AE2+$var_W2;
							//TOTAL FDG
							$var_AN2 = $var_AF2+$var_X2;
							//TOTAL TTC CIE
							$var_AO2 = $var_AI+$var_AA2;
							//TOTAL TAXES
							$var_AP2 = $var_AH2+$var_Z2;
							//TOTAL DU CIE
							$var_AQ2 = $var_AC2-$var_AK2;

							// COM
							$val_com_partenaire = intval($item->COM_PARTENAIRE);
							$val_com_affilie = intval($item->COM_AFFILIE);

							//$val_com_partenaire = 20;
							//$val_com_affilie = 5;

							$var_C2 = ($var_V2+$var_AG2)*($val_com_partenaire/100);
							$var_E2 = ($var_V2+$var_AG2)*($val_com_affilie/100);
						}

						$c=0;
						$col = [];
							$col[$c] = $item->DATE_SOUSCRIPTION; $c++;
							$col[$c] = $item->NOM_PARTENAIRE; $c++;
							$col[$c] = number_format($var_C2, 2, '.', ' '); $c++;
							$col[$c] = $item->NOM_PARENT_PARTENAIRE; $c++;
							$col[$c] = number_format($var_E2, 2, '.', ' '); $c++;
							$col[$c] = $item->NOM_SOUSCRIPTEUR.' '.$item->PRENOM_SOUSCRIPTEUR; $c++;
							$col[$c] = date("d/m/Y", strtotime($item->BIRTHDAY_SOUSCRIPTEUR)); $c++;
							$col[$c] = $item->ADRESSE1_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->ADRESSE2_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->CP_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->VILLE_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->COURRIEL_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->TEL_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->GSM_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->CERTIFICAT_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->DATE_EFFET_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->CAPITAL_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->CATEGORIE_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->PERIODE_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->BENEFICIAIRE_SOUSCRIPTEUR; $c++;

							if(!$isSuperAdmin)
							{
								$col[$c] = $item->PART_ASSUREUR; $c++;
							}
							else
							{
								//TAUX IND ACC =VARIABLE U2
								$col[$c] = $var_U2; $c++;

								//PRIME NETTE IND ACC
								$col[$c] = number_format($var_V2, 2, '.', ' '); $c++;

								//COM IND ACC
								$col[$c] = number_format($var_W2, 2, '.', ' '); $c++;

								//FDG IND ACC
								$col[$c] = number_format($var_X2, 2, '.', ' '); $c++;

								//HT CIE IND ACC
								$col[$c] = number_format($var_Y2, 2, '.', ' '); $c++;

								//TAXES IND ACC
								$col[$c] = number_format($var_Z2, 2, '.', ' '); $c++;

								//TTC CIE IND ACC
								$col[$c] = number_format($var_AA2, 2, '.', ' '); $c++;

								//TTC CLIENT IND ACC
								$col[$c] = number_format($var_AB2, 2, '.', ' '); $c++;

								//DU CIE IND ACC
								$col[$c] = number_format($var_AC2, 2, '.', ' '); $c++;

								// START ASSISTANCE MONDE
									//PRIME NETTE ASSIST
									$col[$c] = number_format($var_AD2, 2, '.', ' '); $c++;

									//COM ASSIST
									$col[$c] = number_format($var_AE2, 2, '.', ' '); $c++;

									//FDG ASSIST
									$col[$c] = number_format($var_AF2, 2, '.', ' '); $c++;

									//HT CIE ASSIST
									$col[$c] = number_format($var_AG2, 2, '.', ' '); $c++;

									//TAXES ASSIST
									$col[$c] = number_format($var_AH2, 2, '.', ' '); $c++;

									//TTC CIE ASSIST =VARIABLE AI
									$col[$c] = number_format($var_AI, 2, '.', ' '); $c++;

									//TTC CLIENT ASSIST
									$col[$c] = number_format($var_AJ2, 2, '.', ' '); $c++;

									//DUE CIE ASSIST
									$col[$c] = number_format($var_AK2, 2, '.', ' '); $c++;
								// END ASSISTANCE MONDE

								//TOTALE PRIME NETTE
								$col[$c] = number_format($var_AL2, 2, '.', ' '); $c++;

								//TOTAL COM
								$col[$c] = number_format($var_AM2, 2, '.', ' '); $c++;

								//TOTAL FDG
								$col[$c] = number_format($var_AN2, 2, '.', ' '); $c++;

								//TOTAL TTC CIE
								$col[$c] = number_format($var_AO2, 2, '.', ' '); $c++;

								//TOTAL TAXES
								$col[$c] = number_format($var_AP2, 2, '.', ' '); $c++;

								//TOTAL DU CIE
								$col[$c] = number_format($var_AQ2, 2, '.', ' '); $c++;
							}
						
						$data = [];
						foreach($col as $dataCol) {
							$data[] = $dataCol;
						}
						$datas[] = $data;
					endif;
				}
			}
			else if($section == "commissions")
			{
				$filename = 'commissions';

				if($isSuperAdmin)
				{
					$columns = array(
								"DATE",
								"CERTIFICAT",
								"APPORTEUR",
								"AFFILIE A",
								"TRANSACTION",
								"PRIME PAYEE",
								"N",
								"N+1",
								"N+2"
							);
				}
				else
				{
					$columns = array(
								"DATE",
								"CERTIFICAT",
								"APPORTEUR",
								"AFFILIE A",
								"N° CONTRAT",
								"MONTANT PRIME",
								"%",
								"COMMISSION"
							);
				}
				
				$datas = array();
				$list = $this->souscripteurs_model->get_all();
				foreach($list as $item)
				{
					if($item->ANNULATION_SOUSCRIPTEUR==0):

						$c=0;
						$col = [];
							$col[$c] = $item->DATE_SOUSCRIPTION; $c++;
							$col[$c] = $item->CERTIFICAT_SOUSCRIPTEUR; $c++;
							$col[$c] = $item->NOM_PARTENAIRE; $c++;
							$col[$c] = $item->NOM_PARENT_PARTENAIRE; $c++;
							$col[$c] = $item->TRANSACTION_ID; $c++;

							if($isSuperAdmin)
							{
								$col[$c] = $item->PRIME_SOUSCRIPTEUR; $c++;

								if($item->VERSION_CALCUL == 0) {
									$n = $item->PART_ID1;
									$n1 = $item->PART_ORIGINE;
									$n2 = $item->PART_PARTENAIRE;
								} else if($item->VERSION_CALCUL == 1) {
									$n = $item->PART_ASSUREUR;
									$n1 = $item->PART_APPORTEUR;
									$n2 = $item->PART_PARENT;
								}
								$col[$c] = $n; $c++;
								$col[$c] = $n1; $c++;
								$col[$c] = $n2; $c++;
							}
							else
							{
								if($item->VERSION_CALCUL == 0)
								{
									$col[$c] = $row->PART_ORIGINE; $c++;
									$col[$c] = "";
									$col[$c] = $row->PART_PARTENAIRE; $c++;
								}
								else if($item->VERSION_CALCUL == 1)
								{
									$col[$c] = $item->PART_ASSUREUR; $c++;
									$isApporteur = false; 
									if($user['ID_PARTENAIRE'] == $item->ID_PARTENAIRE) {
										$isApporteur = true;
									}
									$col[$c] = getPourcentageApporteur($isApporteur, $item->CALCUL_ENCAISSEMENT).'%'; $c++;
									if($isApporteur) {
										$col[$c] = $item->PART_APPORTEUR; $c++;
									} else {
										$col[$c] = $item->PART_PARENT; $c++;
									}
								}
							}
						
						$data = [];
						foreach($col as $dataCol) {
							$data[] = $dataCol;
						}
						$datas[] = $data;

					endif;
				}
			}
			/*else if($section == 'iw')
			{
				$filename = 'iwlist';

				$columns = $this->instantwin_model->get_columns();
				$datas = $this->instantwin_model->get_all(array(),0,-1);
			}*/

			if(count($datas)>0)
			{
				$this->load->library('excel');
				$this->excel->setActiveSheetIndex(0); //activate worksheet number 1
				$this->excel->getActiveSheet()->setTitle('NoLimite Export - '.date("dmy")); //name the worksheet

				exportExcel('nolimite_'.$filename.'_'.date('Y-m-d_H:i:s'), $this->excel, $columns, $datas);
			}
		}
	}
}
