<?php
Class assistancemonde_model extends CI_Model
{
	var $table_assurancemonde = "assistancemonde";

	function __construct(){
		parent::__construct();
	}

	public function get_columns(){
		$fields = $this->db->list_fields($this->table_assurancemonde);
		return $fields;
	}

	public function nb() {
		$count = $this->db->count_all_results($this->table_assurancemonde);
        return $count;
	}

	public function get_all(){
		$this->db->from($this->table_assurancemonde);
		$this->db->order_by('id','DESC');
		$datas = $this->db->get()->result();
		return $datas;
	}

	public function get_prime_from_cat($category){
		$this->db->select('id, duree_rang, dure, ttc, prime, comm');
		$this->db->from($this->table_assurancemonde);
		$this->db->where('cat = "'.$category.'"', NULL, FALSE);
		$this->db->order_by('duree_rang','ASC');
		$datas = $this->db->get()->result();

		return $datas;
	}

	public function getTarifFromCatDuree($category, $duree) {
		$this->db->select('ttc');
		$this->db->from($this->table_assurancemonde);
		$this->db->where('cat = "'.$category.'"', NULL, FALSE);
		$this->db->where('duree_rang = "'.$duree.'"', NULL, FALSE);

		$query = $this->db->get();

		if ($query->num_rows() > 0)
		{
			$row = $query->row(); 
   			return $row->ttc;
		}

		return null;
	}

	public function getTarifTTC($category, $duree) {
		$this->db->select('ttc');
		$this->db->from($this->table_assurancemonde);
		$this->db->where('cat = "'.$category.'"', NULL, FALSE);
		$this->db->where('dure = "'.$duree.'"', NULL, FALSE);

		$query = $this->db->get();

		if ($query->num_rows() > 0)
		{
			$row = $query->row(); 
   			return $row->ttc;
		}

		return null;
	}

}