<?php
Class partenaires_model extends CI_Model
{
	var $table_partenaires = "partenaires";

	function __construct(){
		parent::__construct();
	}

	public function get_columns(){
		$fields = $this->db->list_fields($this->table_partenaires);
		return $fields;
	}

	public function nb() {
		$datas = null;

		$user = $this->session->userdata('user');
		if($user)
		{
			$isSuperAdmin = checkIfSuperAdmin($user);

			// get all partners affiliated to connected user
			$ID_PARTENAIRE = $user['ID_PARTENAIRE'];

			$this->db->from($this->table_partenaires);
			$this->db->where('NOM_PARTENAIRE is NOT NULL', NULL, FALSE); // nom partenaire renseigné
			$this->db->where('NOM_PARTENAIRE <> ""', NULL, FALSE); // nom partenaire renseigné
			$this->db->where('ETAT_PARTENAIRE <> 2', NULL, FALSE); // compte pas refusé
			$this->db->where('ACTIF_PARTENAIRE = 1', NULL, FALSE); // compte actif
			$this->db->where('ID_PARTENAIRE <> '.$ID_PARTENAIRE.'', NULL, FALSE); // exclude partner
			if(!$isSuperAdmin)
			{
				$this->db->where('PARENT_PARTENAIRE = '.$ID_PARTENAIRE, NULL, FALSE); // comptes affiliés
			}
			$this->db->order_by('id_partenaire','ASC');

	        $datas = $this->db->count_all_results();
		}

		return $datas;
	}

	public function nbNewPartners() {
		$datas = null;

		$user = $this->session->userdata('user');
		if($user)
		{
			$isSuperAdmin = checkIfSuperAdmin($user);

			// get all partners affiliated to connected user
			$ID_PARTENAIRE = $user['ID_PARTENAIRE'];

			$this->db->from($this->table_partenaires);
			$this->db->where('NOM_PARTENAIRE is NOT NULL', NULL, FALSE); // nom partenaire renseigné
			$this->db->where('NOM_PARTENAIRE <> ""', NULL, FALSE); // nom partenaire renseigné
			$this->db->where('ETAT_PARTENAIRE = 0', NULL, FALSE); // compte pas refusé
			$this->db->where('ACTIF_PARTENAIRE = 1', NULL, FALSE); // compte actif
			$this->db->where('ID_PARTENAIRE <> '.$ID_PARTENAIRE.'', NULL, FALSE); // exclude partner
			if(!$isSuperAdmin)
			{
				$this->db->where('PARENT_PARTENAIRE = '.$ID_PARTENAIRE, NULL, FALSE); // comptes affiliés
			}
			$this->db->order_by('id_partenaire','ASC');

	        $datas = $this->db->count_all_results();
	    }

	    return $datas;
	}

	public function getListPartenaires() {
		$datas = null;

		$this->db->select('ID_PARTENAIRE, UCASE(NOM_PARTENAIRE) as NOM_PARTENAIRE');
		$this->db->from($this->table_partenaires);
		$this->db->where('NOM_PARTENAIRE is NOT NULL', NULL, FALSE);
		$this->db->where('NOM_PARTENAIRE <> ""', NULL, FALSE);
		$this->db->order_by('NOM_PARTENAIRE','ASC');
		$this->db->group_by('NOM_PARTENAIRE');
		
		$datas = $this->db->get()->result();

		return $datas;
	}

	public function getListActivitesPartenaires() {
		$datas = null;

		$this->db->select('UCASE(ACTIVITE_PARTENAIRE) as ACTIVITE_PARTENAIRE');
		$this->db->from($this->table_partenaires);
		$this->db->where('ACTIVITE_PARTENAIRE is NOT NULL', NULL, FALSE);
		$this->db->where('ACTIVITE_PARTENAIRE <> ""', NULL, FALSE);
		$this->db->order_by('ACTIVITE_PARTENAIRE','ASC');
		$this->db->group_by('ACTIVITE_PARTENAIRE');
		
		$datas = $this->db->get()->result();

		return $datas;
	}

	public function getListFonctionsPartenaires() {
		$datas = null;

		$this->db->select('UCASE(FONCTION_PARTENAIRE) as FONCTION_PARTENAIRE');
		$this->db->from($this->table_partenaires);
		$this->db->where('FONCTION_PARTENAIRE is NOT NULL', NULL, FALSE);
		$this->db->where('FONCTION_PARTENAIRE <> ""', NULL, FALSE);
		$this->db->order_by('FONCTION_PARTENAIRE','ASC');
		$this->db->group_by('FONCTION_PARTENAIRE');
		
		$datas = $this->db->get()->result();

		return $datas;
	}

	public function get_all(){
		$datas = null;

		$user = $this->session->userdata('user');
		if($user)
		{
			$isSuperAdmin = checkIfSuperAdmin($user);

			// get all partners affiliated to connected user
			$ID_PARTENAIRE = $user['ID_PARTENAIRE'];

			$this->db->select('p1.ID_PARTENAIRE,
							p1.TYPE_PARTENAIRE,
							p1.NOM_PARTENAIRE,
							p1.CONTACT_PARTENAIRE,
							p1.CONTACT_PRENOM_PARTENAIRE,
							CONCAT(p1.CONTACT_PARTENAIRE, " ", p1.CONTACT_PRENOM_PARTENAIRE) as CONTACT_FULLNAME_PARTENAIRE,
							p1.ACTIVITE_PARTENAIRE,
							p1.CP_PARTENAIRE,
							p1.VILLE_PARTENAIRE,
							p1.COM_PARTENAIRE,
							p1.COM_AS_PARENT_PARTENAIRE,
							p1.PRIME_PARTENAIRE,
							p1.DATE_INSCRIPTION_PARTENAIRE,
							p1.FONCTION_PARTENAIRE,
							p1.ADRESSE1_PARTENAIRE,
							p1.ADRESSE2_PARTENAIRE,
							p1.TEL_PARTENAIRE,
							p1.FAX_PARTENAIRE,
							p1.ETAT_PARTENAIRE,
							p1.COURRIEL_PARTENAIRE,
							p1.LOGO_PARTENAIRE,
							p1.ROLE_PARTENAIRE,
							p1.PAYS_PARTENAIRE,
							p1.LAST_CONNEXION,
							p1.SOUSDOMAINE_PARTENAIRE,
							p2.ADRESSE1_PARTENAIRE as ADRESSE1_PARENT_PARTENAIRE,
							p2.ADRESSE2_PARTENAIRE as ADRESSE2_PARENT_PARTENAIRE,
							p2.PAYS_PARTENAIRE as PAYS_PARENT_PARTENAIRE,
							p2.CP_PARTENAIRE as CP_PARENT_PARTENAIRE,
							p2.VILLE_PARTENAIRE as VILLE_PARENT_PARTENAIRE,
							p2.TEL_PARTENAIRE as TEL_PARENT_PARTENAIRE,
							p2.NOM_PARTENAIRE as NOM_PARENT_PARTENAIRE,
							p2.ID_PARTENAIRE as ID_PARENT_PARTENAIRE,
							p2.COURRIEL_PARTENAIRE as COURRIEL_PARENT_PARTENAIRE');
			$this->db->from($this->table_partenaires.' as p1');
			$this->db->join($this->table_partenaires.' as p2', 'p1.PARENT_PARTENAIRE = p2.ID_PARTENAIRE', 'left outer');
			$this->db->where('p1.ID_PARTENAIRE <> '.$ID_PARTENAIRE.'', NULL, FALSE); // exclude partner
			$this->db->where('p1.NOM_PARTENAIRE is NOT NULL', NULL, FALSE);
			$this->db->where('p1.NOM_PARTENAIRE <> ""', NULL, FALSE);
			$this->db->where('p1.ETAT_PARTENAIRE <> 2', NULL, FALSE);
			$this->db->where('p1.ACTIF_PARTENAIRE = 1', NULL, FALSE);
			if(!$isSuperAdmin)
			{
				$this->db->where('p1.PARENT_PARTENAIRE = '.$ID_PARTENAIRE, NULL, FALSE); // comptes affiliés
			}
			$this->db->order_by('p1.ID_PARTENAIRE','ASC');
			
			$datas = $this->db->get()->result();
		}

		return $datas;

	}

	public function delete($id)
	{
		$result = $this->db->delete($this->table_partenaires, array("id" => $id));
		return $result;
	}

	function partenaire_exists($partenaire, $action = '')
	{
		$count = 0;

		// vérifie doublons sur NOM_PARTENAIRE / COURRIEL_PARTENAIRE / SOUSDOMAINE_PARTENAIRES
		$error = "";

		$this->db->select('ID_PARTENAIRE');
		$this->db->from($this->table_partenaires);
		$this->db->where("NOM_PARTENAIRE", $partenaire['NOM_PARTENAIRE']);
		if($action == "update") {
			$this->db->where('ID_PARTENAIRE <> '.$partenaire['ID_PARTENAIRE'], NULL, FALSE);
		}
		$result = $this->db->count_all_results();

		if($result > $count) {
			// DOUBLON NOM
			$error = "Ce nom de partenaire est déjà utilisée";
		} else {
			$this->db->select('ID_PARTENAIRE');
			$this->db->from($this->table_partenaires);
			$this->db->where("COURRIEL_PARTENAIRE", $partenaire['COURRIEL_PARTENAIRE']);
			if($action == "update") {
				$this->db->where('ID_PARTENAIRE <> '.$partenaire['ID_PARTENAIRE'], NULL, FALSE);
			}
			$result = $this->db->count_all_results();

			if($result > $count) {
				// DOUBLON MAIL
				$error = "Cette adresse email est déjà utilisée";
			} else if(isset($partenaire['SOUSDOMAINE_PARTENAIRE']) && $partenaire['SOUSDOMAINE_PARTENAIRE'] != ''){
				$this->db->select('ID_PARTENAIRE');
				$this->db->from($this->table_partenaires);
				$this->db->where("SOUSDOMAINE_PARTENAIRE", $partenaire['SOUSDOMAINE_PARTENAIRE']);
				if($action == "update") {
					$this->db->where('ID_PARTENAIRE <> '.$partenaire['ID_PARTENAIRE'], NULL, FALSE);
				}
				$result = $this->db->count_all_results();

				if($result > $count) {
					// DOUBLON SOUSDOMAINE
					$error = "Ce sous-domaine est déjà utilisé";
				} else if(isset($partenaire['LOGIN_PARTENAIRE']) && $partenaire['LOGIN_PARTENAIRE'] != '') {
					$this->db->select('ID_PARTENAIRE');
					$this->db->from($this->table_partenaires);
					$this->db->where("LOGIN_PARTENAIRE", $partenaire['LOGIN_PARTENAIRE']);
					if($action == "update") {
						$this->db->where('ID_PARTENAIRE <> '.$partenaire['ID_PARTENAIRE'], NULL, FALSE);
					}
					$result = $this->db->count_all_results();

					if($result > $count) {
						// DOUBLON LOGIN
						$error = "Ce login est déjà utilisé";
					}
				}
			}
		}

		return $error;
	}

	public function findWithSubdomain($subdomain)
	{
		$this->db->select('ID_PARTENAIRE');
		$this->db->from($this->table_partenaires);
		$this->db->where('SOUSDOMAINE_PARTENAIRE = "'.$subdomain.'"', NULL, FALSE);
		$this->db->where('ID_PARTENAIRE <> 1', NULL, FALSE);
		$this->db->where('SOUSDOMAINE_PARTENAIRE IS NOT NULL', NULL, FALSE);
		$this->db->where('SOUSDOMAINE_PARTENAIRE <> ""', NULL, FALSE);
		$this->db->where('ETAT_PARTENAIRE = 1', NULL, FALSE); // COMPTE VALIDE
		$this->db->where('ACTIF_PARTENAIRE = 1', NULL, FALSE); // ACTIF
		
		$query = $this->db->get();

		if ($query->num_rows() > 0)
		{
			$row = $query->row(); 
   			return $row->ID_PARTENAIRE;
		}

		return null;
	}

	public function find($id)
	{
		$this->db->from($this->table_partenaires);
		$this->db->where('ID_PARTENAIRE = '.$id, NULL, FALSE);
		$query = $this->db->get();

		if ($query->num_rows() > 0)
		{
			$row = $query->row(); 
   			return $row;
		}

		return null;
	}

	public function update($partenaire)
	{
		if($partenaire['ID_PARTENAIRE'] > 0){

			// check if partner exists
			if(!$this->find($partenaire['ID_PARTENAIRE'])) {
				$request = "0partenaire not found";
			} else {
				$search = "";
				if(isset($partenaire['NOM_PARTENAIRE'])) {
					$search = $this->partenaire_exists($partenaire, 'update');
				}
				
				if($search != "") 
				{
					// existe doublon
					$request = "0".$search;
				}
				else
				{
					$where = array('ID_PARTENAIRE' => $partenaire['ID_PARTENAIRE']);
					$result = $this->db->update($this->table_partenaires, $partenaire, $where);
					if($result) {
						$request = "1";
					} else {
						$request = "0sql error";
					}
				}
			}
		} else {
			$request = "0partenaire not found";
		}

		return $request;
	}

	public function insert($partenaire)
	{
		$sql = false;
		$request = "0";

		// vérifie si aucun doublon
		$search = $this->partenaire_exists($partenaire, '');
		if($search != "")
		{
			$request = "0".$search;
		}
		else
		{
			// ajout nouveau joueur
			$sql = $this->save($partenaire);
			if($sql){
				$request = $sql;
			} else {
				$request = "0Erreur lors de l'insertion en base de données";
			}
			
		}

		return $request;
	}

	public function save($datas)
	{
		$result = $this->db->insert($this->table_partenaires, $datas);
		if($result)
		{
			$insert_id = $this->db->insert_id();

			return $insert_id;
		}
		else
		{
			return FALSE;
		}
	}

	public function updateTaux($parentRole, $taux)
	{
		$request = false;

		if(($parentRole == 1 || $parentRole == 2) && $taux >= 0 && $taux <= 100)
		{
			$val = (float)$taux;
			$data = array('COM_PARTENAIRE' => $val);

			// EVOLUTION : can improve in future if more super admin (role=1)
			// for ex: ID IN(ids) / (SELECT ID_PARTENAIRE FROM '.$this->db->dbprefix($this->table_partenaires).' WHERE ROLE_PARTENAIRE = '.$parentRole.')
			if($parentRole == 1)
			{
				$where = 'PARENT_PARTENAIRE = 1';
			} 
			else if($parentRole == 2) 
			{
				$where = 'PARENT_PARTENAIRE > 1';
			}

			$sql = 'UPDATE '.$this->db->dbprefix($this->table_partenaires).' SET COM_PARTENAIRE = '.$val.' WHERE '.$where;
			$request = $this->db->query($sql);
		}

		return $request;
	}

}