<?php
Class tarifs_model extends CI_Model
{
	var $table_tarifs = "tarifs";
	var $table_tarifs_v2 = "tarifs_v2";

	function __construct(){
		parent::__construct();
	}

	public function get_columns(){
		$fields = $this->db->list_fields($this->table_tarifs);
		return $fields;
	}

	public function nb() {
		$count = $this->db->count_all_results($this->table_tarifs);
        return $count;
	}

	public function get_tarifs_from_cat_v2($category){
		$this->db->select('id, label, duree, duree_rang, taux_ttc, ttc, ht, comm, ttc_cie, fdg, taxe_opra, ttc_client');
		$this->db->from($this->table_tarifs_v2);
		$this->db->where('categorie = "'.$category.'"', NULL, FALSE);
		$this->db->order_by('duree_rang','ASC');
		$datas = $this->db->get()->result();
		return $datas;
	}

	public function get_tarifs_from_cat($category){
		$this->db->select('id, dure, taux, taux_ass, duree_rang');
		$this->db->from($this->table_tarifs);
		$this->db->where('categorie = "'.$category.'"', NULL, FALSE);
		$this->db->order_by('taux','ASC');
		$datas = $this->db->get()->result();
		return $datas;
	}

	public function getTauxHt($category = null, $duree = null, $assMonde = 0, $annVoyage = 0) {

		if( (!is_null($assMonde) && $assMonde == 1) && (is_null($annVoyage) || $annVoyage == 0) ):
			$field = 'taux';
		else:
			$field = 'taux';
			//$field = 'taux_ass';
		endif;

		if(!is_null($category) && !is_null($duree)):
			$category = strtoupper($category);
			$this->db->select($field);
			$this->db->from($this->table_tarifs);
			if($category == "A" || $category == "B"):
				$this->db->where('categorie = "'.$category.'"', NULL, FALSE);
			endif;
			$this->db->where('dure = "'.$duree.'"', NULL, FALSE);

			$query = $this->db->get();

			if ($query->num_rows() > 0)
			{
				$row = $query->row(); 
	   			return $row->taux;
			}
		endif;

		return null;
	}



}