<?php
/*
	Template Name: About Author
*/

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$author_sub_title	=	get_theme_mod( 'author_sub_title' );
$author_interested_in	=	get_theme_mod( 'author_interested_in' );
$author_email_id	=	get_theme_mod( 'author_email_id' );
$author_phone		=	get_theme_mod( 'author_phone' );
$author_social_links_items	=	get_theme_mod( 'author_social_links_items' );
$author_expertise	=	get_theme_mod( 'author_expertise' );
?>
<?php get_header(); ?>

<section class="page-author">
	<div class="container">
		<div class="row">
			<div class="col-md-5">
				<?php if ( has_post_thumbnail() ) : ?>
					<div class="author-image">
						<?php the_post_thumbnail('full'); ?>
					</div>
				<?php endif; ?>
			</div>
	
			<div class="col-md-6 offset-md-1">
				<?php while ( have_posts() ) : the_post(); ?>
				<div class="author-about">
					<div class="author-meta">
						<h1><?php the_title(); ?></h1>
						<?php if(!empty($author_sub_title)){ ?>
						<p><?php echo sanitize_text_field($author_sub_title); ?></p>
						<?php } ?>
					</div>
					
					<div class="author-entry">
						<?php the_content(); ?>
					</div>
					
					<?php if(!empty($author_interested_in)){
						$author_interested_in = explode(",",$author_interested_in);
					?>
						<div class="author-interested">
							<strong><?php esc_html_e( 'Interested In :', 'blogman' ); ?> </strong>
							<?php foreach($author_interested_in as $ai){ ?>
								<span><?php echo esc_html($ai); ?></span>
							<?php } ?>
						</div>
					<?php }	?>
					
					<?php if(!empty($author_email_id)){ ?>
					<div class="author-info-extra">
						<p><strong><?php esc_html_e( 'Email :', 'blogman' ); ?> </strong> <?php echo sanitize_text_field($author_email_id); ?></p>
					</div>
					<?php } ?>
					
					<?php if(!empty($author_phone)){ ?>
					<div class="author-info-extra">
						<p><strong><?php esc_html_e( 'Phone :', 'blogman' ); ?> </strong> <?php echo sanitize_text_field($author_phone); ?></p>
					</div>
					<?php } ?>
					
					<?php 
						if( is_array( $author_social_links_items ) && count( $author_social_links_items ) > 0 ) {
					?>
					<div class="author-info-extra">
						<strong><?php esc_html_e( 'Join me on my social club :', 'blogman' ); ?> </strong>
					<?php
							foreach($author_social_links_items as $sitem) {
								echo '<a target="_blank" href="'.esc_url( $sitem['author_social_link'] ).'"><i class="fab fa-'.esc_attr( $sitem['author_social_icon'] ).'"></i></a>';
							}
						?>
					</div>
					<?php
						}
					?>
					
					<?php if(!empty($author_expertise)){
						$author_expertise = explode(",",$author_expertise);
					?>
						<div class="author-expertise">
							<strong><?php esc_html_e( 'Highlights of Expertise :', 'blogman' ); ?> </strong>
							<ul>
							<?php foreach($author_expertise as $ae){ ?>
								<li><?php echo esc_html($ae); ?></li>
							<?php } ?>
							</ul>
						</div>
					<?php }	?>
				</div>
				<?php endwhile; ?>
			</div>
		</div>
	</div>
</section>
<?php get_footer(); ?>