<?php
/**
 * The template for displaying archive pages
 *
 * @package Blogman
 * @since 	1.0
 */

 // Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$archive_page_layout	=	get_theme_mod( 'archive_page_layout', 'no-sidebar' );
if($archive_page_layout == 'no-sidebar') {
	$column = 'col-md-12';
}
else{
	$column = 'col-md-9';
}
?>
<?php get_header(); ?>
<section class="page-wrapper">
	<div class="container">
	<?php if ( true == get_theme_mod( 'show_archive_page_title', true ) ) : ?>
		<div class="row">
			<div class="col-md-12">
				<div class="page-title">
					<h1><?php the_archive_title(  ); ?></h1>
				</div>
			</div>
		</div>
	<?php endif; ?>
		
		<div class="row">
			<div class="<?php echo esc_attr( $column ); ?>">
				
			<?php
				the_archive_description( '<div class="taxonomy-description">', '</div>' );
			?>
			
			<?php /* The loop */
				if ( have_posts() ) :
					while ( have_posts() ) : the_post(); ?>
						<?php get_template_part( 'content' ); ?>
					<?php endwhile; ?>
					
					<div class="navigation">
						<?php 
							posts_nav_link(' ','<div class="nav-prev-btn"><i class="fas fa-angle-left"></i><i class="fas fa-angle-left"></i><i class="fas fa-angle-left"></i></div>','<div class="nav-next-btn"><i class="fas fa-angle-right"></i><i class="fas fa-angle-right"></i><i class="fas fa-angle-right"></i></div>'); ?>
					</div>
				<?php else: ?>
					<p><?php esc_html_e('No posts were found.', 'blogman' ); ?></p>
			<?php endif; ?>
			</div>
			<?php 
				if($archive_page_layout == 'with-sidebar'):
					get_sidebar();
				endif;
			?>
		</div>
	</div>
</section>
<?php get_footer(); ?>