<?php
/**
 * Template loop for post
 */
 
 // Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('post-list'); ?>>
	<div class="post-header">
		<div class="post-meta-date">
			<p><?php esc_html_e( 'Published on', 'blogman' ); ?> <span><?php echo get_the_date('d'); ?></span> <?php echo get_the_date('F'); ?></p>
		</div>
		
		<div class="post-title">
		<?php if ( has_post_format( 'link' ) ) : ?>
			<?php 
				$link_content = get_post_meta( $post->ID, '_format_link_url', true );
				the_title( '<h2><a href="' . esc_url( $link_content ) . '" rel="bookmark">', '</a></h2>' ); 
			?>
		<?php else: ?>
			<?php the_title( '<h2><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>
		<?php endif; ?>
			<div class="post-meta">
				<span>
				<?php
					if ( has_post_format( 'link' ) ){
						echo '<i class="fas fa-link"></i>';
					} 
					elseif ( has_post_format( 'video' ) ){
						echo '<i class="fas fa-video"></i>';
					}
					elseif ( has_post_format( 'audio' ) ){
						echo '<i class="fas fa-music"></i>';
					}
				?><?php esc_html_e( 'By', 'blogman' ); ?>
				</span>
				<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php the_author(); ?></a>
				<?php if(has_category()): ?><span><?php esc_html_e( ', In ', 'blogman' ); ?></span>
				<?php the_category(', '); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<?php get_template_part( 'templates/loop', get_post_format() ); ?>
	<div class="post-body">
		<?php if ( true == get_theme_mod( 'show_full_post_content', false ) ) : ?>
			<?php the_content(); ?>
		<?php else : ?>
			<?php the_excerpt(); ?>
		<?php endif; ?>
	</div>
	
	<?php if ( true == get_theme_mod( 'show_tag_on_archive_page', false ) ) : ?>
	<?php if( has_tag() ) : ?>
		<div class="post-tags">
			<?php the_tags('# ',', '); ?>
		</div>
	<?php endif; ?>
	<?php endif; ?>
	
	<?php if ( true == get_theme_mod( 'show_social_share_on_archive_page', false ) ) : ?>
		<?php blogman_social_share_links(); ?>
	<?php endif; ?>

	<div class="post-footer">
		<a href="<?php the_permalink(); ?>" class="btn-read-more"><?php esc_html_e( 'Read More', 'blogman' ); ?> <i class="fas fa-arrow-right"></i></a>
	</div>
</article>