<?php if ( is_active_sidebar( 'footer-widget' ) ): ?>
	<div class="footer-widget-area">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="footer-widget-box">
						<?php dynamic_sidebar( 'footer-widget' ); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>
<?php if ( is_active_sidebar( 'footer-instagram' ) ): ?>
	<div class="instagram-feeds">
		<?php dynamic_sidebar( 'footer-instagram' ); ?>
	</div>
<?php endif; ?>
<!-- Footer section starts -->
	<footer class="page-footer">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="footer-logo">
					<?php	
						$footer_logo = get_theme_mod( 'footer_logo' );
						if ( !empty($footer_logo) ) {
							?>
							<img src="<?php echo esc_url($footer_logo); ?>" alt="<?php bloginfo( 'name' ); ?>">
							<?php 
						}
					?>
						<?php if( get_theme_mod('footer_title') ) { ?>
							<h2><?php echo sanitize_text_field( get_theme_mod( 'footer_title' ) ); ?></h2>
						<?php } else { ?>
							<h2><?php echo esc_html( get_bloginfo ( 'name' ) ); ?></h2>
						<?php } ?>
					</div>
					
					<div class="footer-copyright">
						<?php if( get_theme_mod('footer_copyright_text') ) { ?>
							<p><?php echo wp_kses_post( get_theme_mod('footer_copyright_text') ); ?></p>
						<?php } else { ?>
							<p><?php esc_html_e( 'Created by Awaiken, Powered by WordPress. All rights reserved', 'blogman' ); ?></p>
						<?php } ?>
					</div>
					
					<div class="footer-social">
						<?php echo blogman_social_links(); ?>	
					</div>
				</div>
			</div>
		</div>
	</footer>
	<!-- Footer section ends -->
<?php wp_footer(); ?>
</body>
</html>