<?php
/**
 * This is header template of our theme
 *
 * @package    Blogman
 * @since      1.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php if ( true == get_theme_mod( 'show_preloader', false ) ) : ?>
	<div class="preloader">
		<div class="lds-roller">
			<span></span>
			<span></span>
			<span></span>
			<span></span>
			<span></span>
			<span></span>
			<span></span>
			<span></span>
		</div>
	</div>
<?php endif; ?>
	
	<!-- Header Section Starts-->
	<?php $sticky_class = '';
	if ( true == get_theme_mod( 'sticky_header', false ) ) {
			$sticky_class = 'navbar-sticky';
		} 
	?>
	<header>
		<nav class="navbar navbar-default <?php echo esc_attr( $sticky_class ); ?> bootsnav">
			<div class="container">
				<!-- Logo start -->
				<div class="navbar-header">
					<a class="navbar-brand" href="<?php echo esc_url( home_url('/') ); ?>">
					<?php	
						if ( has_custom_logo( $blog_id = 0 ) ) :
							$custom_logo_id = get_theme_mod( 'custom_logo' );
							$image = wp_get_attachment_image_src( $custom_logo_id , 'full' );
							?>
							<img src="<?php echo esc_url($image[0]); ?>" class="logo" alt="<?php bloginfo( 'name' ); ?>">
							<?php 
						else :
					?>
						<?php if ( is_front_page() && is_home() ) : ?>
							<h1><?php echo esc_html( get_bloginfo ( 'name' ) ); ?></h1>
						<?php else: ?>
							<h2><?php echo esc_html( get_bloginfo ( 'name' ) ); ?></h2>
						<?php endif; ?>
					<?php 
						endif;
					?>
						<?php if ( true == get_theme_mod( 'show_tagline_after_logo', true ) ) : ?>
							<span><?php echo esc_html( get_bloginfo ( 'description' ) ); ?></span>
						<?php endif; ?>
					</a>
				</div>
				<!-- Logo end -->
				
				<!-- Start Atribute Navigation -->
				<div class="attr-nav">
					<ul>
					<?php if ( true == get_theme_mod( 'show_header_search_button', true ) ) : ?>
						<li><button type="button" id="search-toggle" class="search-toggle"><i class="fas fa-search"></i><span class="screen-reader-text"><?php _e( 'Search', 'blogman' ); ?></span>
						</button></li>
					<?php endif; ?>
						<li class="side-menu">
							<a href="#" class="hamburger">
								<span class="bar"></span>
								<span class="bar"></span>
								<span class="bar"></span>
							</a>
						</li>
					</ul>
				</div>        
				<!-- End Atribute Navigation -->
			</div>
			
			<!-- Start Side Menu -->
			<div class="side menu-sidebar">
				<a href="#" class="close-side"><i class="fa fa-times"></i></a>
				<div class="widget">
					<?php if ( true == get_theme_mod( 'show_title_in_side_menu', true ) ) : ?>
						<h1><?php echo esc_html( get_bloginfo ( 'name' ) ); ?></h1>
					<?php endif; ?>
					<?php
						/**
						 * Display main navigation
						 */
						wp_nav_menu( array(
							'menu_id'      => 'main-menu',
							'container'      => false,
							'theme_location' => 'main-menu',
							'menu_class'     => 'link',
							'fallback_cb'    => ''
						) );
					?>
				</div>
			</div>
			<!-- End Side Menu -->
		</nav>
	</header>
	<!-- Header Section ends-->
	
	<!-- Search Form start -->
	<div id="site-search" class="site-search">
		<span class="search-close">&times;</span>
		<div class="main-search-form">
			<?php get_search_form(); ?>
		</div>
	</div>
	<!-- Search Form end -->
	
	<?php 
		$show_header_banner = get_theme_mod( 'show_header_banner', true );
		$header_banner_title = get_theme_mod( 'header_banner_title' );
		$header_banner_sub_title = get_theme_mod( 'header_banner_sub_title' );
		$header_banner_message = get_theme_mod('header_banner_message');
		$header_banner_button_text = get_theme_mod( 'header_banner_button_text' );
		if( empty($header_banner_title) && empty($header_banner_sub_title) && empty($header_banner_message) ){
			$show_header_banner = false;
		}
		
		if ( ( is_home() || is_front_page() ) && $show_header_banner  ) : 
	?>
	<!-- Banner section starts -->
	<section class="banner">
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="main-header-box">
						<?php if(!empty($header_banner_title)){ ?>
							<h2><?php echo sanitize_text_field( $header_banner_title ); ?></h2>
						<?php } ?>
						<?php if(!empty($header_banner_sub_title)){ ?>
							<h3><?php echo sanitize_text_field( $header_banner_sub_title ); ?></h3>
						<?php } ?>
						<?php if(!empty($header_banner_message)){ 
								$header_banner_message = nl2br($header_banner_message);
						?>
							<p><?php echo wp_kses_post( $header_banner_message ); ?></p>
						<?php } ?>
						<?php if(!empty($header_banner_button_text)){ ?>
							<a href="<?php echo esc_url( get_theme_mod( 'header_banner_button_link' ) ); ?>" class="btn-view-profile"><?php echo sanitize_text_field( $header_banner_button_text ); ?> <i class="fas fa-arrow-right"></i></a>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Banner section ends -->
	<?php endif; ?>