<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$section    = 'author_page';
$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'custom',
	'settings'    => 'post_color_settings',
	'default'     => '<div style="color: #555d66;font-weight: normal;font-size: 14px;">' . esc_html__( 'Following data will display only when you create page with "About Author" page template.', 'blogman' ) . '</div>',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'text',
	'settings'    => 'author_sub_title',
	'label'       => esc_html__( 'Sub Title', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'text',
	'settings'    => 'author_interested_in',
	'label'       => esc_html__( 'Interested In', 'blogman' ),
	'description' => esc_html__( 'Enter value with comma separated.', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'text',
	'settings'    => 'author_email_id',
	'label'       => esc_html__( 'Email Id', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'text',
	'settings'    => 'author_phone',
	'label'       => esc_html__( 'Phone Number', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'repeater',
	'label'       => esc_html__( 'Author Social Profile Links', 'blogman' ),
	'description' => sprintf( wp_kses_post( __( 'You can find icon class <a target="_blank" href="%s">here</a>. Ex.: envelope', 'blogman' ) ), 'https://fontawesome.com/cheatsheet' ),
	'section'     => $section,
	'priority'    => $priority ++,
	'row_label' => array(
		'type' => 'text',
		'value' => esc_html__('Profile Link', 'blogman' ),
	),
	'settings'    => 'author_social_links_items',
	'fields' => array(
		'author_social_icon' => array(
			'type'        => 'text',
			'label'       => esc_html__( 'Icon', 'blogman' ),
			'description' => esc_html__('Enter class name here', 'blogman' ),
			'default'     => '',
		),
		'author_social_link' => array(
			'type'        => 'text',
			'label'       => esc_html__( 'Link to social', 'blogman' ),
			'default'     => '',
		),
	)
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'text',
	'settings'    => 'author_expertise',
	'label'       => esc_html__( 'Author Expertise', 'blogman' ),
	'description' => esc_html__( 'Enter value with comma separated.', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
) );
