<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$section    = 'blog_options';

$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'text',
	'settings'    => 'blog_page_title',
	'label'       => esc_html__( 'Blog Page Title', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_full_post_content',
	'label'       => esc_html__( 'Show Full Post Content', 'blogman' ),
	'description' => esc_html__( 'Whether to display full post content on Blog Or Archives pages', 'blogman' ),
	'section'     => $section,
	'default'     => '0',
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'slider',
	'settings'    => 'excerpt_length_post',
	'label'       => esc_html__( 'Excerpt Length', 'blogman' ),
	'description' => esc_html__( 'Number of words to display in the excerpts', 'blogman' ),	
	'section'     => $section,
	'priority'    => $priority ++,
	'default'     => 25,
	'choices'     => array(
		'min'  => '0',
		'max'  => '500',
		'step' => '1',
	),
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'excerpt_read_more_sign',
	'label'       => esc_html__( 'Excerpt Read More Sign Hide/Show', 'blogman' ),
	'description' => esc_html__( 'Whether to display read more sign "..." on excerpts', 'blogman' ),
	'section'     => $section,
	'default'     => '1',
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_archive_page_title',
	'label'       => esc_html__( 'Show title on archive pages', 'blogman' ),
	'section'     => $section,
	'default'     => '1',
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_tag_on_archive_page',
	'label'       => esc_html__( 'Show tag on archive pages', 'blogman' ),
	'section'     => $section,
	'default'     => '0',
	'priority'    => $priority ++,
) );
