<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



$panel    = 'colors_options';
$priority_section = 1;

//Add section
Blogman_Kirki::add_section( 'general_colors', array(
	'title'    => __( 'General Colors', 'blogman' ),
	'panel'    => $panel,
	'priority' => $priority_section ++
) );

Blogman_Kirki::add_section( 'header_colors', array(
	'title'    => __( 'Header Colors', 'blogman' ),
	'panel'    => $panel,
	'priority' => $priority_section ++
) );

Blogman_Kirki::add_section( 'menu_colors', array(
	'title'    => __( 'Menu Colors', 'blogman' ),
	'panel'    => $panel,
	'priority' => $priority_section ++
) );

Blogman_Kirki::add_section( 'content_colors', array(
	'title'    => __( 'Content Colors', 'blogman' ),
	'panel'    => $panel,
	'priority' => $priority_section ++
) );

Blogman_Kirki::add_section( 'social_sharing_colors', array(
	'title'    => __( 'Social Sharing Colors', 'blogman' ),
	'panel'    => $panel,
	'priority' => $priority_section ++
) );

Blogman_Kirki::add_section( 'comment_colors', array(
	'title'    => __( 'Comment Colors', 'blogman' ),
	'panel'    => $panel,
	'priority' => $priority_section ++
) );

Blogman_Kirki::add_section( 'footer_colors', array(
	'title'    => __( 'Footer Colors', 'blogman' ),
	'panel'    => $panel,
	'priority' => $priority_section ++
) );


//Add settings

$section    = 'general_colors';
$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'body_background_color',
	'label'       => esc_html__( 'Body Background Color', 'blogman' ),
	'default'     => '#ffffff',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'blogman_accent_color',
	'label'       => esc_html__( 'Accent Color', 'blogman' ),
	'description' => esc_html__( 'This color applied to header banner text. Post meta info. like date, author, category etc. And on buttons', 'blogman' ),
	'default'     => '#121315',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'button_hover_text_color',
	'label'       => esc_html__( 'Button Hover Text Color', 'blogman' ),
	'description' => esc_html__( 'Hover color for read more, post comment button etc.', 'blogman' ),
	'default'     => '#ffffff',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

$section    = 'header_colors';
$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'header_background_color',
	'label'       => esc_html__( 'Header Background Color', 'blogman' ),
	'default'     => '#f7f6f2',
	'section'  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'site_title_color',
	'label'       => esc_html__( 'Site Title Color', 'blogman' ),
	'default'     => '#2a2a2a',
	'section'  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'site_tagline_color',
	'label'       => esc_html__( 'Site Tagline Color', 'blogman' ),
	'default'     => '#2a2a2a',
	'section'  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'separator_color_title_tagline',
	'label'       => esc_html__( 'Separator Line Color', 'blogman' ),
	'description' => esc_html__( 'Separator line color of between Title & Tagline.', 'blogman' ),
	'default'     => '#2a2a2a',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );



$section    = 'menu_colors';
$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'menu_hamburger_icon_color',
	'label'       => esc_html__( 'Menu Hamburger Icon Color', 'blogman' ),
	'default'     => '#2a2a2a',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'menu_background_color',
	'label'       => esc_html__( 'Menu Background Color', 'blogman' ),
	'default'     => '#2a2a2a',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'menu_title_color',
	'label'       => esc_html__( 'Title Color', 'blogman' ),
	'default'     => '#ffffff',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'menu_text_color',
	'label'       => esc_html__( 'Menu Text Color', 'blogman' ),
	'default'     => '#ffffff',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'menu_text_hover_color',
	'label'       => esc_html__( 'Menu Text Hover Color', 'blogman' ),
	'default'     => '#ffffff',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

$section    = 'content_colors';
$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'body_text_color',
	'label'       => esc_html__( 'Body Text Color', 'blogman' ),
	'default'     => '#727477',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'section_title_color',
	'label'       => esc_html__( 'Title Color', 'blogman' ),
	'description' => esc_html__( 'Title color of page, archive page & widget', 'blogman' ),
	'default'     => '#121315',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'post_title_color',
	'label'       => esc_html__( 'Post Title Color', 'blogman' ),
	'description' => esc_html__( 'Title color for post list and single post', 'blogman' ),
	'default'     => '#121315',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'heading_color',
	'label'       => esc_html__( 'Heading Color', 'blogman' ),
	'description' => esc_html__( 'Color of H1 to H6 Tags. Not applicable for post, page & widget title.', 'blogman' ),
	'default'     => '#121315',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'a_tag_color',
	'label'       => esc_html__( 'a Tag Color', 'blogman' ),
	'description' => esc_html__( 'Color of anchor tag', 'blogman' ),
	'default'     => '#2a2a2a',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'a_tag_hover_color',
	'label'       => esc_html__( 'a Tag Hover Color', 'blogman' ),
	'description' => esc_html__( 'Color of anchor tag hover', 'blogman' ),
	'default'     => '#000000',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'alt_text_color',
	'label'       => esc_html__( 'Alt Text Color', 'blogman' ),
	'description' => esc_html__( 'Color of word like Published on, month, by, in etc.', 'blogman' ),
	'default'     => '#a7a5a5',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'bg_color_of_extra_box',
	'label'       => esc_html__( 'Background color', 'blogman' ),
	'description' => esc_html__( 'Background color of Sticky post, blockquote', 'blogman' ),
	'default'     => '#f7f6f2',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'separator_line_color_post_widget',
	'label'       => esc_html__( 'Separator Line Color', 'blogman' ),
	'description' => esc_html__( 'Separator line color of between post and sidebar widget etc.', 'blogman' ),
	'default'     => '#e8e7e7',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

$section    = 'social_sharing_colors';
$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'bg_color_of_social_sharing_box',
	'label'       => esc_html__( 'Social Share Box Bg Color', 'blogman' ),
	'default'     => '#f7f6f2',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'social_sharing_box_text_color',
	'label'       => esc_html__( 'Text Color', 'blogman' ),
	'default'     => '#32373c',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'social_sharing_icon_color',
	'label'       => esc_html__( 'Icon Color', 'blogman' ),
	'default'     => '#727477',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'social_sharing_icon_hover_color',
	'label'       => esc_html__( 'Icon Hover Color', 'blogman' ),
	'default'     => '#32373c',
	'section'	  => $section,
	'priority'    => $priority ++,
) );


$section    = 'comment_colors';
$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'bg_color_of_comment_box',
	'label'       => esc_html__( 'Comment Box Bg Color', 'blogman' ),
	'description' => esc_html__( 'Background color of comment box', 'blogman' ),
	'default'     => '#f7f6f2',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'comment_text_color',
	'label'       => esc_html__( 'Comment Text Color', 'blogman' ),
	'default'     => '#727477',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'separator_line_color_comment',
	'label'       => esc_html__( 'Comment Separator Line Color', 'blogman' ),
	'description' => esc_html__( 'Separator line color of between comments.', 'blogman' ),
	'default'     => '#c9c9c9',
	'section' 	  => $section,
	'priority'    => $priority ++,
) );


$section    = 'footer_colors';
$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'footer_background_color',
	'label'       => esc_html__( 'Footer Background Color', 'blogman' ),
	'default'     => '#f7f6f2',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'footer_title_color',
	'label'       => esc_html__( 'Footer Title Color', 'blogman' ),
	'default'     => '#2a2a2a',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'footer_text_color',
	'label'       => esc_html__( 'Footer Text Color', 'blogman' ),
	'default'     => '#656565',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'blogman_icon_color',
	'label'       => esc_html__( 'Icon Color', 'blogman' ),
	'default'     => '#2a2a2a',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'color',
	'settings'    => 'blogman_icon_hover_color',
	'label'       => esc_html__( 'Icon Hover Color', 'blogman' ),
	'default'     => '#000000',
	'section'	  => $section,
	'priority'    => $priority ++,
) );

