<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$section    = 'general_options';

$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'text',
	'settings'    => 'container_width',
	'label'       => esc_html__( 'Content Width', 'blogman' ),
	'description' => esc_html__( 'Sets the default width of the content area (Default: 1140px)', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
	'input_attrs' => array(
		'placeholder' => '1140px',
	),
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_preloader',
	'label'       => esc_html__( 'Preloader Hide/Show', 'blogman' ),
	'description' => esc_html__( 'Whether to display preloader, When the page being loading', 'blogman' ),
	'section'     => $section,
	'default'     => '0',
	'priority'    => $priority ++,
) );


Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'sticky_header',
	'label'       => esc_html__( 'Sticky Header Disable/Enable', 'blogman' ),
	'section'     => $section,
	'default'     => '0',
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_title_in_side_menu',
	'label'       => esc_html__( 'Site Title In Side Menu Hide/Show', 'blogman' ),
	'description' => esc_html__( 'Whether to display site title in side menu panel or not', 'blogman' ),
	'section'     => $section,
	'default'     => '1',
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'smooth_scrolling',
	'label'       => esc_html__( 'Smooth Scrolling Disable/Enable', 'blogman' ),
	'section'     => $section,
	'default'     => '0',
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'comments_box_hide_save_fields_checkbox',
	'label'       => esc_html__( 'Hide/Show checkbox "Save my name, email, and website in this browser for the next time I comment."', 'blogman' ),
	'description' => esc_html__( 'Note that: This checkbox just appears when you use Wordpress from version 4.9.6', 'blogman' ),
	'section'     => $section,
	'default'     => '0',
	'priority'    => $priority ++,
) );
