<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$section    = 'header_options';

$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_tagline_after_logo',
	'label'       => esc_html__( 'Tagline Hide/Show', 'blogman' ),
	'description' => esc_html__( 'Whether to display Tagline after logo', 'blogman' ),
	'section'     => $section,
	'default'     => '1',
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_header_search_button',
	'label'       => esc_html__( 'Search Button Hide/Show', 'blogman' ),
	'section'     => $section,
	'default'     => '1',
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_header_banner',
	'label'       => esc_html__( 'Header Banner Hide/Show', 'blogman' ),
	'section'     => $section,
	'default'     => '1',
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'text',
	'settings'    => 'header_banner_title',
	'label'       => esc_html__( 'Banner Title', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
	'active_callback'    => array(
			array(
				'setting'  => 'show_header_banner',
				'operator' => '==',
				'value'    => '1',
			),
		),
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'text',
	'settings'    => 'header_banner_sub_title',
	'label'       => esc_html__( 'Banner Sub Title', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
	'active_callback'    => array(
			array(
				'setting'  => 'show_header_banner',
				'operator' => '==',
				'value'    => '1',
			),
		),
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'     => 'textarea',
	'settings' => 'header_banner_message',
	'label'    => esc_html__( 'Banner Message', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
	'active_callback'    => array(
			array(
				'setting'  => 'show_header_banner',
				'operator' => '==',
				'value'    => '1',
			),
		),
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'     => 'text',
	'settings' => 'header_banner_button_text',
	'label'    => esc_html__( 'Banner Button Title', 'blogman' ),
	'section'  => $section,
	'priority'    => $priority ++,
	'active_callback'    => array(
			array(
				'setting'  => 'show_header_banner',
				'operator' => '==',
				'value'    => '1',
			),
		),
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'     => 'text',
	'settings' => 'header_banner_button_link',
	'label'    => esc_html__( 'Banner Button Link', 'blogman' ),
	'section'  => $section,
	'priority'    => $priority ++,
	'active_callback'    => array(
			array(
				'setting'  => 'show_header_banner',
				'operator' => '==',
				'value'    => '1',
			),
		),
) );