<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$section    = 'social_links';
$priority = 1;

//Add settings sociallinks
Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'repeater',
	'label'       => esc_html__( 'Add Social Links', 'blogman' ),
	'description' => sprintf( wp_kses_post( __( 'You can find icon class <a target="_blank" href="%s">here</a>. Ex.: envelope', 'blogman' ) ), 'https://fontawesome.com/cheatsheet' ),
	'section'     => $section,
	'priority'    => $priority ++,
	'row_label' => array(
		'type' => 'text',
		'value' => esc_html__('Social Link', 'blogman' ),
	),
	'settings'    => 'social_links_items',
	'fields' => array(
		'social_icon' => array(
			'type'        => 'text',
			'label'       => esc_html__( 'Icon', 'blogman' ),
			'description' => esc_html__('Enter class name here', 'blogman' ),
			'default'     => '',
		),
		'social_link' => array(
			'type'        => 'text',
			'label'       => esc_html__( 'Link to social', 'blogman' ),
			'default'     => '',
		),
	)
) );
