<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$section    = 'social_sharing';

$priority = 1;

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'sortable',
	'settings'    => 'social_sharing_links',
	'label'       => __( 'Sharing Icons', 'blogman' ),
	'description' => __('Move up down to change order And click on eye icon to hide or show social icon', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
	'default'     => array(
		'facebook',
		'twitter',
		'linkedin',
		'googleplus',
		'pinterest',
		'email',
	),
	'choices'     => array(
		'facebook' => esc_attr__( 'Facebook', 'blogman' ),
		'twitter' => esc_attr__( 'Twitter', 'blogman' ),
		'linkedin' => esc_attr__( 'LinkedIn', 'blogman' ),
		'reddit' => esc_attr__( 'Reddit', 'blogman' ),
		'tumblr' => esc_attr__( 'Tumblr', 'blogman' ),
		'googleplus' => esc_attr__( 'Google+', 'blogman' ),
		'pinterest' => esc_attr__( 'Pinterest', 'blogman' ),
		'vk' => esc_attr__( 'vk', 'blogman' ),
		'email' => esc_attr__( 'Email', 'blogman' ),
		'stumbleupon' => esc_attr__( 'Stumbleupon', 'blogman' ),
		'telegram' => esc_attr__( 'Telegram', 'blogman' ),
		'whatsapp' => esc_attr__( 'Whatsapp', 'blogman' ),
	),
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'text',
	'settings'    => 'social_sharing_title',
	'label'       => __( 'Social Sharing Title', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_social_share_on_post_detail',
	'label'       => __( 'Hide/Show On Post Detail Page', 'blogman' ),
	'description' => __( 'Whether to display social Sharing icons on post detail page?', 'blogman' ),
	'section'     => $section,
	'default'     => 1,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_social_share_on_page',
	'label'       => __( 'Hide/Show On Pages', 'blogman' ),
	'description' => __( 'Whether to display social Sharing icons on pages?', 'blogman' ),
	'section'     => $section,
	'default'     => 0,
	'priority'    => $priority ++,
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'toggle',
	'settings'    => 'show_social_share_on_archive_page',
	'label'       => __( 'Hide/Show On Archive Pages', 'blogman' ),
	'description' => __( 'Whether to display social sharing icons on archive pages?', 'blogman' ),
	'section'     => $section,
	'default'     => 0,
	'priority'    => $priority ++,
) );

