<?php
/**
 * Add customize CSS from options customizer
 * Hook to wp_enqueue_scripts() function to render style
 *
 * @package WordPress
 * @since 1.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function blogman_custom_styles() {
	
	$container_width	= get_theme_mod( 'container_width');
	$body_typography	= get_theme_mod( 'body_typography', array('font-family'    => 'Poppins') );
	$title_typography	= get_theme_mod( 'title_typography', array('font-family'    => 'Poppins') );
	
	$header_bg_color	= get_theme_mod( 'header_background_color');
	$site_title_color	= get_theme_mod( 'site_title_color');
	$site_tagline_color	= get_theme_mod( 'site_tagline_color');
	$separator_color_title_tagline	= get_theme_mod( 'separator_color_title_tagline');
	$body_bg_color		= get_theme_mod( 'body_background_color');
	$accent_color		= get_theme_mod( 'blogman_accent_color');
	$button_hover_text_color		= get_theme_mod( 'button_hover_text_color');
	
	$body_text_color	= get_theme_mod( 'body_text_color');
	$section_title_color	    = get_theme_mod( 'section_title_color');
	$post_title_color	    = get_theme_mod( 'post_title_color');
	$heading_color		= get_theme_mod( 'heading_color');
	$a_tag_color		= get_theme_mod( 'a_tag_color');
	$a_tag_hover_color	= get_theme_mod( 'a_tag_hover_color');
	$alt_text_color		= get_theme_mod( 'alt_text_color');
	$bg_color_of_extra_box		= get_theme_mod( 'bg_color_of_extra_box');
	$separator_line_color_post_widget		= get_theme_mod( 'separator_line_color_post_widget');
	$bg_color_of_comment_box		= get_theme_mod( 'bg_color_of_comment_box');
	$comment_text_color		= get_theme_mod( 'comment_text_color');
	$separator_line_color_comment		= get_theme_mod( 'separator_line_color_comment');

	$menu_hamburger_icon_color	= get_theme_mod( 'menu_hamburger_icon_color');
	$menu_background_color	= get_theme_mod( 'menu_background_color');
	$menu_title_color		= get_theme_mod( 'menu_title_color');
	$menu_text_color		= get_theme_mod( 'menu_text_color');
	$menu_text_hover_color	= get_theme_mod( 'menu_text_hover_color');
	

	$footer_bg_color	= get_theme_mod( 'footer_background_color');
	$footer_title_color	= get_theme_mod( 'footer_title_color');
	$footer_text_color	= get_theme_mod( 'footer_text_color');
	$blogman_icon_color	= get_theme_mod( 'blogman_icon_color');
	$blogman_icon_hover_color	= get_theme_mod( 'blogman_icon_hover_color');
	
	$bg_color_of_social_sharing_box	= get_theme_mod( 'bg_color_of_social_sharing_box');
	$social_sharing_box_text_color	= get_theme_mod( 'social_sharing_box_text_color');
	$social_sharing_icon_color	= get_theme_mod( 'social_sharing_icon_color');
	$social_sharing_icon_hover_color	= get_theme_mod( 'social_sharing_icon_hover_color');

	$css = array();
	
	if ( ! empty( $container_width ) ) {
		$css['.page-wrapper .container,
		.page-single .container,
		.page-default .container,
		.footer-widget-area .container
		']['max-width'] = $container_width;
	}
	
	if ( ! empty( $header_bg_color ) ) {
		$css['.wrap-sticky, nav.navbar.bootsnav, .banner']['background-color'] = $header_bg_color;
	}
	
	if ( ! empty( $site_title_color ) ) {
		$css['.navbar-brand h1, .navbar-brand h2']['color'] = $site_title_color;
	}
	
	if ( ! empty( $site_tagline_color ) ) {
		$css['.navbar-brand span']['color'] = $site_tagline_color;
	}
	
	if ( ! empty( $separator_color_title_tagline ) ) {
		$css['.navbar-brand span']['border-color'] = $separator_color_title_tagline; 
	}
	
	if ( ! empty( $accent_color ) ) {
		//Header Box color
		$css['.main-header-box h2,
			  .main-header-box h3,
			  .main-header-box p
		']['color'] = $accent_color;
		
		
		//Set post meta color
		$css['.post-list .post-header .post-title .post-meta a,
			.post-wrapper .post-header .post-title .post-meta a,
			.post-list .post-header .post-meta-date p span,
			.post-wrapper .post-header .post-meta-date p span
		']['color'] = $accent_color;
		
		//Button color
		$css['.post-list .post-footer .btn-read-more,
			  .btn-view-profile,
			  .blogman-button-comment, 
			  .btn-contact']['color'] = $accent_color;
		
		$css['.post-list .post-footer .btn-read-more:hover,
			  .post-list .post-footer .btn-read-more:focus,
			  .btn-view-profile:hover,
			  .btn-view-profile:focus,
			  .blogman-button-comment:hover, 
			  .blogman-button-comment:focus, 
			  .btn-contact:hover,
			  .btn-contact:focus']['background-color'] = $accent_color;
			  
		$css['.post-list .post-footer .btn-read-more, 
			  .btn-view-profile,
			  .blogman-button-comment, 
			  .btn-contact']['border-color'] = $accent_color;
		
		//Paginated post color
		$css['.post-body .page-links span.page-links-title,
			  .default-page-entry .page-links span.page-links-title']['color'] = $accent_color;
		$css['.post-body .page-links span.page-number, 
			  .default-page-entry .page-links span.page-number']['background-color'] = $accent_color;
		
	}
	
	if ( ! empty( $button_hover_text_color ) ) {
		$css['.post-list .post-footer .btn-read-more:focus, .post-list .post-footer .btn-read-more:hover,
			  .btn-view-profile:focus, .btn-view-profile:hover,
			  .blogman-button-comment:hover, .blogman-button-comment:focus, .btn-contact:hover, .btn-contact:focus']['color'] = $button_hover_text_color;
	}
	
	//Menu Color Settings
	if ( ! empty( $menu_hamburger_icon_color ) ) {
		$css['.hamburger span']['background'] = $menu_hamburger_icon_color;
	}
	if ( ! empty( $menu_background_color ) ) {
		$css['.menu-sidebar']['background-color'] = $menu_background_color;
	}
	if ( ! empty( $menu_title_color ) ) {
		$css['.menu-sidebar h1']['color'] = $menu_title_color;
	}
	if ( ! empty( $menu_text_color ) ) {
		$css['.menu-sidebar.side .widget ul.link li a']['color'] = $menu_text_color;
		$css['.side .close-side']['color'] = $menu_text_color; // Set close button color of side panel
	}
	if ( ! empty( $menu_text_hover_color ) ) {
		$css['.menu-sidebar.side .widget ul.link li a:hover']['color'] = $menu_text_hover_color;
	}
	
	if ( ! empty( $body_bg_color ) ) {
		$css['body']['background-color'] = $body_bg_color;
	}
	if ( ! empty( $heading_color ) ) {
		$css['h1, h2, h3, h4, h5, h6']['color'] = $heading_color;
	}
	if ( ! empty( $body_text_color ) ) {
		$css['body']['color'] = $body_text_color;
		$css['input, select, textarea']['color'] = $body_text_color. ' !important';
		//Set next prev color
		$css['.nav-prev-btn, .nav-next-btn']['color'] = $body_text_color;
		$css['.nav-prev-btn, .nav-next-btn']['border-color'] = $body_text_color;
		//set wp-caption border color same as text color
		$css['.wp-caption']['border-color'] = $body_text_color;
		$css['#gallery-1 img, #gallery-2 img, #gallery-3 img, #gallery-4 img, #gallery-5 img, #gallery-6 img, #gallery-7 img, #gallery-8 img, #gallery-9 img, #gallery-10 img']['border-color'] = $body_text_color. ' !important';
	}
	
	if ( ! empty( $section_title_color ) ) { 
		//Set page and widget title color
		$css['.page-title h1, 
			  .page-title h2,
			  .sidebar-widget .widget .widget-title']['color'] = $section_title_color;
			  
		//Set color of bottom title pattern
		$css['.page-title h1:before, 
			  .page-title h2:before,
			  .page-title h1:after, 
			  .page-title h2:after']['background-color'] = $section_title_color;
		
	}
	if ( ! empty( $post_title_color ) ) {
		//Set post title color
		$css['.post-list .post-header .post-title h2,
			  .post-wrapper .post-header .post-title h1']['color'] = $post_title_color;
		
		//Set next prev icon color same as post title color
		$css['.nav-prev-btn:hover, .nav-next-btn:hover']['color'] = $post_title_color;
		$css['.nav-prev-btn:hover, .nav-next-btn:hover']['border-color'] = $post_title_color;
	}
	
	if ( ! empty( $a_tag_color ) ) {
		$css['a']['color'] = $a_tag_color;
	}
	if ( ! empty( $a_tag_hover_color ) ) {
		$css['a:hover']['color'] = $a_tag_hover_color;
	}
	if ( ! empty( $alt_text_color ) ) {
		$css['.post-list .post-header .post-meta-date p, 
			  .post-wrapper .post-header .post-meta-date p, 
			  .post-list .post-header .post-title .post-meta span, 
			  .post-wrapper .post-header .post-title .post-meta span,
			  .sidebar-widget .widget ul li
			  ']['color'] = $alt_text_color;
			  
		$css['.post-header .post-title h1:before, 
		.post-header .post-title h2:before']['background-color'] = $alt_text_color;
	}
	
	if ( ! empty( $bg_color_of_extra_box ) ) {
		$css['.post-body blockquote, 
		      .default-page-entry blockquote,
			  .post.sticky,
			  .mailchimp-newsletter']['background-color'] = $bg_color_of_extra_box;
	}
	
	
	if ( ! empty( $separator_line_color_post_widget ) ) {
		$css['.post-list,
			  .sidebar-widget .widget,
			  .post-tags,
			  .nav-links,
			  .sidebar-widget .mc4wp-form,
			  .searchform,
			  .comment-form .comment-form-author input, .comment-form .comment-form-email input, .comment-form .comment-form-url input, .comment-form .comment-form-comment textarea']['border-color'] = $separator_line_color_post_widget;
		
	}
	
	if ( ! empty( $bg_color_of_comment_box ) ) {
		$css['.commentlist,
			  .comment-body blockquote']['background-color'] = $bg_color_of_comment_box;
	}
	if ( ! empty( $comment_text_color ) ) {
		$css['.comment-body p,
			  .commentlist a,
			  .commentlist .comment-header .comment-date,
			  .commentlist h1, .commentlist h2, .commentlist h3,
			  .commentlist h4, .commentlist h5, .commentlist h6,
			  .comment-body dd,
			  .comment-body ul li,
			  .comment-body ol li,
			  .comment-body address,
			  .comment-body table tr td']['color'] = $comment_text_color;
	}

	if ( ! empty( $separator_line_color_comment ) ) {
		$css['.commentlist .comment-body,
			.commentlist .comment-form .comment-form-comment textarea']['border-color'] = $separator_line_color_comment;
	}
	
	
	
	
	// Set Body typography
	if ( isset( $body_typography['font-family'] ) && ! empty( $body_typography['font-family'] ) && $body_typography['font-family']!="inherit") {
		$css['body']['font-family'] = '"'.$body_typography['font-family'].'"' ;
		$css['input, select, textarea']['font-family'] = '"'.$body_typography['font-family'].'" !important' ;
	}
	if ( isset( $body_typography['font-size'] ) && ! empty( $body_typography['font-size'] ) ) {
		$css['body']['font-size'] = $body_typography['font-size'] ;
	}
	if ( isset( $body_typography['font-weight'] ) && ! empty( $body_typography['font-weight'] ) ) {
		$css['body']['font-weight'] = $body_typography['font-weight'] ;
	}
	
	// Set title tag typography
	if ( isset( $title_typography['font-family'] ) && ! empty( $title_typography['font-family'] ) && $title_typography['font-family']!="inherit" ) {
		$css['h1, h2, h3, h4, h5, h6']['font-family'] = '"'.$title_typography['font-family'].'"' ;
		//Set same font for date
		$css['.post-list .post-header .post-title .post-meta a, .post-wrapper .post-header .post-title .post-meta a, .post-list .post-header .post-meta-date p span, .post-wrapper .post-header .post-meta-date p span']['font-family'] = '"'.$title_typography['font-family'].'"' ;
	}
	if ( isset( $title_typography['font-weight'] ) && ! empty( $title_typography['font-weight'] ) ) {
		$css['h1, h2, h3, h4, h5, h6']['font-weight'] = $title_typography['font-weight'] ;
	}
	
	
	if ( ! empty( $footer_bg_color ) ) {
		$css['footer.page-footer']['background-color'] = $footer_bg_color;
	}
	if ( ! empty( $footer_title_color ) ) {
		$css['.footer-logo h2']['color'] = $footer_title_color;
	}
	if ( ! empty( $footer_text_color ) ) {
		$css['.footer-copyright p']['color'] = $footer_text_color;
	}
	if ( ! empty( $blogman_icon_color ) ) {
		$css['.footer-social a']['color'] = $blogman_icon_color;
	}
	if ( ! empty( $blogman_icon_hover_color ) ) {
		$css['.footer-social a:hover']['color'] = $blogman_icon_hover_color;
	}
	
	
	if ( ! empty( $bg_color_of_social_sharing_box ) ) {
		$css['.social-share-post']['background'] = $bg_color_of_social_sharing_box;
	}
	
	if ( ! empty( $social_sharing_box_text_color ) ) {
		$css['.social-share-post span']['color'] = $social_sharing_box_text_color;
	}
	
	if ( ! empty( $social_sharing_icon_color ) ) {
		$css['.social-share-post a']['color'] = $social_sharing_icon_color;
	}
	if ( ! empty( $social_sharing_icon_hover_color ) ) {
		$css['.social-share-post a:hover']['color'] = $social_sharing_icon_hover_color;
	}


	$final_css = '';
    foreach ( $css as $style => $style_array ) {
        $final_css .= $style . '{ ';
        foreach ( $style_array as $property => $value ) {
            $final_css .= $property . ':' . $value . ';';
        }
        $final_css .= ' } ';
    }
    wp_add_inline_style( 'blogman-style', $final_css );
}
add_action( 'wp_enqueue_scripts', 'blogman_custom_styles' );