<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$section    = 'typography';
$priority = 1;

//Add settings to typography

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'radio',
	'settings'    => 'webfonts_load_mothod',
	'label'       => __( 'WebFonts Load Method', 'blogman' ),
	'description' => esc_html__( 'If you choice Link method then fonts loads using link tag in head. Otherwise fonts loads using webfont.js in footer. Note: This setting will not work, if you choice "Download font-family to server instead of using the Google CDN." from Body or Title setting.', 'blogman' ),
	'section'     => $section,
	'priority'    => $priority ++,
	'default'     => 'link',
	'choices'     => array(
		'link'   => esc_attr__( 'Link', 'blogman' ),
		'async' => esc_attr__( 'Asynchronous', 'blogman' ),
	),
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'typography',
	'settings'    => 'body_typography',
	'label'       => esc_html__( 'Body', 'blogman' ),
	'description' => esc_html__( 'Font for all body text.', 'blogman' ),
	'section'     => $section,
	'default'     => array(
		'font-family'    => 'Poppins',
		'variant'        => 'regular',
		'font-size'      => '16px',
	),
	'choices'  => array(
		'variant' => array( '300','regular','500','600','700','800','900' ),
		'font-size'      => true,
        'line-height'    => false,
        'letter-spacing' => false,
        'color'          => false,
	),
	'priority'    => $priority ++,
	'output'      => array(
		array(
			'element' => 'body',
		),
	),
) );

Blogman_Kirki::add_field( BLOGMAN_CONFIG_ID, array(
	'type'        => 'typography',
	'settings'    => 'title_typography',
	'label'       => esc_html__( 'Title', 'blogman' ),
	'description' => esc_html__( 'Font for title h1, h2, h3, h4, h5, h6 tag', 'blogman' ),
	'section'     => $section,
	'default'     => array(
		'font-family'    => 'Poppins',
		'variant'        => '700',
	),
	'choices'  => array(
		'variant' => array(),
		'font-size'      => false,
        'line-height'    => false,
        'letter-spacing' => false,
        'color'          => false,
	),
	'priority'    => $priority ++,
	'output'      => array(
		array(
			'element' => 'h1, h2, h3, h4, h5, h6',
		),
	),
) );