<?php
/**
 * The template for displaying all posts.
 *
 * This is the template that displays all posts by default.
 *
 * @package Blogman
 * @since 	1.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$home_page_layout	=	get_theme_mod( 'home_page_layout', 'no-sidebar' );
if($home_page_layout == 'no-sidebar') {
	$column = 'col-md-12';
}
else{
	$column = 'col-md-9';
}
?>
<?php get_header(); ?>
<section class="page-wrapper">
	<div class="container">
	<?php if ( get_theme_mod( 'blog_page_title' ) ) : ?>
		<div class="row">
			<div class="col-md-12">
				<div class="page-title">
					<h1><?php echo sanitize_text_field( get_theme_mod( 'blog_page_title' ) ); ?></h1>
				</div>
			</div>
		</div>
	<?php endif; ?>
		<div class="row">
			<div class="<?php echo esc_attr( $column ); ?>">
			<?php /* The loop */
				if ( have_posts() ) :
					while ( have_posts() ) : the_post(); ?>
						<?php get_template_part( 'content' ); ?>
					<?php endwhile; ?>
					
					<div class="navigation">
						<?php 
							posts_nav_link(' ','<div class="nav-prev-btn"><i class="fas fa-angle-left"></i><i class="fas fa-angle-left"></i><i class="fas fa-angle-left"></i></div>','<div class="nav-next-btn"><i class="fas fa-angle-right"></i><i class="fas fa-angle-right"></i><i class="fas fa-angle-right"></i></div>'); ?>
					</div>
				<?php else: ?>
					<p><?php esc_html_e('No posts were found.', 'blogman' ); ?></p>
			<?php endif; ?>
			</div>
			<?php 
				if($home_page_layout == 'with-sidebar'):
					get_sidebar();
				endif;
			?>
		</div>
	</div>
</section>
<?php get_footer(); ?>