<?php
/**
 * The template for displaying search result.
 *
 * @package Blogman
 * @since 	1.0
 */
 
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$search_page_layout	=	get_theme_mod( 'search_page_layout', 'no-sidebar' );
if($search_page_layout == 'no-sidebar') {
	$column = 'col-md-12';
}
else{
	$column = 'col-md-9';
}
?>
<?php get_header(); ?>
<section class="page-wrapper">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="page-title">
					<h1><?php esc_html_e( 'Search results for', 'blogman' ); ?><?php printf( esc_html__( ' "%s"', 'blogman' ), get_search_query() ); ?></h1>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="<?php echo esc_attr( $column ); ?>">
			<?php /* The loop */
				if ( have_posts() ) :
					while ( have_posts() ) : the_post(); ?>
						<?php get_template_part( 'content' ); ?>
					<?php endwhile; ?>
					
					<div class="navigation">
						<?php 
							posts_nav_link(' ','<div class="nav-prev-btn"><i class="fas fa-angle-left"></i><i class="fas fa-angle-left"></i><i class="fas fa-angle-left"></i></div>','<div class="nav-next-btn"><i class="fas fa-angle-right"></i><i class="fas fa-angle-right"></i><i class="fas fa-angle-right"></i></div>'); 
						?>
					</div>
				<?php else: ?>
					<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'blogman' ); ?></p>
							<?php get_search_form(); ?>
			<?php endif; ?>
			</div>
			<?php 
				if($search_page_layout == 'with-sidebar'):
					get_sidebar();
				endif;
			?>
		</div>
	</div>
</section>
<?php get_footer(); ?>