<?php
/**
 * The Template for displaying all single posts
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$blog_single_page_layout	=	get_theme_mod( 'blog_single_page_layout', 'no-sidebar' );
if($blog_single_page_layout == 'no-sidebar') {
	$column = 'col-md-12';
}
else{
	$column = 'col-md-9';
}
?>
<?php get_header(); ?>
	<section class="page-single">
		<div class="container">
			<div class="row">
				<div class="<?php echo esc_attr( $column ); ?>">
					<div class="post-wrapper">
						<?php while ( have_posts() ) : the_post(); ?>
						<div class="post-header">
							<div class="post-meta-date">
								<p><?php esc_html_e( 'Published on', 'blogman' ); ?> <span><?php echo get_the_date('d'); ?></span> <?php echo get_the_date('F'); ?></p>
							</div>
							
							<div class="post-title">
							<?php if ( has_post_format( 'link' ) ) : ?>
								<?php 
									$link_content = get_post_meta( get_the_ID(), '_format_link_url', true );
									the_title( '<h1><a href="' . esc_url( $link_content ) . '">', '</a></h1>' ); 
								?>
							<?php else: ?>
								<?php the_title( '<h1>', '</h1>' ); ?>
							<?php endif; ?>
								<div class="post-meta">
									<span>
									<?php
										if ( has_post_format( 'link' ) ){
											echo '<i class="fas fa-link"></i>';
										}
										elseif ( has_post_format( 'video' ) ){
											echo '<i class="fas fa-video"></i>';
										}
										elseif ( has_post_format( 'audio' ) ){
											echo '<i class="fas fa-music"></i>';
										}
									?><?php esc_html_e( 'By', 'blogman' ); ?></span>
									<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php the_author(); ?></a><span><?php esc_html_e( ', In ', 'blogman' ); ?></span>
									<?php the_category(', '); ?>
								</div>
							</div>
						</div>
						
						<?php get_template_part( 'templates/loop', get_post_format() ); ?>

						<div class="post-body">
							<?php the_content(); ?>
							<?php 
								wp_link_pages( array(
									'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'blogman' ) . '</span>',
									'after'       => '</div>',
									'link_before' => '<span class="page-number">',
									'link_after'  => '</span>',
								) ); 
							?>
						</div>
						
						<?php if( has_tag() ) : ?>
						<div class="post-tags">
							<?php the_tags('# ',', '); ?>
						</div>
						<?php endif; ?>
						
						<?php if ( true == get_theme_mod( 'show_social_share_on_post_detail', true ) ) : ?>
							<?php blogman_social_share_links(); ?>
						<?php endif; ?>
						
						<div class="post-footer"> 
						<?php
							if ( is_singular( 'attachment' ) ) {
								the_post_navigation( array(
									'prev_text' => _x( '<span class="meta-nav">Published in</span><span class="post-title">%title</span>', 'Parent post link', 'blogman' ),
								) );
							} elseif ( is_singular( 'post' ) ) {
								// Previous/next post navigation.
								the_post_navigation( array(
									'next_text' => '<span class="post-title"><span>%title</span> <i class="fas fa-arrow-right"></i></span>',
									'prev_text' => '<span class="post-title"><i class="fas fa-arrow-left"></i> <span>%title</span></span>',
								) );
							}
						?>
						</div>
						
						<?php if ( comments_open() || get_comments_number() ) : ?>
							<div class="post-comments">
								<?php	comments_template(); ?>
							</div>
						<?php endif; ?>
						<?php endwhile; ?>
					</div>
				</div>
				<?php 
					if($blog_single_page_layout == 'with-sidebar'):
						get_sidebar();
					endif;
				?>

			</div>
		</div>
	</section>
<?php get_footer(); ?>