<?php
Class taux_model extends CI_Model
{
	var $table_taux = "taux";
	var $table_partenaires = "partenaires";

	function __construct(){
		parent::__construct();
	}

	public function get_columns(){
		$fields = $this->db->list_fields($this->table_taux);
		return $fields;
	}

	public function nb() {
		$count = $this->db->count_all_results($this->table_taux);
        return $count;
	}

	public function get_all(){
		$this->db->from($this->table_taux);
		$this->db->order_by('id','ASC');
		$datas = $this->db->get()->result();
		return $datas;
	}

	public function getTaux($lib){
		$this->db->select('taux');
		$this->db->from($this->table_taux);
		$this->db->where('libelle', $lib);

	    $query = $this->db->get();

		if ($query->num_rows() > 0)
		{
			$row = $query->row(); 
   			return $row->taux;
		}

		return null;
	}

	public function update($taux)
	{
		$result = false;

		foreach($taux as $lib => $val)
		{
			$where = array('libelle' => $lib);
			$data = array('taux' => (float)$val, 'last_update' => date("Y-m-d H:i:s"));
			$result = $this->db->update($this->table_taux, $data, $where);
		}

		return $result;
	}

	public function updateTaux($taux, $val)
	{
		$result = false;

		if($taux != "" && $val >= 0 && $val <= 100)
		{
			$where = "";
			$data = "";

			switch($taux)
			{
				case "prime_assureur_principal":
					$data = "PRIME_PARTENAIRE = ".$val;
					$where = 'PARENT_PARTENAIRE IS NOT NULL';
					$where .= ' AND ID_PARTENAIRE > 1';
				break;

				case "commission_parent_role_1":
					$data = "COM_PARTENAIRE = ".$val;
					$where = 'PARENT_PARTENAIRE IS NOT NULL';
					$where .= ' AND ID_PARTENAIRE > 1';
					$where .= ' AND TYPE_PARTENAIRE = 0';
				break;

				case "commission_parent_role_3":
					$data = "COM_AS_PARENT_PARTENAIRE = ".$val;
					$where = 'PARENT_PARTENAIRE IS NOT NULL';
					$where .= ' AND ID_PARTENAIRE > 1';
					$where .= ' AND TYPE_PARTENAIRE = 1';
				break;

				case "commission_parent_role_2":
					$data = "COM_AS_PARENT_PARTENAIRE = ".$val;
					$where = 'PARENT_PARTENAIRE IS NOT NULL';
					$where .= ' AND ID_PARTENAIRE > 1';
				break;
			}
			
			if($where != "" && $data != "")
			{
				$sql = "UPDATE ".$this->db->dbprefix($this->table_partenaires)." SET ".$data." WHERE ".$where;
				$result = $this->db->query($sql);
			}
			
		}

		return $result;
	}

}