"use strict";
jQuery(function ($) {

	$(document).ready(function () {
		var isRtl = $('html').attr('dir') === 'rtl';

		$(".wcdrp-products-slider").each(function (index, element) {
			var ulId = jQuery(element).prop('id');
			ulId = ulId.replace('wcdrp-', '');
			var owl = $(this);
			var itemsDesctopCount = 5;
			var showNav = true;
			if( SliderData && SliderData.show_nav_in_slider && SliderData.number_columns ) {
			    showNav = (SliderData.show_nav_in_slider[ulId] == 1) ? true : false;
			    itemsDesctopCount = SliderData.number_columns[ulId];
			}
			owl.owlCarousel({
				margin: 10,
				responsiveClass: true,
				rtl: isRtl,
				nav: showNav,
				onInitialized: arrowsImagePosition,
				onResize: arrowsImagePosition,
				responsive: {
					0: {
						items: 1
					},
					600: {
						items: 3
					},
					1000: {
						items: itemsDesctopCount,
						lazyLoad: true
					}
				}
			});
			function arrowsImagePosition() {
				var imageHeight,
					slider = $(document).find(owl);
				imageHeight = slider.find('.woocommerce-loop-product__link img').eq(0).height();
				slider.find('.owl-nav > div').css('top', imageHeight / 2 + 'px');
			}
		});
	})
});
