<?php
include_once('./include/webzone.php');

$current_page = 'locked_page';

include_once('./include/presentation/header.php');
?>

<script>
	$(document).ready(function() {
		
		jQuery(document).on('change', "#locked_content_access", function(event) {
			toggleLockedContent();
		});
		
		toggleLockedContent();
		
		function toggleLockedContent() {
			var val = $('#locked_content_access').val();
			if(val=='redirect') {
				$('#locked_content_redirect_url_box').show();
				$('#locked_content_page_box').hide();
			}
			else {
				$('#locked_content_redirect_url_box').hide();
				$('#locked_content_page_box').show();
			}
		}
	})
</script>

<div class="container">

	<?php
	
	$settings = get_settings();
	
	$form = new Bootstrap_form();
	echo $form->form_open(array('id'=>'settings'));
	
	?>

	<div class="panel panel-primary">
	  <div class="panel-heading">
		  <h3 class="panel-title">Locked content</h3>
	  </div>
	  <div class="panel-body">
		  
	    <?php
		
		$onceConnectedActions = array('redirect'=>'Redirect the user to a URL', 'current_page'=>'Show a specific content');
		$description = 'HTML code possible - Use <font color="green"><i>{name}</i></font> or <font color="green"><i>{picture}</i></font> to replace with connected user data - Use <font color="green"><i>{fb_share}</i></font> to display a Facebook share button';
		
		echo $form->form_input(array('id'=>'unlock_page_text', 'label'=>'Text of the unlock page', 'value'=>$settings['unlock_page_text']));
		
		echo $form->form_select(array('id'=>'locked_content_access', 'label'=>'How to access to the locked content', 'values'=>$onceConnectedActions, 'selected'=>$settings['locked_content_access']));
		
		echo $form->form_input(array('id'=>'locked_content_redirect_url', 'label'=>'Link to redirect the user to after a successful connexion', 'value'=>$settings['locked_content_redirect_url']));
		echo $form->form_textarea(array('id'=>'locked_content_page', 'label'=>'Your locked content', 'value'=>$settings['locked_content_page'], 'height'=>300, 'description'=>$description));
		?>
		
	  </div>
	</div>
	
	<?php
	echo $form->form_submit(array('id'=>'saveSettingsBtn', 'value'=>'Save settings'));
	echo $form->form_close();
	?>
	
</div>

<?php
include_once('./include/presentation/footer.php');
?>