<?php

/*
Last update: 25 Oct 2017
*/

function is_valid_email($email) {
	if (filter_var($email, FILTER_VALIDATE_EMAIL)===false) return false;
	else return true; 
}

//String $option: possible values: full
function getCurrentPageURL($option='') {
	$pageURL = 'http';
	if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
	$pageURL .= "://";
	if ($_SERVER["SERVER_PORT"] != 80 && $_SERVER["SERVER_PORT"] != 443) {
		$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
	}
	else {
		$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
	}
	
	$pageUrlNoParams = $pageURL;
	$pos = strpos($pageUrlNoParams, '?');
	if($pos!==FALSE) {
		$pageUrlNoParams = substr($pageUrlNoParams, 0, $pos);
	}
	
	if($option=='full') return $pageURL;
	else return $pageUrlNoParams;
}

/*
@desc Get results from a remote URL
@param String $url
@return String $data
*/
function getDataFromUrl($url) {
	$ch = curl_init();
	$timeout = 5;
	curl_setopt($ch,CURLOPT_URL,$url);
	curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
	curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); //to make it support SSL calls on some servers
	$data = curl_exec($ch);
	curl_close($ch);
	return $data;
}

function get_ip() {
    if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    elseif(isset($_SERVER['HTTP_CLIENT_IP'])) {
        $ip  = $_SERVER['HTTP_CLIENT_IP'];
    }
    else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

function plain_url_to_link($string) {
  	return preg_replace(
  	'%(https?|ftp)://([-A-Z0-9./_*?&;=#]+)%i', 
  	'<a target="blank" rel="nofollow" href="$0" target="_blank">$0</a>', $string);
}

function trimStr($str) {
    $str = trim($str);
    for($i=0;$i < strlen($str);$i++) {
        if(substr($str, $i, 1) != " ") {
            $ret_str .= trim(substr($str, $i, 1));
        }
        else {
            while(substr($str,$i,1) == " ") {
                $i++;
            }
            $ret_str.= " ";
            $i--; // ***
        }
    }
    return $ret_str;
} 

function cleanURLString($string) {
	$encoding = mb_detect_encoding($string, 'auto');
	if($encoding=='UTF-8') $string = utf8_decode($string);
    
    $a = utf8_decode('ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿ');
    $b = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyyby';
    $string = strtr($string, $a, $b);
    $string = str_replace('?', '', $string);
    
    $string = strtolower($string);
	//echo $string.'<br>';
    $string = preg_replace("/[^a-z0-9]/",' ',$string);
    $string = removeSpaces($string);
    return $string;
}

function removeSpaces($text) {
	$text = trim($text);
	$text = preg_replace("/ -+/","-",$text);
	$text = preg_replace("/- +/","-",$text);
	$text = preg_replace("/ +/","-",$text); // remplace les espaces par -
	return $text;
}

function limit_text($text, $limit, $endChar=' [...]') {
	if( strlen($text)>$limit ) {
		$text = substr( $text,0,$limit );
		$text = substr( $text,0,-(strlen(strrchr($text,' '))) );
		$text .= $endChar;
	}
	return $text;
}

?>