<?php

/*
Lat update: 25 Oct 17	
*/

class ygpChart_class
{
	
	public function displayBarChart($options=array()) {
		$dom = $options['dom'];
		$width = $options['width'];
		$height = $options['height'];
		$title = $options['title'];
		$data = $options['data'];
		$legendPosition = $options['legendPosition'];
		$isStacked = $options['isStacked'];
		
		if($dom=='' || !is_array($data)) return false;
		
		$style = '';
		if($width=='') $style .= 'width:500px;';
		if($height=='') $style .= 'height:300px;';
		if($legendPosition=='') $legendPosition = 'bottom';
		if($isStacked=='') $isStacked = false;
		
		$i=0;
		foreach($data as $ind=>$value) {
			
			//Header
			if($i==0) {
				$formattedData[] = '[\''.implode('\',\'', $value).'\']';
			}
			//Data
			else {
				$k=0;
				$tmpTab=array();
				$formattedData[$i] = '[';
				foreach($value as $value2) {
					if($k==0) $tmpTab[] = '\''.$value2.'\'';
					else $tmpTab[] = $value2;
					$k++;
				}
				$formattedData[$i] .= implode(',', $tmpTab);
				$formattedData[$i] .= ']';
			}
			
			$i++;
		}
		
		?>
		
		<div id="<?php echo $dom; ?>" style="<?php echo $style; ?>"></div>
		
		<script>
		google.charts.load('current', {'packages':['corechart', 'bar']});
		google.charts.setOnLoadCallback(drawChart);
		
		function drawChart() {
			
			var data = google.visualization.arrayToDataTable([
			  <?php //echo $formattedHeader; ?>
			  <?php echo implode(',', $formattedData); ?>
			]);
			
			var options = {
			  title: '<?php echo $title; ?>',
			  legend: {position: '<?php echo $legendPosition; ?>'},
			  isStacked: '<?php echo $isStacked; ?>'
			};
			
			var chart = new google.visualization.BarChart(document.getElementById('<?php echo $dom; ?>'));
			chart.draw(data, options);
		}
		</script>
		
		<?php
	}
	
	/*
	* @desc https://developers.google.com/chart/interactive/docs/gallery/piechart
	*/
	public function displayPieChart($options=array()) {
		$dom = $options['dom'];
		$width = $options['width'];
		$height = $options['height'];
		$title = $options['title'];
		$data = $options['data'];
		$legendPosition = $options['legendPosition'];
		$pieSliceText = $options['pieSliceText'];
		
		if($dom=='' || !is_array($data)) return false;
		
		$style = '';
		if($width=='') $style .= 'width:500px;';
		if($height=='') $style .= 'height:300px;';
		if($legendPosition=='') $legendPosition = 'bottom';
		if($pieSliceText=='') $pieSliceText = 'percentage'; //percentage, value, label, none
		
		//print_r($data); exit();
		
		$i=0;
		foreach($data as $ind=>$value) {
			
			//Header
			if($i==0) {
				$formattedData[] = '[\''.implode('\',\'', $value).'\']';
			}
			//Data
			else {
				$k=0;
				$tmpTab=array();
				$formattedData[$i] = '[';
				foreach($value as $value2) {
					if($k==0) $tmpTab[] = '\''.$value2.'\'';
					else $tmpTab[] = $value2;
					$k++;
				}
				$formattedData[$i] .= implode(',', $tmpTab);
				$formattedData[$i] .= ']';
			}
			
			$i++;
		}
		
		?>
		
		<div id="<?php echo $dom; ?>" style="<?php echo $style; ?>"></div>
		
		<script>
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);
		
		function drawChart() {
			
			var data = google.visualization.arrayToDataTable([
			  <?php //echo $formattedHeader; ?>
			  <?php echo implode(',', $formattedData); ?>
			]);
			
			var options = {
			  title: '<?php echo $title; ?>',
			  pieSliceText: '<?php echo $pieSliceText; ?>',
			  legend: {position: '<?php echo $legendPosition; ?>'},
			};
			
			var chart = new google.visualization.PieChart(document.getElementById('<?php echo $dom; ?>'));
			chart.draw(data, options);
		}
		</script>
		
		<?php
	}
	
}

?>