/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
(function ($) {
    'use strict';
    
    $(document).on('click', '#wcdrp_update_license', wcdrpUpdatePlugin);
    $(document).on('change', 'select[name="wcdrp_rules[wcdrp-appearance][block_layout]"]', blockLayoutTypeChange);

    /**
     * Update license on click "Update" button
     */
    function wcdrpUpdatePlugin(e) {
	e.preventDefault();
	var self = this,
		regex = /<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi;
	$.ajax({
	    beforeSend: function () {
		$(self).attr('disabled', true);
	    },
	    url: wcdrp_updater.ajaxUrl,
	    method: 'POST',
	    data: {
		action: wcdrp_updater.action
	    },
	    success: function (res) {
		if (typeof res === 'string') {
		    $(self).remove();

		    res = res.replace(regex, '');

		    var notice = $('<div >')
			    .addClass('update-notice')
			    .html(res);
		    $(notice).insertAfter('.wcdrp-license-activated-notice');
		}

		$('.notice-warning.update_wp_wcdrp .notice-dismiss').trigger('click');
	    },
	    error: function () {
		console.error(arguments);
	    },
	    complete: function () {
	    }
	});
    }
    
    /**
     * Update Block Layout type
     */
    function blockLayoutTypeChange(e) {
	if( $(this).find('option:selected').val() == 1 ) {
	    $('input#wcdrp_rules_wcdrp-appearance_number_columns_in_slider').closest('tr').show();
	    $('select[name="wcdrp_rules[wcdrp-appearance][show_nav_in_slider]"]').closest('tr').show();
	} else {
	    $('input#wcdrp_rules_wcdrp-appearance_number_columns_in_slider').closest('tr').hide();
	    $('select[name="wcdrp_rules[wcdrp-appearance][show_nav_in_slider]"]').closest('tr').hide();
	}
    }
    
    $('select[name="wcdrp_rules[wcdrp-appearance][block_layout]"]').trigger('change');

})(jQuery);