<?php

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
    die();
}

class WCDRP_Shortcode {

    /**
     * @var WCDRP_Template
     */
    protected $template;

    /**
     * @var WCDRP_Post_type
     */
    protected $post_type;

    public function __construct( $post_type ) {
        $this->post_type = $post_type;
        $this->template  = $this->post_type->get_template();

        add_shortcode( 'linked-products', array( $this, 'linked_products' ) );
    }

    // [linked-products id=1234]
    public function linked_products( $atts ) {
        $rule_id = isset( $atts[ 'id' ] ) ? (int) $atts[ 'id' ] : '';

        if ( ! $rule_id ) {
            return '';
        }

        $this->template->options  = current( get_post_meta( $rule_id, 'wcdrp_rules' ) );
        $this->template->products = $this->post_type->get_linked_products( $this->template->options );
        $this->template->path     = $this->post_type->get_template_path( 'templates' );

        $slider_number_columns[ $id ] = ( isset( $this->template->options[ 'wcdrp-appearance' ][ 'number_columns_in_slider' ] ) ) ? $this->template->options[ 'wcdrp-appearance' ][ 'number_columns_in_slider' ] : 4;
        $show_nav_in_slider[ $id ]    = ( isset( $this->template->options[ 'wcdrp-appearance' ][ 'show_nav_in_slider' ] ) ) ? $this->template->options[ 'wcdrp-appearance' ][ 'show_nav_in_slider' ] : 2;
        if ( $slider_number_columns !== null && $show_nav_in_slider !== null ) {
            wp_localize_script( 'wcdrp_wc-auto-linked-products', 'SliderData', array( 'number_columns' => $slider_number_columns, 'show_nav_in_slider' => $show_nav_in_slider ) );
        }
        return $this->template->render_view( 'linked-products', '', false, $this->template->path );
    }

}
