<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Fonction qui affiche le contenu d'une variable avec une coloration en fonction de son type.
 * 
 * @param mixed $var Variable à afficher.
 */
function highlight_array( $var, $isObject = false )
{
	echo "<code style=\"color:#007700;\">";
	
	if( is_array($var) )
	{
	
		echo "<span class=\"print_s-array\">".($isObject? "Object" : "Array"). "(". count($var) . ")</span>";
		echo "<div>{<div style=\"padding-left:30px;\">";
		
		foreach( $var as $key=>$value )
		{
			$color = is_numeric($key)? "#000000" : "orange";
			
			if( $color=="orange" ) $key = "'$key'";
			
			echo "[<span style=\"color:$color;\">$key</span>] => ";
			highlight_array($value);
		}
		
		echo "</div>}</div>";
	}
	else if( is_null($var) ) echo "<span style=\"color:#0000BB;\">null</span><br />";
	else if( is_bool($var) ) echo "<span style=\"color:#0000BB;\">" . ($var? "true" : "false") . "</span><br />";
	else if( is_numeric($var) ) echo "<span style=\"color:#0000BB;\">$var</span><br />";
	else if( is_object($var) )
	{
		highlight_array((array)$var,true);
	} 
	else echo "<span style=\"color:#DD0000;\">&quot;$var&quot;</span><br />";
	
	echo "</code>";
}

/**
 * Fonction qui affiche le contenu d'un tableau PHP.
 * 
 * @param array $array Tableau PHP.
 * @param string $name (Optionnel) Titre à afficher au dessus du tableau.
 */
function print_array( $array, $name=null )
{
	echo "<br /><fieldset style=\"border:1px solid #c0c0c0; box-shadow: 1px 1px 0 white; border-radius:4px;\">";
	if( !is_null($name) )
		echo "<legend>$name</legend>";
	highlight_array($array);
	echo "</fieldset><br />";	
}


/**
 * Encode un tableau PHP au format JSON. 
 * ATTENTION : Cette fonction effectue un die.
 * 
 * @param array $array Tableau à afficher.
 */
function json__result( $array, $merge=null )
{
	if( is_null($merge) )
		$merge = array();
	
	die(json_encode(array_merge(array('datas'=>$array, '_time'=>time()), $merge)));
}

/**
 * Crée un tableau au format JSON en créant une clée "json_error" à true 
 * et une clée "json_error_value" contenant la valeur de l'erreur.
 * ATTENTION : Cette fonction effectue un die.
 * 
 * @param mixed $err Valeur à retourner dans le tableau d'erreur.
 */
function json__error( $err, $type=null )
{
	if( is_null($type) )
		$type = "UNKNOWN";
	
	if( !is_array($err) )
		$err = array($err);
		
	json__result($err, array('_error'=>$type));
}

/**
 * Encode un tableau PHP au format JSON à partir d'une variable retourner par
 * une fonction SQL. Utilise les fonction erv__*.
 * ATTENTION : Cette fonction effectue un die.
 * 
 * @param array $result Tableau de résultat.
 * @param bool $checkError (Optionnel) Par défaut à true. Si vrai, la fonction s'arrête si l'erreur n'est pas ERR__OK.
 */
function json__func_result( $result, $checkError=true )
{
	if( $checkError )
	{
		if( erv__getErrorCode($result)!=ERR__OK )
			json__error(erv__getError($result));
	}
	
	json__result(erv__getValuesWithoutKey($result));
}

/**
 * Crée un tableau au format JSON pour permettre au javascript d'appeller une fonction.
 * ATTENTION : Cette fonction effectue un die.
 * 
 * @param string $func Nom de la fonction que le javascript doit appeller.
 * @param string $args (Optionnel) Liste des arguments à passer au javascript.
 */
function json__call( $func, $args=null )
{
	if( is_null($args) )
		$args = array();
	
	json__result(array(), array('_call'=>array('func'=>$func, 'args'=>$args)));
}

/**
 * Encode un tableau PHP vide au format JSON.
 * ATTENTION : Cette fonction effectue un die.
 * 
 */
function json__void()
{
	json__result(array());
}


/**
 * Liste d'erreurs
 */

define("ERR__OK",									0x10000000);
define("ERR__CANCEL",								0x10000001);
define("ERR__NO_DATA",								0x10000002);

define("ERR__GENERAL_ERROR",						0x10000005);
define("ERR__FUNCTION_FAILED",						0x10000006);
define("ERR__ARGUMENTS_BAD",						0x10000007);

define("ERR__ATTRIBUTE_READ_ONLY",					0x10000010);

define("ERR__DATA_LEN_RANGE",						0x10000021);

define("ERR__FUNCTION_CANCELED",					0x10000050);
define("ERR__FUNCTION_NOT_SUPPORTED",				0x10000054);
define("ERR__FUNCTION_DOESNT_EXISTS",				0x10000055);

define("ERR__PIN_INCORRECT",						0x100000A0);
define("ERR__PIN_INVALID",							0x100000A1);
define("ERR__PIN_LEN_RANGE",						0x100000A2);
define("ERR__PIN_EXPIRED",							0x100000A3);
define("ERR__PIN_LOCKED",							0x100000A4);
define("ERR__PIN_EXISTS",							0x100000A5);

define("ERR__SESSION_CLOSED",						0x100000B0);
define("ERR__SESSION_READ_ONLY",					0x100000B5);
define("ERR__SESSION_EXISTS",						0x100000B6);

define("ERR__USER_ALREADY_LOGGED_IN",				0x10000100);
define("ERR__USER_NOT_LOGGED_IN",					0x10000101);
define("ERR__USER_PIN_NOT_INITIALIZED",				0x10000102);
define("ERR__USER_TYPE_INVALID",					0x10000103);
define("ERR__USER_HAVE_NO_RIGHTS",					0x10000104);
define("ERR__USER_PROFILE_CHANGED",					0x10000105);
define("ERR__USER_COMPANY_CHANGED",					0x10000106);
define("ERR__USER_ADDED",							0x10000107);
define("ERR__USER_COMPANY_LOCATION_CHANGED",		0x10000108);
define("ERR__CUSTOMER_ADDED",						0x10000109);
define("ERR__CUSTOMER_LOCATION_CHANGED",			0x10000110);
define("ERR__CUSTOMER_CHANGED",						0x10000111);
define("ERR__OPTION_CHANGED",						0x10000112);
define("ERR__PLACE_ATTACHMENT_DELETED",				0x10000113);
define("ERR__GEAR_ADDED",							0x10000114);
define("ERR__GEAR_CHANGED",							0x10000115);
define("ERR__PLACE_ADDED",							0x10000116);
define("ERR__PLACE_CHANGED",						0x10000117);
define("ERR__BANISH_DONE",							0x10000118);
define("ERR__UNBANISH_DONE",						0x10000119);
define("ERR__MISSION_TYPE_ADDED",					0x10000120);
define("ERR__MISSION_TYPE_CHANGED",					0x10000121);
define("ERR__MISSION_ADDED",						0x10000122);
define("ERR__USER_LINKED_TO_MISSION",				0x10000123);
define("ERR__USER_UNLINKED_TO_MISSION",				0x10000124);
define("ERR__MISSION_CHANGED",						0x10000125);
define("ERR__GEAR_LINKED_TO_MISSION",				0x10000126);
define("ERR__GEAR_UNLINKED_TO_MISSION",				0x10000127);
define("ERR__PICTURE_SELECTED",						0x10000128);
define("ERR__PICTURE_CHANGED",						0x10000129);
define("ERR__PICTURE_PROCESSED",					0x10000130);

define("ERR__FUNCTION_REJECTED",					0x10000200);

define("ERR__QUERY_FAILED",							0x10000300);
define("ERR__QUERY_NEEDS_KEY_TO_LOAD",				0x10000301);
define("ERR__QUERY_RETURNS_BAD_RESULTS",			0x10000302);
define("ERR__QUERY_RETURNS_NO_DATA",				0x10000303);
define("ERR__QUERY_RETURNS_DUPLICATE_ENTRY",		0x10000304);

define("ERR__NOTHING_TO_DO",						0x10000400);
define("ERR__ACTION_NEEDED",						0x10000401);
define("ERR__UNKNOWN_ACTION",						0x10000402);
define("ERR__ARGS_CONDITION_NEEDED",				0x10000403);
define("ERR__CLASS_NEEDED",							0x10000404);
define("ERR__CANT_CONNECT_TO_DATABASE",				0x10000405);
define("ERR__UNKNOWN_LOCATION",						0x10000406);
define("ERR__NEED_ALL_FIELDS",						0x10000407);

define("ERR__FILES_FOLDER_DOSENT_EXISTS",			0x10000500);
define("ERR__FILES_EXTENSION_NOT_SUPPORTED",		0x10000501);
define("ERR__FILES_MIN_SIZE",						0x10000502);
define("ERR__FILES_MAX_SIZE",						0x10000503);
define("ERR__FILES_UPLOADED",						0x10000504);
define("ERR__FILES_NOT_AN_IMAGE",					0x10000505);
define("ERR__FILES_CREATION_FAILED",				0x10000506);

define("ERR__RANK_ALREADY_EXISTS",					0x10000600);
define("ERR__RANK_NAME_EXISTS",						0x10000601);
define("ERR__RANK_TOO_LOW",							0x10000602);


function error_name($err_code)
{
	switch($err_code)
	{

		case ERR__OK : return("ERR__OK");
		case ERR__CANCEL : return("ERR__CANCEL");
		case ERR__NO_DATA : return("ERR__NO_DATA");

		case ERR__GENERAL_ERROR : return("ERR__GENERAL_ERROR");
		case ERR__FUNCTION_FAILED : return("ERR__FUNCTION_FAILED");
		case ERR__ARGUMENTS_BAD : return("ERR__ARGUMENTS_BAD");

		case ERR__ATTRIBUTE_READ_ONLY : return("ERR__ATTRIBUTE_READ_ONLY");

		case ERR__DATA_LEN_RANGE : return("ERR__DATA_LEN_RANGE");

		case ERR__FUNCTION_CANCELED : return("ERR__FUNCTION_CANCELED");
		case ERR__FUNCTION_NOT_SUPPORTED : return("ERR__FUNCTION_NOT_SUPPORTED");
		case ERR__FUNCTION_DOESNT_EXISTS : return("ERR__FUNCTION_DOESNT_EXISTS");

		case ERR__PIN_INCORRECT : return("ERR__PIN_INCORRECT");
		case ERR__PIN_INVALID : return("ERR__PIN_INVALID");
		case ERR__PIN_LEN_RANGE : return("ERR__PIN_LEN_RANGE");
		case ERR__PIN_EXPIRED : return("ERR__PIN_EXPIRED");
		case ERR__PIN_EXISTS : return("ERR__PIN_EXISTS");

		case ERR__SESSION_CLOSED : return("ERR__SESSION_CLOSED");
		case ERR__SESSION_READ_ONLY : return("ERR__SESSION_READ_ONLY");
		case ERR__SESSION_EXISTS : return("ERR__SESSION_EXISTS");
		case ERR__SESSION_EXISTS : return("ERR__SESSION_EXISTS");

		case ERR__USER_ALREADY_LOGGED_IN : return("ERR__USER_ALREADY_LOGGED_IN");
		case ERR__USER_NOT_LOGGED_IN : return("ERR__USER_NOT_LOGGED_IN");
		case ERR__USER_PIN_NOT_INITIALIZED : return("ERR__USER_PIN_NOT_INITIALIZED");
		case ERR__USER_TYPE_INVALID : return("ERR__USER_TYPE_INVALID");
		case ERR__USER_HAVE_NO_RIGHTS : return("ERR__USER_HAVE_NO_RIGHTS");
		case ERR__USER_PROFILE_CHANGED : return("ERR__USER_PROFILE_CHANGED");
		case ERR__USER_COMPANY_CHANGED : return("ERR__USER_COMPANY_CHANGED");
		case ERR__USER_ADDED : return("ERR__USER_ADDED");
		case ERR__USER_COMPANY_LOCATION_CHANGED : return("ERR__USER_COMPANY_LOCATION_CHANGED");
		case ERR__CUSTOMER_ADDED : return("ERR__CUSTOMER_ADDED");
		case ERR__CUSTOMER_LOCATION_CHANGED : return("ERR__CUSTOMER_LOCATION_CHANGED");
		case ERR__CUSTOMER_CHANGED : return("ERR__CUSTOMER_CHANGED");
		case ERR__OPTION_CHANGED : return("ERR__OPTION_CHANGED");
		case ERR__GEAR_ADDED : return("ERR__GEAR_ADDED");
		case ERR__GEAR_CHANGED : return("ERR__GEAR_CHANGED");
		case ERR__MISSION_TYPE_ADDED : return("ERR__MISSION_TYPE_ADDED");
		case ERR__MISSION_TYPE_CHANGED : return("ERR__MISSION_TYPE_CHANGED");
		case ERR__MISSION_ADDED : return("ERR__MISSION_ADDED");
		case ERR__USER_LINKED_TO_MISSION : return("ERR__USER_LINKED_TO_MISSION");
		case ERR__USER_UNLINKED_TO_MISSION : return("ERR__USER_UNLINKED_TO_MISSION");
		case ERR__MISSION_CHANGED : return("ERR__MISSION_CHANGED");
		case ERR__PICTURE_SELECTED : return("ERR__PICTURE_SELECTED");
		case ERR__PICTURE_CHANGED : return("ERR__PICTURE_CHANGED");
		case ERR__PICTURE_PROCESSED : return("ERR__PICTURE_PROCESSED");

		case ERR__FUNCTION_REJECTED : return("ERR__FUNCTION_REJECTED");

		case ERR__QUERY_FAILED : return("ERR__QUERY_FAILED");
		case ERR__QUERY_NEEDS_KEY_TO_LOAD : return("ERR__QUERY_NEEDS_KEY_TO_LOAD");
		case ERR__QUERY_RETURNS_BAD_RESULTS : return("ERR__QUERY_RETURNS_BAD_RESULTS");
		case ERR__QUERY_RETURNS_NO_DATA : return("ERR__QUERY_RETURNS_NO_DATA");

		case ERR__NOTHING_TO_DO : return("ERR__NOTHING_TO_DO");
		case ERR__ACTION_NEEDED : return("ERR__ACTION_NEEDED");
		case ERR__UNKNOWN_ACTION : return("ERR__UNKNOWN_ACTION");
		case ERR__ARGS_CONDITION_NEEDED : return("ERR__ARGS_CONDITION_NEEDED");
		case ERR__CLASS_NEEDED : return("ERR__CLASS_NEEDED");
		case ERR__CANT_CONNECT_TO_DATABASE : return("ERR__CANT_CONNECT_TO_DATABASE");
		case ERR__UNKNOWN_LOCATION : return("ERR__UNKNOWN_LOCATION");
		case ERR__NEED_ALL_FIELDS : return("ERR__NEED_ALL_FIELDS");
		
		case ERR__FILES_FOLDER_DOSENT_EXISTS : return("ERR__FILES_FOLDER_DOSENT_EXISTS");
		case ERR__FILES_EXTENSION_NOT_SUPPORTED : return("ERR__FILES_EXTENSION_NOT_SUPPORTED");
		case ERR__FILES_MIN_SIZE : return("ERR__FILES_MIN_SIZE");
		case ERR__FILES_MAX_SIZE : return("ERR__FILES_MAX_SIZE");
		case ERR__FILES_UPLOADED : return("ERR__FILES_UPLOADED");
		case ERR__FILES_NOT_AN_IMAGE : return("ERR__FILES_NOT_AN_IMAGE");

		case ERR__RANK_ALREADY_EXISTS : return("ERR__RANK_ALREADY_EXISTS");
		case ERR__RANK_NAME_EXISTS : return("ERR__RANK_NAME_EXISTS");
		case ERR__RANK_TOO_LOW : return("ERR__RANK_TOO_LOW");
		
		default:return "default";

	}
}

?>